/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.defaults;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import oracle.dbtools.migration.parser.OracleSQLConstants;
import oracle.dbtools.migration.parser.ext.ExtStringTemplate;
import oracle.dbtools.migration.translation.api.IHierarchicalTranslationNameScope;
import oracle.dbtools.migration.translation.api.IObjectNameEntity;
import oracle.dbtools.migration.translation.api.IStatementObjectNameScopeEntity;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationDatabase;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;

public class DefaultTranslationContext
implements ITranslationContext {
    private TranslationPreferences m_prefs = null;
    private static final String NOTALLOWEDCHARS = " ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3";
    private static final String TEMPORARYNAME = "#";
    private static final String TEMPTABLEPREFIX = "tt_";
    private static final String DIGITS = "0123456789";
    private static final String EXTRAALLOWED = "_$";
    private HashMap<String, Integer> m_dynamicObjectsIncrement = new HashMap();
    private HashMap<String, String> m_dynamicObjectOwners = new HashMap();

    @Override
    public TranslationPreferences getTranslationPreferences(Object object) {
        return this.m_prefs;
    }

    @Override
    public TranslationDatabase getExpectedTargetDatabase(Object object) {
        return null;
    }

    @Override
    public TranslationDatabase getSourceDatabase(Object object) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public TranslationDataType getTargetDataType(TranslationDataType translationDataType, Object object) {
        return null;
    }

    @Override
    public void completeSourceObject(TranslationDBObjectReference translationDBObjectReference, Object object) throws TranslationObjectNotFoundException {
    }

    @Override
    public void completeSourceColumn(TranslationColumn translationColumn, Object object) throws TranslationObjectNotFoundException {
    }

    @Override
    public TranslationDBObjectReference getTargetDBObjectReference(TranslationDBObjectReference translationDBObjectReference, Object object) throws TranslationObjectNotFoundException {
        if (translationDBObjectReference == null) {
            return null;
        }
        TranslationDBObjectReference translationDBObjectReference2 = new TranslationDBObjectReference(translationDBObjectReference);
        translationDBObjectReference2.setServerName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getServerName(), "server"));
        translationDBObjectReference2.setDatabaseName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getDatabaseName(), "database"));
        translationDBObjectReference2.setOwnerName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getOwnerName(), "owner"));
        translationDBObjectReference2.setObjName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getObjName(), "object"));
        translationDBObjectReference2.setPartName(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getPartName(), "part"));
        translationDBObjectReference2.setAlias(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getAlias(), "object"));
        translationDBObjectReference2.setObjectAlias(DefaultTranslationContext.createValidIdentifier(translationDBObjectReference.getObjectAlias(), "object"));
        return translationDBObjectReference2;
    }

    public static String createValidIdentifier(String string, String string2) {
        try {
            if (string == null || string.trim().equals("")) {
                return string;
            }
            String string3 = string;
            if (string3.trim().equals("\"\"")) {
                return string3;
            }
            if (string3.trim().startsWith("'") && string3.trim().endsWith("'")) {
                return string3;
            }
            string3 = DefaultTranslationContext.removeQuoteCharacters(string3);
            if (string2.equals("object")) {
                int n = -999999996;
                try {
                    n = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n != -999999996) {
                    return "A_" + string3;
                }
            }
            String string4 = string3;
            if ((string3 = DefaultTranslationContext.leftTrimNonAlphaNumeric(string3)).length() == 0) {
                return "\"" + string4 + "\"";
            }
            string3 = DefaultTranslationContext.firstCharCheck(string3, string2);
            string3 = DefaultTranslationContext.temporaryObjectCheck(string3);
            string3 = DefaultTranslationContext.removeInvalidCharacters(string3);
            string3 = DefaultTranslationContext.trimToSize(string3, 30);
            string3 = DefaultTranslationContext.modifyReservedNames(string3);
            return string3;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String createValidObjectNameForScratchEditor(String string) {
        String string2 = string;
        string2 = DefaultTranslationContext.temporaryObjectCheck(string2);
        string2 = DefaultTranslationContext.removeInvalidCharacters(string2);
        string2 = DefaultTranslationContext.trimToSize(string2, 30);
        return string2;
    }

    private static String temporaryObjectCheck(String string) {
        if (string.trim().startsWith(TEMPORARYNAME)) {
            // empty if block
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static String removeInvalidCharacters(String string) {
        void var6_9;
        char[] cArray = string.toCharArray();
        int n = 0;
        for (char n2 : cArray) {
            if (NOTALLOWEDCHARS.indexOf(n2) != -1) {
                cArray[n] = 95;
            }
            ++n;
        }
        n = 0;
        Object object = new StringBuffer();
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        boolean bl = false;
        while (var6_9 < n2) {
            char c = cArray2[var6_9];
            if (c == '_') {
                if (cArray.length == n + 1) {
                    ((StringBuffer)object).append(c);
                } else if (cArray.length > n + 1 && cArray[n + 1] != '_') {
                    ((StringBuffer)object).append(c);
                }
            } else {
                ((StringBuffer)object).append(c);
            }
            ++n;
            ++var6_9;
        }
        return ((StringBuffer)object).toString();
    }

    private static String modifyReservedNames(String string) {
        if (OracleSQLConstants.isSignificantWord(string) || OracleSQLConstants.isRservedWord(string)) {
            string = string + "_";
        }
        return string;
    }

    private static String trimToSize(String string, int n) {
        if (string != null && string.trim().length() > n) {
            string = string.trim().substring(0, n);
        }
        return string;
    }

    private static String firstCharCheck(String string, String string2) {
        char c = string.charAt(0);
        if (" ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3_$0123456789".indexOf(c) != -1) {
            string = "A" + string;
        }
        return string;
    }

    private static String leftTrimNonAlphaNumeric(String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (" ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3_$".indexOf(c) == -1) break;
            ++n;
        }
        return string.substring(n);
    }

    protected static String removeQuoteCharacters(String string) {
        if (string != null && (string.trim().startsWith("[") && string.trim().endsWith("]") || string.trim().startsWith("\"") && string.trim().endsWith("\""))) {
            string = string.trim().substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public ArrayList<TranslationColumn> getSourceColumns(TranslationDBObjectReference translationDBObjectReference) {
        return null;
    }

    @Override
    public ArrayList<TranslationColumn> getTargetColumns(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationParameter> getSourceParameters(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationParameter> getTargetParameters(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationDBObjectReference> getObjectsDependentOnThisSource(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationDBObjectReference> getObjectsDependentOnThisTarget(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationDBObjectReference> getSourceObjectsThisDependsOn(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<TranslationDBObjectReference> getTargetObjectsThisDependsOn(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public ArrayList<String> getEmulationFuncsForSchema(Object object) {
        return null;
    }

    @Override
    public ArrayList<String> getEmulationFuncsForConnection(Object object) {
        return null;
    }

    @Override
    public void addInfoKeyValue(String string, String string2) {
    }

    @Override
    public String getInfoKeyValue(String string) {
        return null;
    }

    @Override
    public void clearInfoKey() {
    }

    @Override
    public void setPreferences(TranslationPreferences translationPreferences) {
        this.m_prefs = translationPreferences;
    }

    @Override
    public String getExistingDynamicName(String string, TranslationDBObjectReference translationDBObjectReference) {
        if (this.m_dynamicObjectOwners.containsKey(this.getDynamicKey(string, translationDBObjectReference))) {
            return this.m_dynamicObjectOwners.get(this.getDynamicKey(string, translationDBObjectReference));
        }
        return this.getNewDynamicName(string, translationDBObjectReference);
    }

    private String getDecentName(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        string = string.replaceFirst("^#+", "");
        return this.subStringUpTo(string, 27);
    }

    @Override
    public String getNewDynamicName(String string, TranslationDBObjectReference translationDBObjectReference) {
        String string2 = translationDBObjectReference != null ? translationDBObjectReference.getIdentifierName() : "UNKNOWN";
        String string3 = "tt";
        String string4 = this.subStringUpTo(this.getDecentName(string), 24);
        String string5 = string3 + "_" + string4;
        int n = this.getUniqueNumber(string5);
        if (n != 1) {
            string5 = string5 + "_" + n;
        }
        this.m_dynamicObjectOwners.put(this.getDynamicKey(string, translationDBObjectReference), string5);
        return string5;
    }

    private String getDynamicKey(String string, TranslationDBObjectReference translationDBObjectReference) {
        return translationDBObjectReference != null ? translationDBObjectReference.getFullName() : "UNKNOWN:" + string;
    }

    private String subStringUpTo(String string, int n) {
        String string2 = string.length() > n ? string.substring(0, n) : string;
        return string2;
    }

    private int getUniqueNumber(String string) {
        int n = 1;
        if (this.getDynamicObjects().containsKey(string)) {
            n = this.getDynamicObjects().get(string) + 1;
        }
        this.setDynamicObjects(string, n);
        return n;
    }

    private HashMap<String, Integer> getDynamicObjects() {
        return this.m_dynamicObjectsIncrement;
    }

    private void setDynamicObjects(String string, int n) {
        if (this.m_dynamicObjectsIncrement.containsKey(string)) {
            this.m_dynamicObjectsIncrement.remove(string);
        }
        this.getDynamicObjects().put(string, n);
    }

    @Override
    public LinkedList<Long> getViewGenOrderList() {
        return null;
    }

    @Override
    public void setViewGenOrderList(LinkedList<Long> linkedList) {
    }

    @Override
    public boolean getUseViewList() {
        return false;
    }

    @Override
    public void setUseViewList(boolean bl) {
    }

    @Override
    public void determineViewGenerationOrder(TranslationDBObject translationDBObject, ExtStringTemplate extStringTemplate) {
    }

    @Override
    public String getChangedIdentifierName(String string) {
        return null;
    }

    @Override
    public String getEmulationPackageName() {
        return null;
    }

    @Override
    public void setEmulationPackageName(String string) {
    }

    @Override
    public Object getPersistableCopy(TranslationDBObjectReference translationDBObjectReference, Object object) throws TranslationObjectNotFoundException {
        return null;
    }

    @Override
    public IObjectNameEntity getTransformedObjectIdentifier(String string, String string2, String string3, String string4, String string5) throws Exception {
        throw new Exception("DefaultTranslationContext doesn't support ObjectIdentifier translation as there is no associated repository");
    }

    @Override
    public IObjectNameEntity getTransformedObjectIdentifierForce(String string, String string2, String string3, String string4, String string5) throws Exception {
        throw new Exception("DefaultTranslationContext doesn't support ObjectIdentifier translation as there is no associated repository");
    }

    @Override
    public IHierarchicalTranslationNameScope newHierarchicalTranslationNameScope() {
        return null;
    }

    @Override
    public IStatementObjectNameScopeEntity newStatementObjectNameScopeEntity(String string, String string2, String string3, boolean bl) {
        return null;
    }

    @Override
    public String getDefaultSchema() {
        return null;
    }

    @Override
    public void setDefaultSchema(String string) {
    }

    @Override
    public int getObjIndex() {
        return 0;
    }

    @Override
    public void setObjIndex(int n) {
    }

    @Override
    public int getObjCount() {
        return 0;
    }

    @Override
    public void setObjCount(int n) {
    }

    @Override
    public void setPersistenceUtilityCache(boolean bl) {
    }
}

