/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug.streams;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.plugin.StreamDebugger;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleBytecode;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.runner.debug.streams.MethodCallExpressionInfo;

public class LambdaExpressionInfo
extends MethodCallExpressionInfo {
    private static Map<String, HelpersForMethod> helpersByMethod = new HashMap<String, HelpersForMethod>();
    private Project project;
    private String lambdaHelperMethodName;
    private int invokeDynamicBytecodeOffset;
    private int helperMethodEntryOffset = -1;
    private int helperMethodExitOffset = 0;
    private static Log logger = StreamDebugger.getLogger();

    public static void clearHelperMatchingInfo() {
        helpersByMethod.clear();
    }

    public void setInvokeDynamicBytecodeOffset(int b) {
        this.invokeDynamicBytecodeOffset = b;
    }

    public int getOffset() {
        return this.invokeDynamicBytecodeOffset;
    }

    public void setHelperMethodEntryOffset(int value) {
        this.helperMethodEntryOffset = value;
    }

    public int getHelperMethodEntryOffset() {
        return this.helperMethodEntryOffset;
    }

    public void setHelperMethodExitOffset(int value) {
        this.helperMethodExitOffset = value;
    }

    public int getHelperMethodExitOffset() {
        return this.helperMethodExitOffset;
    }

    public void setLambdaHelperMethodName(String name) {
        this.lambdaHelperMethodName = name;
    }

    public String getLambdaHelperMethodName() {
        return this.lambdaHelperMethodName;
    }

    @Override
    public String toString() {
        return "LambdaExpressionInfo " + this.expressionText + " " + " (line " + this.lineNumber + " source " + this.sourceOffset + " lambda @ " + this.invokeDynamicBytecodeOffset + ")";
    }

    @Override
    public int attachBytecodes(List<DebugDisassembleBytecode> ddbs, DebugMethodInfo method) {
        String[] argumentTypes;
        String returnType;
        HelperMethod match;
        this.findHelperMethodInfo(method);
        String fqName = method.getName();
        HelpersForMethod potentialMatches = helpersByMethod.get(fqName);
        if (potentialMatches != null && (match = potentialMatches.getHelperMatching(this.expressionText, returnType = LambdaExpressionInfo.extractReturnTypeFromSignature(fqName), argumentTypes = LambdaExpressionInfo.extractArgTypesFromSignature(fqName))) != null) {
            this.lambdaHelperMethodName = match.helperMethodSignature;
            this.helperMethodEntryOffset = match.entryOffset;
            this.helperMethodExitOffset = match.exitOffset;
        }
        int consumed = 0;
        Iterator<DebugDisassembleBytecode> ddbiter = ddbs.iterator();
        while (ddbiter.hasNext()) {
            DebugDisassembleBytecode ddb = ddbiter.next();
            if (!ddb.getBytecode().startsWith("invokedynamic")) continue;
            this.invokeDynamicBytecodeOffset = ddb.getOffset();
            ddbiter.remove();
            ++consumed;
            logger.trace("LambdaExpressionInfo.attachBytescodes to " + this.getText() + " consumes " + ddb.getOffset() + " " + ddb.getBytecode());
            break;
        }
        return consumed;
    }

    private void findHelperMethodInfo(DebugMethodInfo currentMethod) {
        DebugClassInfo classInfo = currentMethod.getClassInfo();
        DebugMethodInfo[] methods = classInfo.getMethods();
        String fqName = currentMethod.getName();
        if (helpersByMethod.get(fqName) != null) {
            return;
        }
        HelpersForMethod helpersForMethod = new HelpersForMethod();
        helpersByMethod.put(fqName, helpersForMethod);
        String simpleName = currentMethod.getNameWithoutClassOrSignature();
        for (DebugMethodInfo method : methods) {
            String methodName = method.getName();
            if (!methodName.contains(simpleName) || !methodName.contains(".lambda$")) continue;
            logger.trace(" Collecting lambda helper info for " + methodName);
            HelperMethod hm = new HelperMethod(method, this.project);
            helpersForMethod.addHelperMethod(hm);
        }
    }

    private static String[] extractArgTypesFromSignature(String sig) {
        String argList = sig.substring(sig.indexOf(40) + 1, sig.indexOf(41));
        String[] args = argList.split(",");
        return args;
    }

    private static String extractReturnTypeFromSignature(String sig) {
        return sig.substring(0, sig.indexOf(32));
    }

    private static class HelpersForMethod {
        List<HelperMethod> helpers = new ArrayList<HelperMethod>();

        private HelpersForMethod() {
        }

        public void addHelperMethod(HelperMethod hm) {
            this.helpers.add(hm);
        }

        public HelperMethod getHelperMatching(String opText, String returnType, String[] argumentTypes) {
            logger.trace("LambdaExpressionInfo getHelperMatching() trying to match " + opText);
            HelperMethod bestMatch = null;
            for (HelperMethod candidate : this.helpers) {
                if (candidate.matched) {
                    logger.trace(" eliminating " + candidate.helperMethodSignature + " because already matched");
                    continue;
                }
                if (bestMatch == null) {
                    bestMatch = candidate;
                    continue;
                }
                if (candidate.helperMethodSequence >= bestMatch.helperMethodSequence) continue;
                bestMatch = candidate;
            }
            if (bestMatch != null) {
                bestMatch.matched = true;
            }
            return bestMatch;
        }
    }

    private static class HelperMethod {
        DebugMethodInfo methodInfo;
        String helperMethodSignature;
        int helperMethodSequence;
        String returnType;
        String[] argTypes;
        boolean matched;
        int entryOffset;
        int exitOffset;

        public HelperMethod(DebugMethodInfo info, Project project) {
            DebugDisassembleInfo[] ddi;
            int hn;
            this.methodInfo = info;
            this.helperMethodSignature = info.getName();
            this.returnType = LambdaExpressionInfo.extractReturnTypeFromSignature(this.helperMethodSignature);
            this.argTypes = LambdaExpressionInfo.extractArgTypesFromSignature(this.helperMethodSignature);
            int start = this.helperMethodSignature.lastIndexOf(36) + 1;
            int end = this.helperMethodSignature.indexOf(40);
            String helperNum = this.helperMethodSignature.substring(start, end);
            this.helperMethodSequence = hn = Integer.parseInt(helperNum);
            this.matched = false;
            for (DebugDisassembleInfo ddinfo : ddi = info.disassembleMethod(false, true, false, project)) {
                DebugDisassembleBytecode ddb = (DebugDisassembleBytecode)ddinfo;
                if (this.entryOffset == -1) {
                    this.entryOffset = ddb.getOffset();
                }
                if (!ddb.getBytecode().contains("return")) continue;
                this.exitOffset = ddb.getOffset();
            }
        }
    }
}

