/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Project;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorController;
import oracle.jdevimpl.runner.debug.EvaluatorDataItem;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.VersionedDataItem;
import oracle.jdevimpl.runner.debug.WatchPanel;

final class WatchController
extends EvaluatorController {
    private static final String WATCH_KEY_COUNT = "Watch.Count";
    private static final String WATCH_KEY_PREFIX = "Watch.";
    private static final String WATCH_KEY_DOT = ".";
    private static final String WATCH_KEY_SCOPE = "scope";
    private static final String WATCH_KEY_EXPRESSION = "expression";
    private static final String WATCH_KEY_NAME = "name";
    private static final String WATCH_KEY_SHOWPINNEDDISCARDED = "showPinnedDiscarded";
    private static final String GlobalWatchScope = "GlobalWatchScope";
    static IdeAction actionRemoveWatch;
    static IdeAction actionAddNewWatch;
    static IdeAction actionRemoveAllWatches;
    private static IdeAction actionPin;
    private static IdeAction actionUnpin;
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAddNewWatch;
    private static JMenuItem menuitemRemoveWatch;
    private static JMenuItem menuitemRemoveAllWatches;
    private static JMenuItem menuitemSettings;
    private static final int ADD_NEW_WATCH_CMD_ID;
    private static final int REMOVE_WATCH_CMD_ID;
    private static final int PIN_CMD_ID;
    private static final int UNPIN_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int REMOVE_ALL_WATCHES_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    private Map<String, List<EvaluatorItem>> allWatches;

    WatchController(DataPanelSettings dataPanelSettings, WatchPanel watchPanel) {
        super(dataPanelSettings, watchPanel);
        this.setControllerForActions();
        this.assignSuperClassActions();
        this.loadWatches((PropertyAccess)Ide.getIdeProperties());
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionRemoveWatch, actionPin, actionUnpin, actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionAddNewWatch, actionRemoveAllWatches, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    private void assignSuperClassActions() {
        this._actionPin = actionPin;
        this._actionUnpin = actionUnpin;
        this._actionViewWhole = actionViewWhole;
        this._actionViewAnnotations = actionViewAnnotations;
        this._actionViewAnnotationsForClass = actionViewAnnotationsForClass;
        this._actionAdjustRange = actionAdjustRange;
        this._actionToggleValue = actionToggleValue;
        this._actionModifyValue = actionModifyValue;
        this._actionWatch = actionWatch;
        this._actionInspect = actionInspect;
        this._actionWatchClassLoader = actionWatchClassLoader;
        this._actionInspectClassLoader = actionInspectClassLoader;
        this._actionGoto = actionGoto;
        this._actionGotoDeclared = actionGotoDeclared;
        this._actionGotoField = actionGotoField;
        this._actionUseFilters = actionUseFilters;
        this._actionObjectPreferences = actionObjectPreferences;
        this._actionCollapseAll = actionCollapseAll;
        this._actionSave = actionSave;
        this._actionSettings = actionSettings;
        this._PIN_CMD_ID = PIN_CMD_ID;
        this._UNPIN_CMD_ID = UNPIN_CMD_ID;
        this._VIEW_WHOLE_CMD_ID = VIEW_WHOLE_CMD_ID;
        this._VIEW_ANNOTATIONS_CMD_ID = VIEW_ANNOTATIONS_CMD_ID;
        this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
        this._ADJUST_RANGE_CMD_ID = ADJUST_RANGE_CMD_ID;
        this._TOGGLE_VALUE_CMD_ID = TOGGLE_VALUE_CMD_ID;
        this._MODIFY_VALUE_CMD_ID = MODIFY_VALUE_CMD_ID;
        this._WATCH_CMD_ID = WATCH_CMD_ID;
        this._INSPECT_CMD_ID = INSPECT_CMD_ID;
        this._WATCH_CLASSLOADER_CMD_ID = WATCH_CLASSLOADER_CMD_ID;
        this._INSPECT_CLASSLOADER_CMD_ID = INSPECT_CLASSLOADER_CMD_ID;
        this._GOTO_CMD_ID = GOTO_CMD_ID;
        this._GOTO_DECLARED_CMD_ID = GOTO_DECLARED_CMD_ID;
        this._GOTO_FIELD_CMD_ID = GOTO_FIELD_CMD_ID;
        this._USE_FILTERS_CMD_ID = USE_FILTERS_CMD_ID;
        this._OBJECT_PREFERENCES_CMD_ID = OBJECT_PREFERENCES_CMD_ID;
        this._COLLAPSE_ALL_CMD_ID = COLLAPSE_ALL_CMD_ID;
        this._SAVE_CMD_ID = SAVE_CMD_ID;
    }

    @Override
    protected void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, actionAddNewWatch, menuitemAddNewWatch, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_NEW_ITEM_CTXT_MENU);
        super.addPopupMenuItemsForNew(popup, context);
    }

    @Override
    protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, actionRemoveWatch, menuitemRemoveWatch, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        super.addPopupMenuItemsForDataItem(popup, context);
    }

    @Override
    protected void addPopupMenuItemsForData(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, actionRemoveAllWatches, menuitemRemoveAllWatches, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        super.addPopupMenuItemsForData(popup, context);
    }

    @Override
    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        super.addPopupMenuItemsForCommon(popup, context);
        this.addPopupItem(popup, context, actionSettings, menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_COMMON_CTXT_MENU);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            DataTable dataTable = this.getDataPanel().getDataTable();
            if (dataTable == null || !this.getDataPanel().getDockableWindow().isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(dataTable.getTable().isEnabled() && this.getDebuggingProcess() != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == REMOVE_WATCH_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem instanceof VersionedDataItem) {
                if (((VersionedDataItem)dataItem).getEvaluatorDataItem() != null) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (dataItem instanceof EvaluatorDataItem) {
                action.setEnabled(true);
            } else if (dataItem != null && dataItem.info instanceof EvaluatorDataItem) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == ADD_NEW_WATCH_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == REMOVE_ALL_WATCHES_CMD_ID) {
            action.setEnabled(this.canRemoveAllWatches());
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return super.update(action, context);
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == REMOVE_WATCH_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem instanceof EvaluatorDataItem) {
                this.removeWatch(((EvaluatorDataItem)dataItem).ei);
            } else if (dataItem instanceof VersionedDataItem) {
                EvaluatorDataItem edi = ((VersionedDataItem)dataItem).getEvaluatorDataItem();
                if (edi != null) {
                    this.removeWatch(edi.ei);
                }
            } else if (dataItem.info instanceof EvaluatorDataItem) {
                this.removeWatch(((EvaluatorDataItem)dataItem.info).ei);
            }
            return true;
        }
        if (cmdId == ADD_NEW_WATCH_CMD_ID) {
            this.addWatchDialog("");
            return true;
        }
        if (cmdId == REMOVE_ALL_WATCHES_CMD_ID) {
            this.removeAllWatches();
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(621), DbgArb.getString(692)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        return super.handleEvent(action, context);
    }

    private EvaluatorItem[] getWatchesForProcess(DebuggingProcess debuggingProcess) {
        List<EvaluatorItem> watchesForProject = this.getWatchesForProject(debuggingProcess);
        if (watchesForProject != null) {
            ArrayList<EvaluatorItem> watchesForProcess = new ArrayList<EvaluatorItem>();
            int size = watchesForProject.size();
            for (int i = 0; i < size; ++i) {
                EvaluatorItem ei = watchesForProject.get(i);
                DebuggingProcess temporary = ei.getTemporary();
                if (temporary != debuggingProcess && temporary != null) continue;
                watchesForProcess.add(ei);
            }
            return watchesForProcess.toArray(new EvaluatorItem[watchesForProcess.size()]);
        }
        return new EvaluatorItem[0];
    }

    private List<EvaluatorItem> getWatchesForProject(DebuggingProcess debuggingProcess) {
        if (debuggingProcess != null) {
            Project project = debuggingProcess.getProject();
            String scope = project != null && project != Ide.getDefaultProject() ? project.getURL().toString() : GlobalWatchScope;
            List<EvaluatorItem> list = this.allWatches.get(scope);
            if (list == null) {
                list = new ArrayList<EvaluatorItem>();
                this.allWatches.put(scope, list);
            }
            return list;
        }
        return null;
    }

    private boolean canRemoveAllWatches() {
        List<EvaluatorItem> watches = this.getWatchesForProject(this.getDebuggingProcess());
        return watches != null && watches.size() > 0;
    }

    private void removeAllWatches() {
        List<EvaluatorItem> watches = this.getWatchesForProject(this.getDebuggingProcess());
        if (watches != null) {
            watches.clear();
            this.everythingChanged();
        }
    }

    private void loadWatches(PropertyAccess properties) {
        this.allWatches = new HashMap<String, List<EvaluatorItem>>();
        String s = properties.getProperty(WATCH_KEY_COUNT, null);
        if (s != null) {
            try {
                int count = Integer.parseInt(s);
                for (int i = 0; i < count; ++i) {
                    this.loadWatch(properties, i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadWatch(PropertyAccess properties, int number) {
        String prefix = WATCH_KEY_PREFIX + number + WATCH_KEY_DOT;
        String scope = properties.getProperty(prefix + WATCH_KEY_SCOPE, GlobalWatchScope);
        String exp = properties.getProperty(prefix + WATCH_KEY_EXPRESSION, null);
        if (exp != null && exp.length() > 0) {
            List<EvaluatorItem> list = this.allWatches.get(scope);
            if (list == null) {
                list = new ArrayList<EvaluatorItem>();
                this.allWatches.put(scope, list);
            }
            EvaluatorItem ei = new EvaluatorItem(exp);
            String name = properties.getProperty(prefix + WATCH_KEY_NAME, null);
            if (name != null) {
                String s = properties.getProperty(prefix + WATCH_KEY_SHOWPINNEDDISCARDED, null);
                boolean showPinnedDiscarded = Boolean.valueOf(s);
                ei.setOptions(name, showPinnedDiscarded, null);
            }
            list.add(ei);
        }
    }

    void saveWatches(PropertyAccess properties) {
        int previousCount = 0;
        String s = properties.getProperty(WATCH_KEY_COUNT, null);
        if (s != null) {
            try {
                previousCount = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int count = 0;
        for (String scope : this.allWatches.keySet()) {
            List<EvaluatorItem> list = this.allWatches.get(scope);
            for (EvaluatorItem ei : list) {
                String expression = ei.getExpression();
                if (expression == null) continue;
                this.saveWatch(properties, count, scope, ei);
                ++count;
            }
        }
        for (int i = count; i < previousCount; ++i) {
            this.removeSavedWatch(properties, i);
        }
        properties.setProperty(WATCH_KEY_COUNT, Integer.toString(count));
    }

    private void saveWatch(PropertyAccess properties, int number, String scope, EvaluatorItem ei) {
        String prefix = WATCH_KEY_PREFIX + number + WATCH_KEY_DOT;
        properties.setProperty(prefix + WATCH_KEY_SCOPE, scope);
        properties.setProperty(prefix + WATCH_KEY_EXPRESSION, ei.getExpression());
        String name = ei.getName();
        if (name != null) {
            properties.setProperty(prefix + WATCH_KEY_NAME, name);
            if (ei.isShowPinnedDiscarded()) {
                properties.setProperty(prefix + WATCH_KEY_SHOWPINNEDDISCARDED, Boolean.toString(true));
            } else {
                properties.setProperty(prefix + WATCH_KEY_SHOWPINNEDDISCARDED, null);
            }
        } else {
            properties.setProperty(prefix + WATCH_KEY_SHOWPINNEDDISCARDED, null);
        }
    }

    private void removeSavedWatch(PropertyAccess properties, int number) {
        String prefix = WATCH_KEY_PREFIX + number + WATCH_KEY_DOT;
        properties.setProperty(prefix + WATCH_KEY_SCOPE, null);
        properties.setProperty(prefix + WATCH_KEY_EXPRESSION, null);
        properties.setProperty(prefix + WATCH_KEY_NAME, null);
        properties.setProperty(prefix + WATCH_KEY_SHOWPINNEDDISCARDED, null);
    }

    @Override
    protected void addDataItems() {
        EvaluatorItem[] watches = this.getWatchesForProcess(this.getDebuggingProcess());
        if (watches != null) {
            List<DataItem> root = this.getRoot();
            int length = watches.length;
            for (int i = 0; i < length; ++i) {
                this.addDataItem(root, watches[i], false, false);
            }
        }
        if (this.vm != null) {
            this.updateInstanceCounts(this.vm);
        }
        this.model.updateChangeTracking();
    }

    private WatchPanel getWatchPanel() {
        return (WatchPanel)this.getDataPanel();
    }

    boolean addWatchDialog(String expression) {
        if (expression == null) {
            expression = "";
        }
        JDebugger.getInstance().addWatch(expression);
        if (expression.length() > 0) {
            this.getWatchPanel().enableHistoryButton();
        }
        return true;
    }

    EvaluatorItem addWatch(Object expression) {
        List<EvaluatorItem> watches = this.getWatchesForProject(this.getDebuggingProcess());
        if (watches != null) {
            EvaluatorItem ei = null;
            if (expression instanceof EvaluatorItem) {
                ei = (EvaluatorItem)expression;
            } else if (expression instanceof String) {
                ei = new EvaluatorItem((String)expression);
            }
            if (ei != null) {
                String expressionString = ei.getExpression();
                for (EvaluatorItem i : watches) {
                    if (i == null || i.getExpression() == null || !i.getExpression().equals(expressionString)) continue;
                    this.getWatchPanel().selectTopDataItem(expressionString);
                    return null;
                }
                watches.add(ei);
                this.addDataItem(null, ei, false, false);
                if (ei.getExpression() != null && ei.getExpression().length() == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JTable table = WatchController.this.getDataPanel().getDataTable().getTable();
                            table.editCellAt(table.getRowCount() - 1, 0);
                        }
                    });
                } else {
                    this.getWatchPanel().enableHistoryButton();
                }
                return ei;
            }
        }
        return null;
    }

    boolean removeWatch(EvaluatorItem ei) {
        List<EvaluatorItem> watchesForProject = this.getWatchesForProject(this.getDebuggingProcess());
        if (watchesForProject.remove(ei)) {
            if (ei.isPinned(this.getDebuggingProcess())) {
                ei.unpin(this.getDebuggingProcess());
            }
            List<DataItem> root = this.getRoot();
            int size = root.size();
            for (int i = 0; i < size; ++i) {
                DataItem o = root.get(i);
                if (o instanceof EvaluatorDataItem) {
                    if (((EvaluatorDataItem)o).ei != ei) continue;
                    this.getWatchPanel().removeTopDataItem(i);
                    if (i < --size) {
                        this.getWatchPanel().selectTopDataItem(i);
                        break;
                    }
                    if (0 > --i || i >= size) break;
                    this.getWatchPanel().selectTopDataItem(i);
                    break;
                }
                if (!(o instanceof DataItem)) continue;
                DataItem item = o;
                if (item.expressionPart == null || !item.expressionPart.equals(ei.getExpression())) continue;
                this.getWatchPanel().removeTopDataItem(i);
                if (i < --size) {
                    this.getWatchPanel().selectTopDataItem(i);
                    break;
                }
                if (0 > --i || i >= size) break;
                this.getWatchPanel().selectTopDataItem(i);
                break;
            }
            this.everythingChanged();
            return true;
        }
        return false;
    }

    boolean delete(Context context) {
        this.update(actionRemoveWatch, context);
        if (actionRemoveWatch.isEnabled()) {
            this.handleEvent(actionRemoveWatch, context);
            return true;
        }
        return false;
    }

    @Override
    void processFinished(DebuggingProcess debuggingProcess) {
        List<EvaluatorItem> watches = this.getWatchesForProject(debuggingProcess);
        if (watches != null) {
            int size = watches.size();
            for (int i = size - 1; i >= 0; --i) {
                EvaluatorItem ei = watches.get(i);
                if (ei.isPinned(debuggingProcess)) {
                    ei.unpin(debuggingProcess);
                }
                if (ei.getTemporary() != debuggingProcess) continue;
                watches.remove(i);
            }
        }
        super.processFinished(debuggingProcess);
    }

    static {
        ADD_NEW_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchAddNewWatch");
        REMOVE_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchRemoveWatch");
        PIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchPin");
        UNPIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchUnpin");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGotoField");
        REMOVE_ALL_WATCHES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchRemoveAllWatches");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchSettings");
        actionRemoveWatch = IdeAction.findOrCreate((int)REMOVE_WATCH_CMD_ID, null, (String)DbgArb.getString(546), null, (Integer)DbgArb.getInteger(547), (Icon)OracleIcons.getIcon((String)"delete.png"), null, (boolean)false);
        actionRemoveWatch.setEnabled(false);
        actionPin = IdeAction.findOrCreate((int)PIN_CMD_ID, null, (String)DbgArb.getString(587), null, (Integer)DbgArb.getInteger(588), null, null, (boolean)false);
        actionPin.setEnabled(false);
        actionUnpin = IdeAction.findOrCreate((int)UNPIN_CMD_ID, null, (String)DbgArb.getString(589), null, (Integer)DbgArb.getInteger(590), null, null, (boolean)false);
        actionUnpin.setEnabled(false);
        actionViewWhole = IdeAction.findOrCreate((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(269), null, (Integer)DbgArb.getInteger(270), null, null, (boolean)false);
        actionViewWhole.setEnabled(false);
        actionViewAnnotations = IdeAction.findOrCreate((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(263), null, (Integer)DbgArb.getInteger(266), null, null, (boolean)false);
        actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(263));
        actionViewAnnotations.setEnabled(false);
        actionViewAnnotationsForClass = IdeAction.findOrCreate((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(267), null, (Integer)DbgArb.getInteger(268), null, null, (boolean)false);
        actionViewAnnotationsForClass.setEnabled(false);
        actionAdjustRange = IdeAction.findOrCreate((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(271), null, (Integer)DbgArb.getInteger(272), null, null, (boolean)false);
        actionAdjustRange.setEnabled(false);
        actionToggleValue = IdeAction.findOrCreate((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(273), null, (Integer)DbgArb.getInteger(274), null, null, (boolean)false);
        actionToggleValue.setEnabled(false);
        actionModifyValue = IdeAction.findOrCreate((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(275), null, (Integer)DbgArb.getInteger(276), null, null, (boolean)false);
        actionModifyValue.setEnabled(false);
        actionWatch = IdeAction.findOrCreate((int)WATCH_CMD_ID, null, (String)DbgArb.getString(279), null, (Integer)DbgArb.getInteger(280), (Icon)OracleIcons.getIcon((String)"watch.png"), null, (boolean)false);
        actionWatch.setEnabled(false);
        actionInspect = IdeAction.findOrCreate((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(281), null, (Integer)DbgArb.getInteger(282), (Icon)OracleIcons.getIcon((String)"properties.png"), null, (boolean)false);
        actionInspect.setEnabled(false);
        actionWatchClassLoader = IdeAction.findOrCreate((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(295), null, (Integer)DbgArb.getInteger(296), null, null, (boolean)false);
        actionWatchClassLoader.setEnabled(false);
        actionInspectClassLoader = IdeAction.findOrCreate((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(297), null, (Integer)DbgArb.getInteger(298), null, null, (boolean)false);
        actionInspectClassLoader.setEnabled(false);
        actionGoto = IdeAction.findOrCreate((int)GOTO_CMD_ID, null, (String)DbgArb.getString(283), null, (Integer)DbgArb.getInteger(285), null, null, (boolean)false);
        actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(283));
        actionGoto.setEnabled(false);
        actionGotoDeclared = IdeAction.findOrCreate((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(286), null, (Integer)DbgArb.getInteger(288), null, null, (boolean)false);
        actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(286));
        actionGotoDeclared.setEnabled(false);
        actionGotoField = IdeAction.findOrCreate((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(289), null, (Integer)DbgArb.getInteger(291), null, null, (boolean)false);
        actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(289));
        actionGotoField.setEnabled(false);
        actionAddNewWatch = IdeAction.findOrCreate((int)ADD_NEW_WATCH_CMD_ID, null, (String)DbgArb.getString(548), null, (Integer)DbgArb.getInteger(549), (Icon)OracleIcons.getIcon((String)"add.png"), null, (boolean)false);
        actionAddNewWatch.setEnabled(false);
        actionRemoveAllWatches = IdeAction.findOrCreate((int)REMOVE_ALL_WATCHES_CMD_ID, null, (String)DbgArb.getString(550), null, (Integer)DbgArb.getInteger(551), null, null, (boolean)false);
        actionRemoveAllWatches.setEnabled(false);
        actionUseFilters = IdeAction.findOrCreate((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(299), null, (Integer)DbgArb.getInteger(300), null, null, (boolean)false);
        actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
        actionUseFilters.setEnabled(false);
        actionObjectPreferences = IdeAction.findOrCreate((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(301, ""), null, (Integer)DbgArb.getInteger(302), (Icon)OracleIcons.getIcon((String)"debugger/objectdisplaypreferences.png"), null, (boolean)false);
        actionObjectPreferences.setEnabled(false);
        actionSettings = IdeAction.findOrCreate((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), (Icon)OracleIcons.getIcon((String)"settings.png"), null, (boolean)false);
        actionSettings.setEnabled(false);
        actionCollapseAll = IdeAction.findOrCreate((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(94), null, (Integer)RunMgrArb.getInteger(95), null, null, (boolean)false);
        actionCollapseAll.setEnabled(false);
        actionSave = IdeAction.findOrCreate((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), (Icon)OracleIcons.getIcon((String)"export.png"), null, (boolean)false);
        actionSave.setEnabled(false);
    }
}

