/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public final class SmartWindowSettingsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private DataPanelSettingsPanel dataPanel = new DataPanelSettingsPanel("Debugger.SmartWindow");
    private JCheckBox sortExpressionsCheckBox = new JCheckBox();
    private Map<String, Boolean> sortExpressionsMap = new HashMap<String, Boolean>();
    private JLabel locationsLabel = new JLabel();
    private NumericSpinBox locationsBox = new NumericSpinBox(1, 10);
    private JLabel linesLabel = new JLabel();
    private NumericSpinBox linesBox = new NumericSpinBox(1, 10);
    private JLabel spacerLabel = new JLabel();
    private JComboBox vmChooser;
    private JLabel vmChooserLabel;
    private String currentVM;
    private MultiLineLabel disclaimerLabel;
    private transient SmartWindowSettings settings;
    private JPanel spacer;
    private JPanel optionPanel;

    public SmartWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_smartdatawinsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.sortExpressionsCheckBox, (String)DbgArb.getString(694));
        ResourceUtils.resLabel((JLabel)this.locationsLabel, (Component)this.locationsBox, (String)DbgArb.getString(695));
        ResourceUtils.resLabel((JLabel)this.linesLabel, (Component)this.linesBox, (String)DbgArb.getString(696));
        this.sortExpressionsCheckBox.addActionListener(this);
        SpinBuddy buddy = this.locationsBox.getSpinBuddy();
        if (buddy instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        if ((buddy = this.linesBox.getSpinBuddy()) instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        this.spacerLabel.setEnabled(false);
        this.spacer = new JPanel();
        this.optionPanel = new JPanel(new GridBagLayout());
        this.disclaimerLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DbgArb.format(862, DbgArb.getString(556)));
        this.vmChooser = new JComboBox();
        this.vmChooserLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.vmChooserLabel, (Component)this.vmChooser, (String)DbgArb.getString(861));
    }

    private JPanel makeSmartPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        int y = 0;
        panel.add((Component)this.locationsLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        panel.add((Component)this.locationsBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.linesLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
        panel.add((Component)this.linesBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(2, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private SmartWindowSettings getData(TraversableContext tc) {
        return SmartWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.settings = this.getData(tc);
        DataPanelSettings dpSettings = this.settings.getDataPanelSettings();
        HashStructure hash = dpSettings.getHash();
        this.removeAll();
        this.add((Component)this.disclaimerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 16, 0), 0, 0));
        this.dataPanel.onEntry(this.settings.getDataPanelSettings());
        this.vmChooser.removeAllItems();
        int y = 1;
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() > 0) {
            for (String vmName : vmNames) {
                this.vmChooser.addItem(vmName);
                boolean[] visibilities = new boolean[8];
                for (int j = 0; j < 8; ++j) {
                    visibilities[j] = WindowSettingsColumnManager.getColumnVisible(hash, vmName, j);
                }
                this.sortExpressionsMap.put(vmName, this.settings.isSortExpressions(vmName));
            }
            this.vmChooser.setEditable(false);
            if (vmNames.size() > 1) {
                this.add(this.vmChooserLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 8, 8), 0, 0));
                this.add(this.vmChooser, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
            }
            this.add(this.optionPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            Insets borderInsets = new Insets(0, 0, 0, 0);
            constraints.gridy = y;
            constraints.insets.top = 8;
            this.add(this.dataPanel.makeShowPanel(null), constraints);
            ++constraints.gridy;
            this.add(this.makeSmartPanel(borderInsets), constraints);
            ++constraints.gridy;
            this.add(this.dataPanel.makeViewSelectPanel(), constraints);
            ++constraints.gridy;
            constraints.weighty = 1.0;
            this.add(this.spacerLabel, constraints);
            this.vmChooser.addActionListener(this);
            this.vmChooser.setSelectedIndex(0);
        } else {
            this.add(this.spacer, new GridBagConstraints(0, y, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.locationsBox.setIntValue(this.settings.getNumberOfLocations());
        this.linesBox.setIntValue(this.settings.getNumberOfLines());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        SmartWindowSettings settings = this.getData(tc);
        this.dataPanel.onExit(settings.getDataPanelSettings());
        for (String vmName : this.sortExpressionsMap.keySet()) {
            settings.setSortExpressions(vmName, this.sortExpressionsMap.get(vmName));
        }
        try {
            int numberOfLocations = this.locationsBox.getIntValue();
            settings.setNumberOfLocations(numberOfLocations);
        }
        catch (Exception numberOfLocations) {
            // empty catch block
        }
        try {
            int numberOfLines = this.linesBox.getIntValue();
            settings.setNumberOfLines(numberOfLines);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.vmChooser && this.vmChooser.getSelectedIndex() != -1) {
            this.currentVM = this.vmChooser.getSelectedItem().toString();
            String window = DbgArb.getString(556);
            String title = DbgArb.format(863, window, this.currentVM);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            this.optionPanel.setBorder(border);
            this.optionPanel.removeAll();
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            Insets borderInsets = new Insets(0, 0, 0, 0);
            this.optionPanel.add((Component)this.dataPanel.makeChooseColumnsPanel(this.settings.getDataPanelSettings(), this.currentVM, borderInsets), constraints);
            this.optionPanel.add((Component)this.dataPanel.makeSortPanel(this.currentVM, this.sortExpressionsCheckBox), new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.optionPanel.revalidate();
            this.sortExpressionsCheckBox.setSelected(this.settings.isSortExpressions(this.currentVM));
        }
        if (e.getSource() == this.sortExpressionsCheckBox) {
            this.sortExpressionsMap.put(this.currentVM, this.sortExpressionsCheckBox.isSelected());
        }
    }
}

