/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ideimpl.debugger.evaluator.ConditionEvaluationResult;
import oracle.ideimpl.debugger.evaluator.ConditionEvaluationResultType;
import oracle.jdevimpl.debugger.DebugObjectFactory;
import oracle.jdevimpl.debugger.breakpoint.ConditionEvaluationResultsByThread;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BreakpointRuntimeSupport;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

class DebugBreakpointConditionImpl
implements DebugBreakpointCondition {
    private CoreBreakpoint breakpoint;

    DebugBreakpointConditionImpl(CoreBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
    }

    @Override
    public boolean checkBreakpointCondition(DebugBreakpoint bp, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        block11: {
            ConditionEvaluationResultsByThread resultReporter = null;
            if (bp instanceof ConditionEvaluationResultsByThread) {
                resultReporter = (ConditionEvaluationResultsByThread)bp;
            }
            try {
                if (stack.length > 0) {
                    ConditionEvaluationResultType rt;
                    String condition = this.getConditionText();
                    EvaluatorProxy evaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                    evaluator.setAllowMethodInvocation(true);
                    evaluator.setDebugContext(vm, thread, stack[0]);
                    ConditionEvaluationResult result = evaluator.evaluateCondition(condition);
                    if (resultReporter != null) {
                        resultReporter.addResult(thread.getThreadId(), result);
                    }
                    if ((rt = result.getResultType()) == ConditionEvaluationResultType.RETRIABLE_EXCEPTION) {
                        return true;
                    }
                    if (rt == ConditionEvaluationResultType.COULD_NOT_EVALUATE || rt == ConditionEvaluationResultType.NOT_BOOLEAN) {
                        String msg = result.getMessage();
                        DebuggingProcess debuggingProcess = BreakpointRuntimeSupport.getDebuggingProcess(this.breakpoint, bp);
                        debuggingProcess.addMessage(msg);
                        return true;
                    }
                    if (rt == ConditionEvaluationResultType.NOT_BOOLEAN) {
                        String msg = result.getMessage();
                        DebuggingProcess debuggingProcess = BreakpointRuntimeSupport.getDebuggingProcess(this.breakpoint, bp);
                        debuggingProcess.addMessage(msg);
                    } else {
                        if (rt == ConditionEvaluationResultType.FALSE) {
                            return false;
                        }
                        if (rt == ConditionEvaluationResultType.TRUE) {
                            return true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block11;
                throw (ThreadDeath)e;
            }
        }
        return false;
    }

    @Override
    public String getConditionText() {
        String condition = this.breakpoint.getCondition();
        String hiddenCondition = this.breakpoint.getHiddenCondition();
        if (hiddenCondition.length() == 0) {
            return condition;
        }
        if (condition.length() == 0) {
            return hiddenCondition;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("((");
        buf.append(hiddenCondition);
        buf.append(") && (");
        buf.append(condition);
        buf.append("))");
        return buf.toString();
    }
}

