/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DataPanelSaveHelper {
    private DataPanelSaveHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveToFile(DataTable dataTable, DataTreeTableModel model, String title, Context context) {
        URL url;
        String dlgTitle = RunMgrArb.format(100, title);
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        chooser.setHelpID("f1_deb_exportdialog_html");
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            Exception exceptionOccurred = null;
            try {
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter out = html ? JDebugger.printHtmlHeader(url, title) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                DataPanelSaveHelper.save(dataTable, model, out, html);
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            finally {
                wc.hide();
            }
            if (exceptionOccurred != null) {
                String message = DbgArb.format(771, title, URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    static void save(DataTable dataTable, DataTreeTableModel model, PrintWriter out, boolean html) {
        if (html) {
            out.println("<table border=\"1\">");
        }
        DataPanelSaveHelper.saveHeader(dataTable, model, out, html);
        DataPanelSaveHelper.save(dataTable, model, new TreePath(model.getRoot()), out, html, "");
        if (html) {
            out.println("</table>");
        }
    }

    private static void saveHeader(DataTable dataTable, DataTreeTableModel model, PrintWriter out, boolean html) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        if (html) {
            sb.append("<tr>");
        }
        TableColumnModel tableColumnModel = dataTable.getTable().getColumnModel();
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            int i = column.getModelIndex();
            String columnName = model.getColumnName(i);
            if (html) {
                sb.append("<th>");
                columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                sb.append(columnName);
                sb.append("</th>");
                continue;
            }
            sb.append(columnName);
            for (int ii = columnName.length(); ii >= 0; --ii) {
                sb2.append('-');
            }
            if (!e.hasMoreElements()) continue;
            sb.append('\t');
            sb2.append('\t');
        }
        if (html) {
            sb.append("</tr>");
        }
        out.println(sb.toString());
        if (!html) {
            out.println(sb2.toString());
        }
    }

    private static void save(DataTable dataTable, DataTreeTableModel model, TreePath treePath, PrintWriter out, boolean html, String indent) {
        block23: {
            DataItem item;
            block22: {
                if (!dataTable.isVisible(treePath)) break block22;
                Object node = treePath.getLastPathComponent();
                if (node instanceof DataItem) {
                    DataItem dataItem = (DataItem)node;
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = dataTable.getTable().getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        Object columnValue = model.getValueAt(node, i);
                        if (html) {
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (dataTable.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (dataItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (dataTable.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (dataItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != model.getRoot()) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                Iterator<DataItem> children = model.getLazyChildren(node);
                while (children.hasNext()) {
                    DataItem child = children.next();
                    DataPanelSaveHelper.save(dataTable, model, treePath.pathByAddingChild(child), out, html, indent);
                }
                break block23;
            }
            Object node = treePath.getLastPathComponent();
            if (!(node instanceof DataItem) || !(item = (DataItem)node).mayHaveChildren()) break block23;
            Iterator<DataItem> children = model.getLazyChildren(node);
            while (children.hasNext()) {
                DataItem child = children.next();
                DataPanelSaveHelper.save(dataTable, model, treePath.pathByAddingChild(child), out, html, indent);
            }
        }
    }
}

