/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger;

import java.util.HashMap;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.FactoryData;

public class DebugObjectFactory {
    private static Log logger = new Log("JDebugger");
    private static String mapLocation = "oracle.jdevimpl.internal.debugger.FactoryDataImpl";
    private static Map<Class, Class> implementations = new HashMap<Class, Class>();

    public static <T> T create(Class<T> base) {
        Class implementation = implementations.get(base);
        if (implementation == null) {
            logger.trace("DebugObjectFactory: No implementing class registered for requested base " + base);
            return null;
        }
        MetaClass metaClass = MetaClass.newMetaClass((Class)implementation);
        try {
            Object instance = metaClass.newInstance();
            logger.trace("DebugObjectFactory successfully created " + implementation.getName());
            return (T)instance;
        }
        catch (Exception ex) {
            logger.trace("Failed to create instance of class " + implementation.getName() + " for requested base " + base.getName());
            return null;
        }
    }

    static {
        MetaClass factoryMeta = new MetaClass(DebugObjectFactory.class.getClassLoader(), mapLocation);
        try {
            FactoryData factory = (FactoryData)factoryMeta.newInstance();
            implementations = factory.getData();
            logger.trace("DebugObjectFactory.<clinit> loaded " + implementations.size() + " mappings");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }
}

