/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.Writer;
import oracle.dbtools.common.xml.Resetable;

class TextWriter
extends Writer
implements Resetable {
    private final StringBuilder buf = new StringBuilder();

    TextWriter() {
        this.lock = this.buf;
    }

    @Override
    public TextWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public TextWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public TextWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void reset() {
        this.buf.delete(0, this.buf.length());
    }

    public String toString() {
        return this.buf.toString();
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
    }

    @Override
    public void write(int c) {
        this.buf.append((char)c);
    }

    @Override
    public void write(String str) {
        this.buf.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buf.append(str.substring(off, off + len));
    }
}

