/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.timing;

import java.util.logging.Level;

public class TimingPoint {
    public static final Level TIMING = Level.FINE;
    public static final Level FINE_TIMING = Level.FINER;
    private final Level level;
    private final String name;

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimingPoint)) {
            return false;
        }
        TimingPoint other = (TimingPoint)obj;
        if (this.level == null ? other.level != null : !this.level.equals(other.level)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public TimingPoint(Level level, String name) {
        this.level = level;
        this.name = name;
    }

    public Level level() {
        return this.level;
    }

    public Builder modify() {
        return new Builder().level(this.level).name(this.name);
    }

    public String name() {
        return this.name;
    }

    public static class Builder {
        private Level level;
        private String name;

        public TimingPoint build() {
            return new TimingPoint(this.level, this.name);
        }

        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }
}

