/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.headers;

import oracle.dbtools.common.util.Transform;

public final class QualityValue<T>
implements Comparable<QualityValue<T>> {
    final T value;
    final int position;
    final Double quality;

    QualityValue(T value, Double quality, int position) {
        this.value = value;
        this.quality = quality;
        this.position = position;
    }

    @Override
    public int compareTo(QualityValue<T> o) {
        if (this.quality < o.quality) {
            return 1;
        }
        if (this.quality > o.quality) {
            return -1;
        }
        return this.position - o.position;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Weighting [value=");
        builder.append(this.value);
        builder.append(", position=");
        builder.append(this.position);
        builder.append(", quality=");
        builder.append(this.quality);
        builder.append("]");
        return builder.toString();
    }

    public static interface Factory<T>
    extends Transform<String, T> {
        @Override
        public T apply(String var1);
    }
}

