/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.headers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.CharacterClass;
import oracle.dbtools.common.util.Log;

class PercentEncoding {
    private final Charset charset;
    private final CharacterClass legalChars;
    private static final int ENCODED_OCTET_LENGTH = "%AB".length();
    private static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Log LOG = Log.get(PercentEncoding.class);

    PercentEncoding(Charset charset, CharacterClass legalChars) {
        this.charset = charset;
        this.legalChars = legalChars;
    }

    Charset charset() {
        return this.charset;
    }

    CharSequence decode(CharSequence encodedText) {
        char[] chars = encodedText.toString().toCharArray();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (this.isPercentEncodedToken(chars, i)) {
                byte octet = PercentEncoding.decodeOctet(chars, i);
                bytes.write(octet);
                i += ENCODED_OCTET_LENGTH - 1;
                continue;
            }
            if (!this.legalChars.matches(c)) {
                this.rawBytes(chars, i, bytes);
                continue;
            }
            bytes.write((byte)c);
        }
        return new String(bytes.toByteArray(), this.charset);
    }

    void encode(Appendable encoded, CharSequence text) throws IOException {
        for (byte ch : text.toString().getBytes(this.charset)) {
            this.encode(encoded, ch);
        }
    }

    CharSequence encode(CharSequence text) {
        StringBuilder b = new StringBuilder();
        try {
            this.encode((Appendable)b, text);
        }
        catch (IOException e) {
            LOG.finest(e);
        }
        return b.toString();
    }

    protected void encode(Appendable encoded, byte ch) throws IOException {
        if (this.legalChars.matches(ch)) {
            encoded.append((char)ch);
        } else {
            char[] percentEncoded = new char[]{'%', '\u0000', '\u0000'};
            percentEncoded[1] = HEX_DIGITS[0xF & ch >>> 4];
            percentEncoded[2] = HEX_DIGITS[ch & 0xF];
            encoded.append(percentEncoded[0]);
            encoded.append(percentEncoded[1]);
            encoded.append(percentEncoded[2]);
        }
    }

    private boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private boolean isPercentEncodedToken(char[] text, int offset) {
        char first = text[offset];
        if ('%' == first && offset < text.length - 2) {
            char second = text[offset + 1];
            char third = text[offset + 2];
            return this.isHexDigit(second) && this.isHexDigit(third);
        }
        return false;
    }

    private void rawBytes(char[] chars, int index, OutputStream bytes) {
        CharBuffer buf = CharBuffer.wrap(chars, index, 1);
        try {
            ByteBuffer byteBuffer = this.charset.encode(buf);
            byte[] byteEncoded = byteBuffer.array();
            bytes.write(byteEncoded, 0, byteBuffer.limit());
        }
        catch (IOException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    private static byte decodeOctet(char[] encodedText, int i) {
        String hexDigits = new String(encodedText, i + 1, 2);
        return DatatypeConverter.parseHexBinary((String)hexDigits)[0];
    }
}

