/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console;

import java.awt.event.ActionListener;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import jline.console.UserInterruptException;
import oracle.dbtools.raptor.console.ConsoleListener;
import oracle.dbtools.raptor.console.clone.DbtoolsConsoleReader;
import oracle.dbtools.raptor.console.clone.DbtoolsNonBlockingInputStream;
import oracle.dbtools.raptor.newscriptrunner.console.IConsoleClearScreen;

public class SQLPlusConsoleReader
extends DbtoolsConsoleReader
implements IConsoleClearScreen {
    public static final String CTRLC = "ctrlc";
    private ArrayList<ConsoleListener> m_listeners;

    public SQLPlusConsoleReader() throws IOException {
        super("SQLPlus", new FileInputStream(FileDescriptor.in), System.out, null);
        this.setHandleUserInterrupt(true);
    }

    @Override
    public void doClearScreen(String position) throws IOException {
        super.clearScreen(position);
    }

    @Override
    public String readLine() throws IOException {
        try {
            return super.readLine();
        }
        catch (UserInterruptException e) {
            this.fireListeners(CTRLC);
            return null;
        }
    }

    public void fireListeners(String event) {
        for (ConsoleListener listener : this.getListeners()) {
            listener.raiseEvent(event);
        }
    }

    protected ArrayList<ConsoleListener> getListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        return this.m_listeners;
    }

    public void addListener(ConsoleListener listener) {
        this.getListeners().add(listener);
    }

    @Override
    public void addTriggeredAction(char c, ActionListener al) {
        super.addTriggeredAction(c, al);
    }

    public void removeListener(ConsoleListener task) {
        this.getListeners().remove(task);
    }

    @Override
    public void setRedit(boolean on) {
        this.editNow = on;
        this.fullRedraw = true;
        this.historyReturned = false;
    }

    @Override
    public void pauseReader(boolean pause) {
        ((DbtoolsNonBlockingInputStream)this.getInput()).pause(pause);
    }

    public void resetRedraw(String line) {
        this.fullRedraw = line != null && (line.toLowerCase().startsWith("edit") || this.partofinsert(line));
    }

    private boolean partofinsert(String line) {
        switch (line.toLowerCase().trim()) {
            case "i": 
            case "in": 
            case "inp": 
            case "inpu": 
            case "input": {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getWidth() {
        return this.getTerminal().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getTerminal().getHeight();
    }

    @Override
    public void forceRedraw(boolean draw) {
        int cursorPos = this.getMultilineBuffer().getLine(this.getMultilineBuffer().getCurrentLine()).length();
        this.setRedraw(this.getMultilineBuffer().getCurrentLine(), DbtoolsConsoleReader.MoveState.UP, cursorPos, 0, DbtoolsConsoleReader.CursorState.NORMAL, true);
        this.redrawDetails.setDontReDraw(false);
        this.fullRedraw = true;
    }
}

