/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Properties;
import oracle.dbtools.plusplus.ssh.SQLUserInfo;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class SSHConnection {
    ConnType m_type;
    String m_host;
    String m_user;
    String m_identityFile;
    String m_basePort;
    String m_portForward;
    String m_password;
    Properties m_config;
    Session session;
    ScriptRunnerContext m_ctx;

    public SSHConnection(ScriptRunnerContext ctx, ConnType type, String host, String user, String identity, String basePort, String portf, String pass) {
        this.m_ctx = ctx;
        this.m_type = type;
        this.m_host = host;
        this.m_user = user;
        this.m_identityFile = identity;
        this.m_basePort = basePort;
        this.m_portForward = portf;
        this.m_password = pass;
        this.m_config = new Properties();
        this.m_config.put("StrictHostKeyChecking", "no");
    }

    public boolean connect() {
        JSch jsch = new JSch();
        try {
            if (this.m_identityFile != null && !this.m_identityFile.equals("")) {
                jsch.addIdentity(this.m_identityFile);
            }
            int port = 22;
            try {
                port = Integer.parseInt(this.m_basePort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            System.out.println("Using port:" + port);
            this.session = jsch.getSession(this.m_user, this.m_host, port);
            this.session.setUserInfo(new SQLUserInfo(this.m_ctx));
            if (this.m_password != null && this.m_password.length() > 0) {
                this.session.setPassword(this.m_password);
            }
            this.session.setConfig(this.m_config);
            if (this.m_portForward != null && this.m_portForward.split(":").length == 3) {
                String[] parts = this.m_portForward.split(":");
                int lport = Integer.parseInt(parts[0]);
                String rhost = parts[1];
                int rport = Integer.parseInt(parts[2]);
                int n = this.session.setPortForwardingL(lport, rhost, rport);
            }
            this.session.connect();
            return this.session.isConnected();
        }
        catch (JSchException e) {
            this.m_ctx.write(e.getLocalizedMessage() + "\n");
            return false;
        }
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public Session getSession() {
        return this.session;
    }

    public void disconnect() {
        if (this.getSession() != null && this.isConnected()) {
            this.session.disconnect();
        }
    }

    public static enum ConnType {
        NONE,
        PASSWORD,
        KEYFILE;

    }

    public static enum Result {
        CONNECTED,
        NOTCONNECTED,
        ERROR;

    }
}

