/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.navigator;

import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.xml.navigator.Descriptor;
import oracle.dbtools.xml.navigator.IconElement;
import oracle.dbtools.xml.navigator.LabelElement;
import oracle.xml.parser.v2.XMLNode;

public class FolderElement
extends Descriptor {
    private static final String SCHEMA_OVERRIDE = "schemaOverride";
    private static final String RELATIVE_WEIGHT = "relativeWeight";
    private static final String SINGLE_CLICK_OPEN = "singleClickOpen";
    private static final String CURRENT_SCHEMA_ONLY = "currentSchemaOnly";
    private static final String IGNORE_COMPARATOR = "ignoreComparator";
    private LabelElement label;
    private IconElement icon;
    private ObjectQueries queries;
    private boolean currentSchemaOnly;
    private boolean singleClickOpen;
    private String schemaOverride;
    private double relativeWeight;
    private boolean ignoreComparator;

    static boolean parseIgnoreComparator(XMLNode node) {
        return Boolean.parseBoolean(FolderElement.getAttributeValue("", IGNORE_COMPARATOR, node));
    }

    FolderElement(XMLNode node) {
        super(node);
        this.label = new LabelElement(node);
        this.icon = new IconElement(node);
        this.queries = new ObjectQueries(FolderElement.getSingleElement("queries", node));
        this.currentSchemaOnly = FolderElement.getBooleanValue("", CURRENT_SCHEMA_ONLY, node);
        this.singleClickOpen = FolderElement.getBooleanValue("", SINGLE_CLICK_OPEN, node);
        String relWeight = FolderElement.getAttributeValue(null, RELATIVE_WEIGHT, node);
        if (relWeight != null) {
            try {
                this.relativeWeight = Double.parseDouble(relWeight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.schemaOverride = FolderElement.getAttributeValue(null, SCHEMA_OVERRIDE, node);
        this.ignoreComparator = FolderElement.parseIgnoreComparator(node);
    }

    public LabelElement getLabel() {
        return this.label;
    }

    public IconElement getIcon() {
        return this.icon;
    }

    public ObjectQueries getQueries() {
        return this.queries;
    }

    public boolean isCurrentSchemaOnly() {
        return this.currentSchemaOnly;
    }

    public boolean isSingleClickOpen() {
        return this.singleClickOpen;
    }

    public String getSchemaOverride() {
        return this.schemaOverride;
    }

    public double getRelativeWeight() {
        return this.relativeWeight;
    }

    public boolean isIgnoreComparator() {
        return this.ignoreComparator;
    }
}

