/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scripting;

import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.scripting.Script;

public class ScriptingUtils {
    private static Logger LOGGER = Logger.getLogger(ScriptingUtils.class.getName());

    public static Object runScript(Script script, Map<String, Object> map) throws ScriptException {
        return ScriptingUtils.runScript(null, script, map);
    }

    public static Object runScript(ScriptRunnerContext ctx, Script script, Map<String, Object> map) throws ScriptException {
        ScriptEngine engine;
        ScriptEngineManager mgr = new ScriptEngineManager();
        String language = script.getExtension() == null ? script.getLanguage() : script.getExtension();
        ScriptEngine scriptEngine = engine = script.getExtension() == null ? mgr.getEngineByExtension(script.getLanguage()) : mgr.getEngineByExtension(script.getExtension());
        if (ctx.getProperty("SCRIPT_ENGINE:" + language) != null) {
            LOGGER.info("\nReUsing  Engine: " + language + "\n");
            engine = (ScriptEngine)ctx.getProperty("SCRIPT_ENGINE:" + language);
        }
        for (String key : map.keySet()) {
            engine.put(key, map.get(key));
            Logger.getLogger(ScriptingUtils.class.getClass().getName()).finer("Adding:" + key);
        }
        Object ret = null;
        try {
            ret = engine.eval(script.getScript());
        }
        catch (Exception sqlex) {
            if (sqlex instanceof SQLException || sqlex.getCause() instanceof SQLException) {
                ExceptionHandler.handleException(sqlex);
            }
            throw sqlex;
        }
        if (ret != null) {
            Logger.getLogger(ScriptingUtils.class.getClass().getName()).finer("Returned:" + ret.toString());
        }
        if (ctx != null) {
            LOGGER.info("\nSaving  Engine: " + language + "\n");
            ctx.putProperty("SCRIPT_ENGINE:" + language, engine);
        }
        return ret;
    }
}

