/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.model;

import java.util.HashMap;
import java.util.List;
import oracle.dbtools.data.common.NullOrEmpty;
import oracle.dbtools.rest.RestMessages;
import oracle.dbtools.rest.model.RestResourceHandler;

public class RestTemplate {
    public static final String ENTITY_TAG_HASH = "HASH";
    public static final String ENTITY_TAG_SECURE_HASH = "SECURE_HASH";
    public static final String ENTITY_TAG_QUERY = "QUERY";
    public static final String ENTITY_TAG_NONE = "NONE";
    private String _uriPattern;
    private ENTITY_TAG_TYPE _entityTag;
    private String _entityTagQuery;
    private int _priority;
    private String _qualifiedConnName;
    private HashMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> _resourceHandlers = new HashMap();
    private String _comments;

    public String getURIPattern() {
        return this._uriPattern;
    }

    public void setURIPattern(String pattern) {
        this._uriPattern = pattern;
    }

    public ENTITY_TAG_TYPE getEntityTag() {
        return this._entityTag;
    }

    public void setEntityTag(ENTITY_TAG_TYPE entityTag) {
        this._entityTag = entityTag;
    }

    public void setEntityTag(String p_entityTag) {
        if (!NullOrEmpty.nullOrEmpty(p_entityTag)) {
            String entityTag;
            switch (entityTag = p_entityTag.trim().toUpperCase()) {
                case "HASH": 
                case "SECURE_HASH": {
                    this._entityTag = ENTITY_TAG_TYPE.SECURE_HASH;
                    break;
                }
                case "QUERY": {
                    this._entityTag = ENTITY_TAG_TYPE.QUERY;
                    break;
                }
                case "NONE": {
                    this._entityTag = ENTITY_TAG_TYPE.NONE;
                    break;
                }
                default: {
                    this._entityTag = ENTITY_TAG_TYPE.SECURE_HASH;
                }
            }
        }
    }

    public String getEntityTagQuery() {
        return this._entityTagQuery;
    }

    public void setEntityTagQuery(String query) {
        this._entityTagQuery = query;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public String getConnectionName() {
        return this._qualifiedConnName;
    }

    public void setConnectionName(String qualifiedConnName) {
        this._qualifiedConnName = qualifiedConnName;
    }

    public HashMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> getResourceHandlers() {
        return this._resourceHandlers;
    }

    public void setResourceHandlers(HashMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> resourceHandlers) {
        this._resourceHandlers = resourceHandlers;
    }

    public void setResourceHandlers(List<RestResourceHandler> handlers) {
        for (RestResourceHandler h : handlers) {
            this.addResourceHandler(h.getMethodType(), h);
        }
    }

    public void addResourceHandler(RestResourceHandler.HTTP_METHOD_TYPE handlerType, RestResourceHandler handler) {
        this._resourceHandlers.put(handlerType, handler);
    }

    public RestResourceHandler getResourceHandler(RestResourceHandler.HTTP_METHOD_TYPE handlerType) {
        return this._resourceHandlers.get((Object)handlerType);
    }

    public RestResourceHandler removeResourceHandler(RestResourceHandler.HTTP_METHOD_TYPE handlerType) {
        return this._resourceHandlers.remove((Object)handlerType);
    }

    public boolean handlerExists(RestResourceHandler.HTTP_METHOD_TYPE handlerType) {
        return this._resourceHandlers.containsKey((Object)handlerType);
    }

    public String getComments() {
        return this._comments;
    }

    public void setComments(String comments) {
        this._comments = comments;
    }

    public static enum ENTITY_TAG_TYPE {
        SECURE_HASH("SECURE_HASH", RestMessages.getString("ENTITY_TAG_HASH")),
        QUERY("QUERY", RestMessages.getString("ENTITY_TAG_QUERY")),
        NONE("NONE", RestMessages.getString("ENTITY_TAG_NONE"));

        private String type;
        private String nlsName;

        private ENTITY_TAG_TYPE(String type, String nlsName) {
            this.type = type;
            this.nlsName = nlsName;
        }

        public String getType() {
            return this.type;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }
}

