/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.model;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.data.common.NullOrEmpty;
import oracle.dbtools.rest.RestMessages;
import oracle.dbtools.rest.model.RestHandlerParameter;

public class RestResourceHandler {
    public static final int DEFAULT_ITEMS_PER_PAGE = 25;
    public static final String GENERATOR_COLLECTION_JSON = "json/collection";
    public static final String GENERATOR_COLLECTION_ITEM_JSON = "json/item";
    public static final String GENERATOR_QUERY_JSON = "json/query";
    public static final String GENERATOR_QUERY_CSV = "csv/query";
    public static final String GENERATOR_QUERY_ONE_ROW = "json/query;type=single";
    public static final String GENERATOR_FEED = "json/query;type=feed";
    public static final String GENERATOR_MEDIA = "resource/lob";
    public static final String GENERATOR_PLSQL = "plsql/block";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    public static final String METHOD_PUT = "put";
    public static final String METHOD_DELETE = "delete";
    public static final String FORMAT_JSON = "JSON";
    public static final String FORMAT_CSV = "CSV";
    private HTTP_METHOD_TYPE _httpMethodType;
    private String _sql;
    private SOURCE_TYPE _sourceType;
    private FORMAT_TYPE _formatType;
    private boolean _securedAccess;
    private long _paginationSize;
    private List<String> _mimeTypes;
    private String _qualifiedConnName;
    private List<RestHandlerParameter> _parameters;
    private String _comments;

    public RestResourceHandler() {
    }

    public RestResourceHandler(RestResourceHandler copyHandler) {
        if (copyHandler != null) {
            this.setConnectionName(copyHandler.getConnectionName());
            this.setFormatType(copyHandler.getFormatType());
            this.setMethodType(copyHandler.getMethodType());
            this.setPaginationSize(copyHandler.getPaginationSize());
            this.setSecuredAccess(copyHandler.isSecuredAccess());
            this.setSourceType(copyHandler.getSourceType());
            this.setSQL(copyHandler.getSQL());
            if (copyHandler.getMimeTypes() != null) {
                this.setMimeTypes(new ArrayList<String>(copyHandler.getMimeTypes()));
            }
            if (copyHandler.getParameters() != null) {
                this.setParameters(new ArrayList<RestHandlerParameter>(copyHandler.getParameters()));
            }
        }
    }

    public HTTP_METHOD_TYPE getMethodType() {
        return this._httpMethodType;
    }

    public void setMethodType(HTTP_METHOD_TYPE httpMethodType) {
        this._httpMethodType = httpMethodType;
    }

    public void setMethodType(String p_methodType) {
        if (!NullOrEmpty.nullOrEmpty(p_methodType)) {
            String methodType;
            switch (methodType = p_methodType.trim().toLowerCase()) {
                case "get": {
                    this._httpMethodType = HTTP_METHOD_TYPE.GET;
                    break;
                }
                case "post": {
                    this._httpMethodType = HTTP_METHOD_TYPE.POST;
                    break;
                }
                case "put": {
                    this._httpMethodType = HTTP_METHOD_TYPE.PUT;
                    break;
                }
                case "delete": {
                    this._httpMethodType = HTTP_METHOD_TYPE.DELETE;
                    break;
                }
                default: {
                    this._httpMethodType = HTTP_METHOD_TYPE.GET;
                }
            }
        }
    }

    public String getSQL() {
        return this._sql;
    }

    public void setSQL(String sql) {
        this._sql = sql;
    }

    public SOURCE_TYPE getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(SOURCE_TYPE sourceType) {
        this._sourceType = sourceType;
    }

    public void setSourceType(String sourceType) {
        if (NullOrEmpty.nullOrEmpty(sourceType)) {
            this._sourceType = SOURCE_TYPE.COLLECTION_QUERY;
        } else {
            switch (sourceType) {
                case "json/collection": {
                    this._sourceType = SOURCE_TYPE.COLLECTION_QUERY;
                    break;
                }
                case "json/item": {
                    this._sourceType = SOURCE_TYPE.COLLECTION_QUERY_ITEM;
                    break;
                }
                case "plsql/block": {
                    this._sourceType = SOURCE_TYPE.PLSQL;
                    break;
                }
                case "json/query;type=feed": {
                    this._sourceType = SOURCE_TYPE.FEED;
                    break;
                }
                case "resource/lob": {
                    this._sourceType = SOURCE_TYPE.MEDIA_RESOURCE;
                    break;
                }
                case "json/query": {
                    this._sourceType = SOURCE_TYPE.QUERY;
                    break;
                }
                case "csv/query": {
                    this._sourceType = SOURCE_TYPE.QUERY;
                    break;
                }
                case "json/query;type=single": {
                    this._sourceType = SOURCE_TYPE.QUERY_ONE_ROW;
                    break;
                }
                default: {
                    this._sourceType = SOURCE_TYPE.COLLECTION_QUERY;
                }
            }
        }
        if (sourceType != null && sourceType.equals(GENERATOR_QUERY_CSV)) {
            this.setFormatType(FORMAT_TYPE.CSV);
        } else {
            this.setFormatType(FORMAT_TYPE.JSON);
        }
    }

    public FORMAT_TYPE getFormatType() {
        return this._formatType;
    }

    public void setFormatType(FORMAT_TYPE formatType) {
        this._formatType = formatType;
    }

    public boolean isSecuredAccess() {
        return this._securedAccess;
    }

    public void setSecuredAccess(boolean securedAccess) {
        this._securedAccess = securedAccess;
    }

    public long getPaginationSize() {
        return this._paginationSize;
    }

    public void setPaginationSize(long paginationSize) {
        this._paginationSize = paginationSize;
    }

    public List<String> getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(List<String> mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public String getConnectionName() {
        return this._qualifiedConnName;
    }

    public void setConnectionName(String _qualifiedConnName) {
        this._qualifiedConnName = _qualifiedConnName;
    }

    public List<RestHandlerParameter> getParameters() {
        return this._parameters;
    }

    public void setParameters(List<RestHandlerParameter> parameters) {
        this._parameters = parameters;
    }

    public void addParameter(RestHandlerParameter parameter) {
        if (this._parameters == null) {
            this._parameters = new ArrayList<RestHandlerParameter>();
        }
        this._parameters.add(parameter);
    }

    public String getSourceTypeGenerator() {
        if (this._httpMethodType != null) {
            if (this._httpMethodType == HTTP_METHOD_TYPE.GET) {
                if (this._sourceType != null) {
                    if (this._sourceType == SOURCE_TYPE.QUERY && this._formatType == FORMAT_TYPE.CSV) {
                        return GENERATOR_QUERY_CSV;
                    }
                    return this._sourceType.getGenerator();
                }
            } else {
                return GENERATOR_PLSQL;
            }
        }
        return GENERATOR_COLLECTION_JSON;
    }

    public String getComments() {
        return this._comments;
    }

    public void setComments(String comments) {
        this._comments = comments;
    }

    public static enum FORMAT_TYPE {
        JSON("JSON", RestMessages.getString("FORMAT_JSON")),
        CSV("CSV", RestMessages.getString("FORMAT_CSV"));

        private String type;
        private String nlsName;

        private FORMAT_TYPE(String type, String nlsName) {
            this.type = type;
            this.nlsName = nlsName;
        }

        public String getType() {
            return this.type;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }

    public static enum HTTP_METHOD_TYPE {
        GET("get", RestMessages.getString("METHOD_GET")),
        POST("post", RestMessages.getString("METHOD_POST")),
        PUT("put", RestMessages.getString("METHOD_PUT")),
        DELETE("delete", RestMessages.getString("METHOD_DELETE"));

        private String type;
        private String nlsName;

        private HTTP_METHOD_TYPE(String type, String nlsName) {
            this.type = type;
            this.nlsName = nlsName;
        }

        public String getType() {
            return this.type;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }

    public static enum SOURCE_TYPE {
        COLLECTION_QUERY("json/collection", RestMessages.getString("SOURCE_COLLECTION_QUERY")),
        COLLECTION_QUERY_ITEM("json/item", RestMessages.getString("SOURCE_COLLECTION_QUERY_ITEM")),
        QUERY("json/query", RestMessages.getString("SOURCE_QUERY")),
        QUERY_ONE_ROW("json/query;type=single", RestMessages.getString("SOURCE_QUERY_ONE_ROW")),
        FEED("json/query;type=feed", RestMessages.getString("SOURCE_FEED")),
        PLSQL("plsql/block", RestMessages.getString("SOURCE_PLSQL")),
        MEDIA_RESOURCE("resource/lob", RestMessages.getString("SOURCE_MEDIA"));

        private String generator;
        private String nlsName;

        private SOURCE_TYPE(String generator, String nlsName) {
            this.generator = generator;
            this.nlsName = nlsName;
        }

        public String getGenerator() {
            return this.generator;
        }

        public String getNLS() {
            return this.nlsName;
        }
    }
}

