/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.generators;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.rest.RestMessages;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;

public class RestCodeGenerator {
    private static volatile RestCodeGenerator _instance;
    private static final String ORDS_GROUP_FILE = "oracle/dbtools/rest/generators/templates/ordsgen.stg";
    private STGroup m_templateGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestCodeGenerator getInstance() {
        if (_instance != null) return _instance;
        Class<RestCodeGenerator> clazz = RestCodeGenerator.class;
        synchronized (RestCodeGenerator.class) {
            if (_instance != null) return _instance;
            _instance = new RestCodeGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private RestCodeGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected STGroup getTemplateGroup() {
        if (this.m_templateGroup == null) {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(RestCodeGenerator.class.getClassLoader());
            try {
                this.m_templateGroup = new STGroupFile(ORDS_GROUP_FILE);
            }
            catch (Throwable e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        }
        return this.m_templateGroup;
    }

    protected String getTemplate(String templateName, Map<String, Object> properties) {
        if (this.getTemplateGroup() != null) {
            ST st = this.getTemplateGroup().getInstanceOf(templateName);
            if (st != null) {
                Set<String> keys = properties.keySet();
                for (String k : keys) {
                    st.add(k, properties.get(k));
                }
                NoIndentWriter out = new NoIndentWriter((Writer)new StringWriter());
                try {
                    st.write((STWriter)out);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return st.render();
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format("GEN_TEMPLATE_NOT_FOUND", templateName));
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format("GEN_GROUP_FILE_NOT_FOUND", ORDS_GROUP_FILE));
        }
        return null;
    }
}

