/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.Serializable;
import oracle.dbtools.common.utils.ModelUtil;

public abstract class QueryParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String type;
    private boolean sortable;
    private boolean filterable;
    private String prompt;
    private String tooltip;
    private boolean isDefaultFilter;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setDefaultFilter(boolean def) {
        this.isDefaultFilter = def;
    }

    public boolean isDefaultFilter() {
        return this.isDefaultFilter;
    }

    public abstract String toXML(int var1);

    public static String getIndent(int idx) {
        String indent = "";
        for (int i = 0; i < idx; ++i) {
            indent = indent + "\t";
        }
        return indent;
    }

    protected String getBaseAttributes() {
        StringBuffer sb = new StringBuffer();
        if (this.filterable) {
            sb.append("filterable=\"true\"");
        }
        if (this.sortable) {
            sb.append("sortable=\"true\"");
        }
        return sb.toString();
    }

    protected String getBaseChildren(int indent) {
        StringBuffer sb = new StringBuffer();
        if (ModelUtil.hasLength(this.type)) {
            sb.append(QueryParameter.getIndent(indent) + "<type><![CDATA[" + this.type + "]]></type>\n");
        }
        if (ModelUtil.hasLength(this.prompt)) {
            sb.append(QueryParameter.getIndent(indent) + "<prompt><![CDATA[" + this.prompt + "]]></prompt>\n");
        }
        if (ModelUtil.hasLength(this.tooltip)) {
            sb.append(QueryParameter.getIndent(indent) + "<tooltip><![CDATA[" + this.tooltip + "]]></tooltip>\n");
        }
        return sb.toString();
    }
}

