/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

final class Strings {
    private Strings() {
    }

    static String[] hostAndPort(String url) {
        String[] parts;
        if (!url.startsWith("http:") && url.indexOf(":") != -1) {
            url = "http:" + url;
        }
        if ((parts = url.split(":")).length <= 1) {
            return null;
        }
        String host = Strings.trim(parts[1], '/');
        if (host == null || host.length() == 0) {
            return null;
        }
        String port = null;
        if (parts.length > 2) {
            port = Strings.trim(parts[2], '/');
        }
        return new String[]{host, port};
    }

    static String trim(String s, char c) {
        int start = Strings.firstNonMatchingChar(s, c);
        int end = Strings.lastNonMatchingChar(s, c);
        if (start == -1 || end == -1) {
            return null;
        }
        if (end - start <= 0) {
            return null;
        }
        return s.substring(start, end);
    }

    private static int lastNonMatchingChar(String s, char c) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == c) continue;
            return i + 1;
        }
        return -1;
    }

    private static int firstNonMatchingChar(String s, char c) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }
}

