/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Connection;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraConstants;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.Datum;

public abstract class OraTemporalDatumFormat
extends Format
implements OraConstants {
    private OraSimpleDateFormatDelegate delegate;
    private Connection connection = null;
    private TimeZone sessionTimeZone;
    protected static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR_FIELD = 15;
    public static final int TIMEZONE_FIELD = 17;
    public static final int ALL_FIELD = 1000;
    public static final int CENTRY_FIELD = 1001;
    public static final int JULIAN_DAY_FIELD = 1002;
    public static final int QUARTER_OF_YEAR_FIELD = 1003;
    public static final int SECONDS_FIELD = 1004;
    public static final int TEXT_FIELD = 1005;
    public static final int ISO_YEAR_FIELD = 1006;
    public static final int ISO_WEEK_OF_YEAR_FIELD = 1007;

    protected static boolean areEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    public OraTemporalDatumFormat(String pattern, OraLocaleInfo localeInfo, TimeZone sessionTimeZone) throws ParseException {
        this.delegate = new OraSimpleDateFormatDelegate(pattern, localeInfo);
        this.sessionTimeZone = sessionTimeZone;
        this.applyPattern(pattern);
    }

    public final OraLocaleInfo getOraLocaleInfo() {
        return this.delegate.localeInfo;
    }

    public final Locale getLocale() {
        return this.delegate.localeInfo.getLocale();
    }

    public final void setConnection(Connection connection) {
        this.connection = connection;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    protected final String getSavedPattern() {
        return this.delegate.savedPattern;
    }

    protected TimeZone getSessionTimeZone() {
        return this.sessionTimeZone;
    }

    protected abstract OraTemporalDatum getTemporalDatum(Calendar var1, int var2);

    @Override
    public Object clone() {
        OraTemporalDatumFormat osdf = (OraTemporalDatumFormat)super.clone();
        osdf.delegate = (OraSimpleDateFormatDelegate)this.delegate.clone();
        osdf.connection = this.connection;
        return osdf;
    }

    public void applyPattern(String pattern) throws ParseException {
        this.delegate.gdkApplyPattern(pattern);
        this.delegate.savedPattern = pattern;
    }

    public String toPattern() {
        return this.getSavedPattern();
    }

    protected String getLastPattern() {
        return this.delegate.toPattern();
    }

    public Calendar getCalendar() {
        return this.delegate.getCalendar();
    }

    protected void applyParsePattern(String pattern) throws ParseException {
        int cnt;
        int i;
        String uc = pattern.toUpperCase(Locale.US);
        StringBuffer pat = new StringBuffer(pattern);
        int pos = -1;
        while ((pos = uc.indexOf("SP", pos + 1)) >= 0) {
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraSimpleDATEFormat.63"), pos);
        }
        pos = -1;
        while ((pos = uc.indexOf("TH", pos + 1)) >= 0) {
            if (pos > 2 && uc.substring(pos - 3, pos + 2).equals("MONTH")) continue;
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraSimpleDATEFormat.63"), pos);
        }
        this.delegate.gdkApplyPattern(pat.toString());
    }

    protected void applyFormatPattern(String pattern) throws ParseException {
        this.delegate.gdkApplyPattern(pattern);
    }

    public abstract Datum parse(String var1, ParsePosition var2);

    public Datum parse(String source) throws ParseException {
        return this.parse(source, new ParsePosition(0));
    }

    public final Datum parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    protected OraTemporalDatum parseTemporalDatum(String text, ParsePosition pos, TimeZone prepareTimeZone, boolean parseTimezone) {
        if (text != null && text.length() > 0) {
            ParsePosition savedPos = new ParsePosition(pos.getIndex());
            this.prepareToParse(prepareTimeZone);
            Date date = this.delegate.parse(text, pos);
            long time = date.getTime();
            int nanos = date instanceof Timestamp ? ((Timestamp)date).getNanos() : 0;
            TimeZone timeZone = parseTimezone ? this.delegate.reparseforTimeZone(text, savedPos) : prepareTimeZone;
            Calendar cal = this.getDatumParseCalendar(time, timeZone);
            return this.getTemporalDatum(cal, nanos);
        }
        return null;
    }

    protected OraTemporalDatum parseTemporalDatum(String text, ParsePosition pos, TimeZone parseTimeZone) {
        return this.parseTemporalDatum(text, pos, parseTimeZone, false);
    }

    private void prepareToParse(TimeZone timezone) {
        this.delegate.applyTimeZone(timezone);
        this.delegate.applyTimeInMillis(new Date().getTime());
    }

    protected StringBuffer formatTemporalDatum(OraTemporalDatum temporalDatum, StringBuffer toAppendTo, FieldPosition pos) {
        if (temporalDatum != null) {
            this.prepareToFormat(temporalDatum.getTimeZone());
            return this.delegate.format(temporalDatum.toTimestamp(), toAppendTo, pos);
        }
        return toAppendTo;
    }

    private void prepareToFormat(TimeZone timezone) {
        this.delegate.applyTimeZone(timezone);
    }

    protected Calendar getDatumFormatCalendar(TimeZone timezone) {
        Calendar cal = (Calendar)this.delegate.shareCalendar().clone();
        cal.clear();
        cal.setTimeZone(timezone);
        return cal;
    }

    protected Calendar getDatumParseCalendar(long time, TimeZone timezone) {
        Calendar cal = Calendar.getInstance(timezone, Locale.US);
        cal.setTimeInMillis(time);
        return cal;
    }

    private class OraSimpleDateFormatDelegate
    extends OraSimpleDateFormat
    implements Cloneable {
        private static final int FIELD_NULL = Integer.MIN_VALUE;
        private static final int MILLISECONDS_PER_HOUR = 3600000;
        private static final int MILLISECONDS_PER_MINUTE = 60000;
        private OraLocaleInfo localeInfo;
        private String savedPattern;
        private OraDateFormatSymbols symbols;

        public OraSimpleDateFormatDelegate(String pattern, OraLocaleInfo localeInfo) throws ParseException {
            super(pattern, localeInfo);
            this.savedPattern = null;
            this.savedPattern = pattern;
            this.localeInfo = localeInfo;
            this.symbols = new OraDateFormatSymbols(localeInfo);
        }

        public Object clone() {
            OraSimpleDateFormatDelegate osdf = (OraSimpleDateFormatDelegate)super.clone();
            osdf.localeInfo = (OraLocaleInfo)this.localeInfo.clone();
            osdf.savedPattern = this.savedPattern;
            return osdf;
        }

        public Calendar shareCalendar() {
            return this.calendar;
        }

        public void applyTimeZone(TimeZone value) {
            this.calendar.setTimeZone(value);
        }

        public void applyTimeInMillis(long millis) {
            this.calendar.setTimeInMillis(millis);
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format(this.savedPattern, date, toAppendTo, pos);
        }

        public StringBuffer format(String pattern, Date date, StringBuffer toAppendTo, FieldPosition pos) {
            try {
                OraTemporalDatumFormat.this.applyFormatPattern(pattern);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.61"), pe);
            }
            return super.format(date, toAppendTo, pos);
        }

        public Date parse(String text, ParsePosition pos) {
            return this.parse(this.savedPattern, text, pos);
        }

        public TimeZone reparseforTimeZone(String text, ParsePosition pos) {
            return this.reparseforTimeZone(this.savedPattern, text, pos);
        }

        public Date parse(String pattern, String text, ParsePosition pos) {
            try {
                OraTemporalDatumFormat.this.applyParsePattern(pattern);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.62"), pe);
            }
            return super.parse(text, pos);
        }

        protected final void gdkApplyPattern(String pattern) throws ParseException {
            String currentPattern;
            try {
                currentPattern = this.toPattern();
            }
            catch (NullPointerException npe) {
                currentPattern = null;
            }
            if (!OraTemporalDatumFormat.areEqual(pattern, currentPattern)) {
                this.applyPattern(pattern);
            }
        }

        public TimeZone reparseforTimeZone(String pattern, String text, ParsePosition pos) {
            TimeZone tz = null;
            String tzRegEx = "(([\"][^\"]*[\"])|.)*TZR";
            Pattern p = Pattern.compile("(([\"][^\"]*[\"])|.)*TZR");
            Matcher m = p.matcher(pattern);
            if (m.matches()) {
                String badPattern = pattern.substring(0, m.end() - 3) + "\"X\"TZR";
                try {
                    this.parse(badPattern, text, pos);
                }
                catch (Exception e) {
                    ParsePosition tzrPos = new ParsePosition(pos.getErrorIndex());
                    String tzId = this.getTimeZoneID(text, text.length(), tzrPos);
                    tz = TimeZone.getTimeZone(tzId);
                }
            }
            return tz;
        }

        private String getTimeZoneID(String text, int tlen, ParsePosition pos) {
            String[] tzIDs = TimeZone.getAvailableIDs();
            int ti = pos.getIndex();
            for (int i = 0; i < tzIDs.length; ++i) {
                int tzlen = tzIDs[i].length();
                if (ti + tzlen > tlen || !text.regionMatches(true, ti, tzIDs[i], 0, tzlen)) continue;
                pos.setIndex(ti + tzlen);
                return tzIDs[i];
            }
            return null;
        }

        private String getTimeZoneAbbr(String text, int tlen, ParsePosition pos) {
            int ti = pos.getIndex();
            if (ti + 3 > tlen) {
                return null;
            }
            pos.setIndex(ti + 3);
            return text.substring(ti, ti + 3);
        }

        private boolean setTimeZone(String id, String abbr, Calendar cal, Locale loc) {
            TimeZone tz;
            if (id != null) {
                tz = TimeZone.getTimeZone(id);
                cal.setTimeZone(tz);
            } else {
                tz = cal.getTimeZone();
            }
            if (abbr != null) {
                if (tz.getDisplayName(true, 0, loc).equals(abbr) && !tz.inDaylightTime(cal.getTime())) {
                    return false;
                }
                if (tz.getDisplayName(false, 0, loc).equals(abbr) && tz.inDaylightTime(cal.getTime())) {
                    return false;
                }
            }
            return true;
        }

        private int getTimeZoneOffset(String text, int tlen, ParsePosition pos, int fc, boolean fx, boolean fm) {
            int offset = Integer.MIN_VALUE;
            int ti = pos.getIndex();
            boolean tzm_only = false;
            if (ti >= tlen) {
                return Integer.MIN_VALUE;
            }
            char ch = text.charAt(ti);
            if (ch == ':') {
                if (++ti >= tlen) {
                    return Integer.MIN_VALUE;
                }
                pos.setIndex(ti);
                ch = text.charAt(ti);
                tzm_only = true;
            }
            if (Character.isDigit(ch) || ti + 2 <= tlen && (ch == '+' || ch == '-')) {
                boolean isNegative;
                offset = 0;
                int min = 0;
                int hr = 0;
                if (ch == '-') {
                    isNegative = true;
                    ++ti;
                } else {
                    isNegative = false;
                    if (ch == '+') {
                        ++ti;
                    }
                }
                pos.setIndex(ti);
                hr = this.toNumber(text, tlen, pos, 2, false, fx, fm);
                if (hr >= 0) {
                    if (tzm_only) {
                        min = hr;
                        int[] fa = OraDateFormatPattern.FORMAT_ATTR[1];
                        if (isNegative && -min < fa[1] || !isNegative && min > fa[2]) {
                            return Integer.MIN_VALUE;
                        }
                        offset = min * 60000;
                    } else {
                        int[] fa = OraDateFormatPattern.FORMAT_ATTR[0];
                        if (isNegative && -hr < fa[1] || !isNegative && hr > fa[2]) {
                            return Integer.MIN_VALUE;
                        }
                        offset = hr * 3600000;
                        ti = pos.getIndex();
                        if (ti < tlen && text.charAt(ti) == ':') {
                            pos.setIndex(++ti);
                        }
                        if (ti < tlen && text.charAt(ti) == '+') {
                            pos.setIndex(++ti);
                        }
                        if (ti < tlen && (min = this.toNumber(text, tlen, pos, 2, false, fx, fm)) >= 0) {
                            fa = OraDateFormatPattern.FORMAT_ATTR[1];
                            if (min < fa[1] || min > fa[2]) {
                                return Integer.MIN_VALUE;
                            }
                            offset += min * 60000;
                        }
                    }
                }
                if (isNegative) {
                    offset = -offset;
                }
            }
            return offset;
        }

        private int toNumber(String text, int tlen, ParsePosition pos, int flen, boolean sep, boolean fx, boolean fm) {
            int fi;
            int ti = pos.getIndex();
            char ch = text.charAt(ti);
            if (!Character.isDigit(ch)) {
                return -5058;
            }
            int num = Character.digit(ch, 10);
            ++ti;
            for (fi = 1; fi < flen && ti < tlen; ++fi, ++ti) {
                ch = text.charAt(ti);
                if (ch == this.symbols.getGroupingSeparator()) {
                    if (sep) continue;
                    break;
                }
                if (!Character.isDigit(ch)) break;
                num = num * 10 + Character.digit(ch, 10);
            }
            if (fx && !fm && fi != flen) {
                return -5062;
            }
            pos.setIndex(ti);
            return num;
        }
    }

    private static class OraDateFormatSymbols {
        private OraLocaleInfo localeInfo;

        public OraDateFormatSymbols(OraLocaleInfo localeInfo) {
            this.localeInfo = localeInfo;
        }

        public char getGroupingSeparator() {
            return this.localeInfo.getOraTerritory().getGroupSeparator().charAt(0);
        }
    }

    private static class OraDateFormatPattern {
        private static final int TZMAXMINUTE = 59;
        private static final int TZMAXHOUR = 14;
        private static final int TZMINMINUTE = -59;
        private static final int TZMINHOUR = -12;
        static final char TZH = '\u0000';
        static final char TZM = '\u0001';
        static final char TZD = '\u0002';
        static final char TZR = '\u0003';
        static final char ALPHA = '\u0080';
        static final char FNJUS = '@';
        static final char NEG = ' ';
        static final int FORMAT_ATTR_ERR = 0;
        static final int FORMAT_ATTR_LOW = 1;
        static final int FORMAT_ATTR_HIGH = 2;
        static final int FORMAT_ATTR_LEN = 3;
        static final int FORMAT_FIELD = 4;
        static final int[][] FORMAT_ATTR = new int[][]{{5074, -12, 14, 35, 8}, {5075, -59, 59, 2, 8}, {5057, 0, 12, 198, 8}, {5057, 0, 64, 224, 8}};

        private OraDateFormatPattern() {
        }
    }
}

