/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowWrap
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWWRAP = new String[]{"wra", "wrap"};

    @Override
    public String[] getShowAliases() {
        return SHOWWRAP;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowWrap(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doShowWrap(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String onoroff = (String)ctx.getProperty("script.runner.setwrap");
        if (onoroff.matches("(?i:on|off)")) {
            String str = "";
            str = onoroff.equalsIgnoreCase("ON") ? Messages.getString("WRAP_ON") + Show.m_lineSeparator : Messages.getString("WRAP_OFF") + Show.m_lineSeparator;
            ctx.write(str);
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String onoroff = (String)ctx.getProperty("script.runner.setwrap");
        if (onoroff.matches("(?i:on|off)")) {
            String str = "";
            if (onoroff.equalsIgnoreCase("ON")) {
                return StoreRegistry.getCommand("wrap", "ON");
            }
        }
        return StoreRegistry.getCommand("wrap", "OFF");
    }
}

