/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowNumformat
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWNUMFORMAT = new String[]{"numf", "numfo", "numfor", "numform", "numforma", "numformat"};

    @Override
    public String[] getShowAliases() {
        return SHOWNUMFORMAT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowNumformat(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowNumformat(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String val = (String)ctx.getProperty("script.runner.setnumformat");
        String str = MessageFormat.format(Messages.getString("NUMFORMAT"), "\"" + val + "\"") + Show.m_lineSeparator;
        ctx.write(str);
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String name = (String)ctx.getProperty("script.runner.setnumformat");
        return StoreRegistry.getCommand("numformat", MessageFormat.format("\"{0}\"", name));
    }
}

