/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.commands.show.Messages;
import oracle.dbtools.util.Logger;

public class ShowLogin
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline {
    private static String[] prefixes = new String[]{"http", "https", "ftp", "sftp"};
    private static final String[] SHOWLOGIN = new String[]{"login", "glogin"};

    @Override
    public String[] getShowAliases() {
        return SHOWLOGIN;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.handleShowLogin(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean handleShowLogin(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String overRide = ShowLogin.getGUIOverRide(ctx);
        if (overRide != null) {
            ctx.write(Messages.getString("OVERRIDE"));
            ctx.write(overRide + "\n\n");
        }
        if (ShowLogin.isCannotReadFileSystem(ctx)) {
            ctx.write(Messages.getString("CANNOTREADFILESYSTEM"));
            ctx.write("\n\n");
        }
        ArrayList<String> entries = ShowLogin.getLocations(ctx, null, false);
        ctx.write(Messages.getString("GLOGINDIR"));
        for (String entry : entries) {
            if (entry == null) continue;
            ctx.write(entry + "\n");
        }
        entries = ShowLogin.getLocations(ctx, "glogin.sql", false);
        if (entries.size() != 0) {
            ctx.write("\nglogin.sql \n---------------------\n" + entries.get(0) + "\n");
        }
        entries = ShowLogin.getLocations(ctx, null, true);
        ctx.write(Messages.getString("LOGINDIR"));
        for (String entry : entries) {
            if (entry == null) continue;
            ctx.write(entry + "\n");
        }
        entries = ShowLogin.getLocations(ctx, "login.sql", true);
        if (entries.size() != 0) {
            ctx.write("\nlogin.sql \n---------------------\n" + entries.get(0) + "\n");
        }
        return true;
    }

    public static String getGUIOverRide(ScriptRunnerContext ctx) {
        Boolean isGUIOverRide = (Boolean)ctx.getProperty("DBConfig.GLOGIN");
        String gUIOverRide = (String)ctx.getProperty("DBConfig.GLOGIN_FILE");
        if ((isGUIOverRide == null || isGUIOverRide.equals(Boolean.TRUE)) && gUIOverRide != null && !gUIOverRide.equals("")) {
            return gUIOverRide;
        }
        return null;
    }

    static boolean isCannotReadFileSystem(ScriptRunnerContext ctx) {
        boolean retVal = false;
        if (ctx.getProperty("script.runner.restrict_level") != null) {
            try {
                if (Integer.parseInt((String)ctx.getProperty("script.runner.restrict_level")) > 2) {
                    retVal = true;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.warn(new ShowLogin().getClass(), nfe);
            }
        }
        return retVal;
    }

    public static String firstOrNull(ArrayList<String> aL) {
        String retVal = null;
        if (aL.size() > 0) {
            retVal = aL.get(0);
        }
        return retVal;
    }

    public static ArrayList<String> getLocations(ScriptRunnerContext ctx, String match, boolean login) {
        String OH;
        ArrayList<String> retVal = new ArrayList<String>();
        if (match != null && ShowLogin.isCannotReadFileSystem(ctx)) {
            return retVal;
        }
        String overRide = ShowLogin.getGUIOverRide(ctx);
        if (match != null && match.equals("glogin.sql") && overRide != null) {
            retVal.add(overRide);
            return retVal;
        }
        if (match != null && login && overRide != null) {
            return retVal;
        }
        String SQLH = System.getenv("SQL_HOME");
        if (SQLH != null) {
            retVal.add(ShowLogin.addDirEnding(SQLH));
        }
        if ((OH = (String)ctx.getProperty("script.runner.oraclehomemainthread")) != null && !OH.equals("") && !login) {
            if (!OH.endsWith(File.separator)) {
                OH = OH + File.separator;
            }
            OH = OH + "sqlplus" + File.separator + "admin";
            retVal.add(ShowLogin.addDirEnding(OH));
        }
        ArrayList<String> al = null;
        if (login) {
            al = ShowLogin.getSQLPath(ctx);
        }
        if (al != null) {
            for (String sp : al) {
                retVal.add(ShowLogin.addDirEnding(sp));
            }
        }
        if (match != null) {
            for (String dir : retVal) {
                if (dir == null || !new File(dir + match).canRead()) continue;
                ArrayList<String> retOne = new ArrayList<String>();
                retOne.add(dir + match);
                return retOne;
            }
            return new ArrayList<String>();
        }
        return retVal;
    }

    public static ArrayList<String> getSQLPath(ScriptRunnerContext ctx) {
        String[] sources;
        ArrayList<String> retVal = new ArrayList<String>();
        for (String sA : sources = new String[]{(String)ctx.getProperty("script.runner.cd_command"), (String)ctx.getProperty("DBConfig.DEFAULT_PATH"), (String)ctx.getProperty("script.runner.sqlpathprovidermainthread")}) {
            String lastPrefix = null;
            if (sA == null) continue;
            for (String s : sA.split(File.pathSeparator)) {
                if (File.pathSeparator.equals(":") && lastPrefix == null) {
                    for (String prefix : prefixes) {
                        if (!s.equals(prefix)) continue;
                        lastPrefix = prefix;
                        break;
                    }
                    if (lastPrefix != null) continue;
                }
                if (lastPrefix != null) {
                    s = lastPrefix + ":" + s;
                    lastPrefix = null;
                }
                retVal.add(s);
            }
        }
        return retVal;
    }

    public static String addDirEnding(String in) {
        String retVal = in;
        String add = File.separator;
        if (retVal != null) {
            if (retVal.equals("")) {
                return null;
            }
            if (retVal.startsWith("http:") || retVal.startsWith("https:") || retVal.startsWith("ftp:")) {
                return null;
            }
            if (!retVal.endsWith(add)) {
                retVal = retVal + add;
            }
        }
        return retVal;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

