/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.Messages;
import oracle.jdbc.OracleConnection;

public class ShowBtitle
implements IShowCommand {
    protected static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String[] SHOWBTITLE = new String[]{"bti", "btit", "btitl", "btitle"};

    @Override
    public String[] getShowAliases() {
        return SHOWBTITLE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowBtitle(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowBtitle(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getBTitle() == null) {
            ctx.write("BTitle OFF\n");
        } else {
            boolean flag = ctx.getBTitleFlag();
            if (flag) {
                String btitleString = ctx.getBTitleCmd();
                ctx.write(MessageFormat.format(Messages.getString("BTITLE_ON"), btitleString.length()) + m_lineSeparator);
                ctx.write(ctx.getBTitle().getCommand() + m_lineSeparator);
            } else {
                String btitleString = ctx.getBTitleCmd();
                ctx.write(MessageFormat.format(Messages.getString("BTITLE_OFF"), btitleString.length()) + m_lineSeparator);
                ctx.write(ctx.getBTitle().getCommand() + m_lineSeparator);
            }
        }
        return true;
    }
}

