/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowNoRows;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.query.Bind;

public class ShowBinds
implements IShowCommand,
IShowPrefixNameNewline,
IShowNoRows {
    private static final String[] SHOWBINDS = new String[]{"binds"};

    @Override
    public String[] getShowAliases() {
        return SHOWBINDS;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Map<String, Bind> m = ctx.getVarMap();
        if (m.size() != 0) {
            String optionalHeader = (String)ctx.getProperty("script.runner.optional_show_header");
            if (optionalHeader != null && !optionalHeader.equals("")) {
                ctx.write(optionalHeader);
            }
            SQLCommand printSql = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_PRINT, SQLCommand.StmtResultType.G_R_NONE, true);
            printSql.setOrigSQL("print");
            printSql.setSql("print");
            SQLPLUS sp = new SQLPLUS(printSql, ctx.getOutputStream());
            sp.setConn(conn);
            sp.setScriptRunnerContext(ctx);
            sp.run();
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

