/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class XQuery
extends CommandListener {
    private static final String SELECT_STUB = "select column_value from {0}";
    private static final String XTABLE_STUB = "xmltable({0})";
    private static final String XQUERY_STUB = "xmlquery({0} returning content)";
    private static final String PASSING_STUB = "{0} passing {1}";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String baseuri = (String)ctx.getProperty("xquery.baseuri");
        String order = (String)ctx.getProperty("xquery.ordering");
        String node = (String)ctx.getProperty("xquery.node");
        String context = (String)ctx.getProperty("xquery.context");
        StringBuilder sb = new StringBuilder();
        if (baseuri != null && baseuri.length() > 0) {
            sb.append("declare base-uri " + this.enclose(baseuri, '\"') + "; ");
        }
        if (node != null && !"default".equals(node.toLowerCase())) {
            sb.append("declare node " + node.toLowerCase() + "; ");
        }
        if (order != null && !"default".equals(order.toLowerCase())) {
            sb.append("declare ordering " + order.toLowerCase() + "; ");
        }
        cmd.setStmtClass(SQLCommand.StmtType.G_C_SQL);
        String cmdSQL = cmd.getSql();
        Pattern p = Pattern.compile("(?i)\\s*xquery\\s*;?\\s*");
        Matcher m = p.matcher(cmdSQL);
        int position = m.find() ? m.end() : 0;
        String selectSQL = cmdSQL.substring(position).trim();
        String queryString = this.enclose(selectSQL, '\'');
        String passingContext = context != null && context.length() > 0 ? MessageFormat.format(XQUERY_STUB, this.enclose(context, '\'')) : null;
        String xmlQuery = passingContext != null ? MessageFormat.format(PASSING_STUB, queryString, passingContext) : queryString;
        String newSQL = MessageFormat.format(SELECT_STUB, MessageFormat.format(XTABLE_STUB, xmlQuery));
        cmd.setResultsType(SQLCommand.StmtResultType.G_R_QUERY);
        cmd.setSql(newSQL);
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    private String enclose(String str, char c) {
        return this.escape(str, c, true);
    }

    private String escape(String str, char c) {
        return this.escape(str, c, false);
    }

    private String escape(String str, char c, boolean enclose) {
        StringBuilder sb = new StringBuilder();
        if (enclose) {
            sb.append(c);
        }
        if (str != null) {
            String pattern = "" + c;
            String replacement = pattern + c;
            sb.append(str.replaceAll(Pattern.quote(pattern), replacement));
        }
        if (enclose) {
            sb.append(c);
        }
        return sb.toString();
    }
}

