/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.Restricted;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.jdbc.pool.OracleDataSource;

@Restricted(level=Restricted.Level.REST)
public class SetTNSAdmin
extends CommandListener
implements IShowCommand {
    private boolean pingDB = false;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("settns")) {
            String[] parts = cmd.getSQLOrig().split(" ");
            if (parts.length < 3) {
                ctx.write(Messages.getString("TNS_USAGE"));
                return true;
            }
            if (parts[2].equalsIgnoreCase("off")) {
                System.setProperty("oracle.net.tns_admin", "");
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < parts.length; ++i) {
                    sb.append(parts[i]).append(" ");
                }
                File f = new File(sb.toString().trim());
                if (f.exists() && f.isDirectory()) {
                    ctx.write(MessageFormat.format(Messages.getString("TNS_LOCATION"), sb.toString().trim()) + "\n");
                    System.setProperty("oracle.net.tns_admin", sb.toString());
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("TNS_INVALID"), f.getAbsolutePath()) + "\n");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ArrayList<TCPTNSEntry> entries = null;
        String message = null;
        if (System.getProperty("oracle.net.tns_admin") == null || System.getProperty("oracle.net.tns_admin").toString().length() <= 0) {
            String[] bits = cmd.getSql().trim().split("\\s");
            if (bits.length == 2 && bits[1].equalsIgnoreCase("tnsping")) {
                this.pingDB = true;
            }
            entries = TNSHelper.getTNSEntries();
            Iterator<String> it = TNSHelper.getTNSLookupLocations().keySet().iterator();
            ctx.write("TNS Lookup locations\n--------------------\n");
            int i = 1;
            while (it.hasNext()) {
                String key = it.next();
                if (it.hasNext()) {
                    ctx.write(MessageFormat.format("{0}.  {1}\n    {2}\n", i, key, TNSHelper.getTNSLookupLocations().get(key)));
                    ++i;
                    continue;
                }
                ctx.write(MessageFormat.format("\nLocation used:\n-------------\n\t{0}\n", TNSHelper.getTNSLookupLocations().get(key)));
            }
            this.writeEntries(entries, ctx);
            return true;
        }
        message = MessageFormat.format(Messages.getString("TNS_LOCATION"), System.getProperty("oracle.net.tns_admin"));
        ctx.write("");
        ctx.write(message + "\n");
        entries = TNSHelper.getTNSEntries();
        this.writeEntries(entries, ctx);
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"tns", "tnsadmin", "tns_admin", "tnsping"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String test(String entry_name) {
        StringBuilder sb = new StringBuilder();
        Connection pconnection = null;
        long ping = 0L;
        long start = 0L;
        try {
            String l_url = TNSHelper.getEntry(entry_name).getJDBCUrl();
            start = System.currentTimeMillis();
            OracleDataSource ods = new OracleDataSource();
            ods.setURL(l_url);
            pconnection = ods.getConnection();
            ping = System.currentTimeMillis() - start;
        }
        catch (SQLException e) {
            int errorCode = e.getErrorCode();
            if (errorCode == 12514) {
                sb.append("\tListener is UP but database is DOWN");
            }
            if (errorCode == 17002) {
                sb.append("\tListener is DOWN");
            }
            if (errorCode == 1017) {
                sb.append("\tListener is UP and database is UP\n");
                sb.append(MessageFormat.format("\tping {0}ms", ping));
            }
        }
        finally {
            try {
                if (pconnection != null) {
                    pconnection.close();
                }
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    private void writeEntries(ArrayList<TCPTNSEntry> entries, ScriptRunnerContext ctx) {
        ctx.write("\nAvailable TNS Entries\n---------------------\n");
        ArrayList<String> names = new ArrayList<String>();
        for (TCPTNSEntry entry : entries) {
            names.add(entry.getName());
        }
        Iterator it3 = names.iterator();
        while (it3.hasNext()) {
            String name = TNSHelper.getEntry((String)it3.next()).getName();
            ctx.write(name + "\n");
            if (!this.pingDB) continue;
            ctx.write(SetTNSAdmin.test(name) + "\n");
        }
    }
}

