/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.WrapBufferOutputStreamToWriter;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.scriptrunner.Restricted;

@Restricted(level=Restricted.Level.HIGH)
public class SetSpool
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SPOOL;
    public static String fileExists = "FILE_EXISTS";

    public SetSpool() {
        super(m_cmdStmtSubType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        WrapListenBufferOutputStream existing;
        if (!ctx.isEchoOn()) {
            if (ctx.getTopLevel() && ctx.getProperty("script.runner.sqlplus.silent") != null && !((Boolean)ctx.getProperty("script.runner.sqlplus.silent")).booleanValue()) {
                SetSpool.writeToExisting(ctx.getPrompt() + cmd.getSQLOrig(), ctx);
                if (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) {
                    SetSpool.writeToExisting(";", ctx);
                } else if (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL)) {
                    SetSpool.writeToExisting("\n/", ctx);
                }
                SetSpool.writeToExisting("\n", ctx);
            } else if (ctx.isStdin() && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_AT)) {
                SetSpool.writeToExisting(ctx.getPrompt() + cmd.getSQLOrig() + "\n", ctx);
            }
        }
        if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL && (existing = (WrapListenBufferOutputStream)ctx.getProperty("Spool.out.buffer")) != null) {
            this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.filedisplay"), existing.getFileOutput().getAbsolutePath()), ctx);
            SetSpool.writeToExisting("\n\n", ctx);
        }
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!ctx.isEchoOn() && ctx.getTopLevel() && !ctx.isSQLPlusClassic() && !cmd.getSQLOrig().toLowerCase().endsWith("off")) {
            SetSpool.writeToExisting(ctx.getPrompt() + cmd.getSQLOrig(), ctx);
            SetSpool.writeToExisting("\n", ctx);
        }
        if ((Boolean)cmd.getProperty("prop_status_boolean") != null && ((Boolean)cmd.getProperty("prop_status_boolean")).booleanValue()) {
            if (cmd.getProperty("prop_file_string") != null) {
                String realFile = ScriptUtils.expandVariables(cmd.getSql().trim().replaceAll("^.*?[sS][pP][oO][^\\s]*\\s+", "").trim());
                if (realFile.indexOf("$") != -1) {
                    this.writeToMain(Messages.getString("SetSpool.5"), ctx);
                    return true;
                }
                String[] args = null;
                boolean writeFail = true;
                try {
                    String first;
                    boolean firstArgBad = false;
                    String[] bySplit = realFile.split("\\s+");
                    if (bySplit != null && bySplit.length > 0 && ((first = bySplit[0]).equalsIgnoreCase("CRE") || first.equalsIgnoreCase("CREA") || first.equalsIgnoreCase("CREAT") || first.equalsIgnoreCase("CREATE") || first.equalsIgnoreCase("REP") || first.equalsIgnoreCase("REPL") || first.equalsIgnoreCase("REPLA") || first.equalsIgnoreCase("REPLACE") || first.equalsIgnoreCase("APP") || first.equalsIgnoreCase("APPE") || first.equalsIgnoreCase("APPEN") || first.equalsIgnoreCase("APPEND"))) {
                        firstArgBad = true;
                        this.writeToMain(Messages.getString("SetSpool.filenamebad") + "\n", ctx);
                        this.usage(ctx, false, true);
                        return true;
                    }
                    args = ScriptUtils.executeArgs(realFile);
                    if (args != null) {
                        String processedRealFile = args[0];
                        writeFail = false;
                        if (!(args.length <= 2 && (args.length <= 1 || args[1].equalsIgnoreCase("CRE") || args[1].equalsIgnoreCase("CREA") || args[1].equalsIgnoreCase("CREAT") || args[1].equalsIgnoreCase("CREATE") || args[1].equalsIgnoreCase("REP") || args[1].equalsIgnoreCase("REPL") || args[1].equalsIgnoreCase("REPLA") || args[1].equalsIgnoreCase("REPLACE") || args[1].equalsIgnoreCase("APP") || args[1].equalsIgnoreCase("APPE") || args[1].equalsIgnoreCase("APPEN") || args[1].equalsIgnoreCase("APPEND")))) {
                            this.usage(ctx, true, false);
                        } else {
                            String createReplaceAppend = "R";
                            if (args.length > 1) {
                                if (args[1].equalsIgnoreCase("CRE") || args[1].equalsIgnoreCase("CREA") || args[1].equalsIgnoreCase("CREAT") || args[1].equalsIgnoreCase("CREATE")) {
                                    createReplaceAppend = "C";
                                } else if (args[1].equalsIgnoreCase("APP") || args[1].equalsIgnoreCase("APPE") || args[1].equalsIgnoreCase("APPEN") || args[1].equalsIgnoreCase("APPEND")) {
                                    createReplaceAppend = "A";
                                }
                            }
                            if (processedRealFile.equalsIgnoreCase("out")) {
                                this.stopSpool(ctx);
                                this.writeToMain(Messages.getString("SetSpool.printingnotsupported") + "\n", ctx);
                            } else {
                                this.initFile(processedRealFile, ctx, cmd, createReplaceAppend);
                            }
                        }
                    }
                }
                catch (ArgumentQuoteException aqe) {
                    String theQuote = "'";
                    if (realFile.length() > 1 && realFile.substring(0, 1).equals("\"")) {
                        theQuote = "\"";
                    }
                    this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.missingquote"), realFile, theQuote) + "\n", ctx);
                    this.writeToMain(Messages.getString("SetSpool.cannotcreate") + "\n", ctx);
                    writeFail = false;
                }
                if (writeFail) {
                    this.writeToMain(Messages.getString("SetSpool.invalidfilename") + "\n", ctx);
                }
            } else if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL && cmd.getSql().trim().toLowerCase().equals("spool")) {
                this.spoolKeyword(ctx);
            } else {
                this.initFile("spool", ctx, cmd, "R");
            }
        } else if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL && (cmd.getSql().trim().toLowerCase().equals("spool") || cmd.getSql().trim().toLowerCase().equals("spo") || cmd.getSql().trim().toLowerCase().equals("spoo"))) {
            this.spoolKeyword(ctx);
        } else if (cmd.getSql().trim().split(" ").length > 2) {
            this.usage(ctx, true, false);
        } else if (cmd.getSql().trim().split(" ").length == 2) {
            this.stopSpool(ctx);
        }
        return true;
    }

    private void usage(ScriptRunnerContext ctx, boolean illegal, boolean usage) {
        if (illegal) {
            ctx.write(Messages.getString("SetSpool.ILLEGALSPOOLANDUSAGE"));
        } else if (usage) {
            ctx.write(Messages.getString("SetSpool.SPOOLUSAGE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spoolKeyword(ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream existing = (WrapListenBufferOutputStream)ctx.getProperty("Spool.out.buffer");
        if (existing != null) {
            this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.filedisplay"), existing.getFileOutput().getName()), ctx);
        } else {
            this.writeToMain(Messages.getString("SetSpool.2"), ctx);
        }
        this.writeToMain("\n\n", ctx);
    }

    public void writeToMain(String op, ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream existing = ctx.getOutputStream();
        if (existing != null) {
            try {
                existing.write(op.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public static void writeToExisting(String op, ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream existing = (WrapListenBufferOutputStream)ctx.getProperty("Spool.out.buffer");
        if (existing != null) {
            try {
                existing.write(op.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger("SetSpool").log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IOException e) {
                Logger.getLogger("SetSpool").log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFile(String filename, ScriptRunnerContext ctx, ISQLCommand cmd, String createReplaceAppend) {
        boolean written = false;
        String fullpath = "";
        filename = ctx.prependCD(filename);
        boolean fileExistsError = false;
        try {
            if (filename.startsWith("/") || filename.startsWith("\\") || filename.length() > 2 && filename.charAt(1) == ':') {
                fullpath = filename;
            } else {
                URL myurl = (URL)ctx.getProperty("script.runner.node.url");
                if (myurl != null && myurl.getProtocol().equalsIgnoreCase("file")) {
                    FileOutputStream outStream = null;
                    try {
                        File f;
                        String localFullPath = null;
                        try {
                            f = new File(myurl.toURI());
                        }
                        catch (URISyntaxException e) {
                            f = new File(myurl.getPath());
                        }
                        if (!f.getParent().equals(System.getProperty("java.io.tmpdir"))) {
                            localFullPath = f.getParent() + File.separator + filename;
                            if (!this.doesParentExist(localFullPath = localFullPath.replace('/', '\\'))) {
                                localFullPath = localFullPath.replace('\\', '/');
                            }
                            if (this.addDotLst(localFullPath)) {
                                localFullPath = System.getProperty("os.name").startsWith("Windows") ? localFullPath + ".LST" : localFullPath + ".lst";
                            }
                            if (createReplaceAppend.equals("C") && new File(localFullPath).exists()) {
                                fullpath = localFullPath;
                                fileExistsError = true;
                                throw new IOException(fileExists);
                            }
                            new File(localFullPath).createNewFile();
                            File outputFile = new File(localFullPath);
                            if (!outputFile.canWrite()) {
                                throw new IOException();
                            }
                            fullpath = localFullPath;
                            written = true;
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (outStream != null) {
                            try {
                                outStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (!written) {
                    if (fileExistsError) {
                        throw new IOException(fileExists);
                    }
                    String settingsDir = ctx.getSettingsDir();
                    fullpath = settingsDir + File.separator + filename;
                }
            }
            fullpath = fullpath.replace('/', '\\');
            if (!this.doesParentExist(fullpath)) {
                fullpath = fullpath.replace('\\', '/');
            }
            if (this.addDotLst(fullpath)) {
                fullpath = System.getProperty("os.name").startsWith("Windows") ? fullpath + ".LST" : fullpath + ".lst";
            }
            this.createNewSpoolOut(filename, fullpath, ctx, written, createReplaceAppend);
        }
        catch (IOException e) {
            WrapListenBufferOutputStream existing = (WrapListenBufferOutputStream)ctx.getProperty("Spool.out.buffer");
            if (existing != null) {
                this.stopSpool(ctx);
            }
            if (e.getMessage() != null && e.getMessage().equals(fileExists)) {
                this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.fileExists") + "\n", fullpath), ctx);
            } else {
                this.writeToMain(Messages.getString("SetSpool.invalidfilename") + "\n", ctx);
            }
            ScriptUtils.doWhenever(ctx, cmd, ctx.getCurrentConnection(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopSpool(ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream existing = (WrapListenBufferOutputStream)ctx.getProperty("Spool.out.buffer");
        if (existing != null) {
            try {
                existing.flush();
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            ctx.getOutputStream().removeFromList(existing);
            try {
                existing.flush();
                existing.close();
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            ctx.putProperty("Spool.out.buffer", null);
            ctx.putProperty("Spool.out.filename", null);
            Thread child = (Thread)ctx.getProperty("sqlcl.spool.thread");
            try {
                if (child == null) return;
                for (int wait = 0; wait < 5 && child.getState().equals((Object)Thread.State.NEW); ++wait) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    catch (IllegalArgumentException ie) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ie.getStackTrace()[0].toString(), ie);
                    }
                }
                child.join(2000L);
                return;
            }
            catch (InterruptedException ie) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ie.getStackTrace()[0].toString(), ie);
                return;
            }
            finally {
                ctx.putProperty("sqlcl.spool.thread", null);
            }
        }
        ctx.write("not spooling currently\n");
    }

    private void createNewSpoolOut(String origFileName, String fullpath, ScriptRunnerContext ctx, boolean written, String createReplaceAppend) throws IOException {
        if (!written && createReplaceAppend.equals("C") && new File(fullpath).exists()) {
            throw new IOException(fileExists);
        }
        boolean isAppend = false;
        if (createReplaceAppend.equals("A")) {
            isAppend = true;
        }
        new File(fullpath).createNewFile();
        String encodingSetting = ctx.getEncoding();
        WrapListenBufferOutputStream myout = null;
        WrapBufferOutputStreamToWriter wb = null;
        wb = new WrapBufferOutputStreamToWriter(null);
        wb.setTerminator(ctx.getStringTerminator());
        wb.setOut(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullpath, isAppend), encodingSetting)));
        FilterOutputStream filterIfAvailable = null;
        filterIfAvailable = ctx.getSpoolFilterProvider() != null ? ctx.getSpoolFilterProvider().getFilterOutputStream(ctx, wb) : wb;
        myout = new WrapListenBufferOutputStream((OutputStream)new BufferedOutputStream(filterIfAvailable), ctx);
        myout.setFileOutput(new File(fullpath));
        myout.setRemoveForcePrint(true);
        WrapListenBufferOutputStream existing = (WrapListenBufferOutputStream)ctx.getProperty("Spool.out.buffer");
        if (existing != null) {
            this.stopSpool(ctx);
            ctx.putProperty("Spool.out.buffer", null);
            ctx.putProperty("Spool.out.filename", null);
        }
        ctx.putProperty("Spool.out.buffer", myout);
        ctx.putProperty("Spool.out.filename", origFileName);
        ctx.putProperty("sqlcl.spool.thread", wb.getThread());
        ctx.getOutputStream().addToList(myout);
    }

    private boolean doesParentExist(String in) {
        int lastbslash;
        int lastdir;
        int lastslash = in.lastIndexOf("/");
        if (lastslash > (lastdir = (lastbslash = in.lastIndexOf("\\")))) {
            lastdir = lastslash;
        }
        if (lastdir == -1) {
            return false;
        }
        if (!in.endsWith("/") && !in.endsWith("\\")) {
            ++lastdir;
        }
        return new File(in.substring(0, lastdir)).exists();
    }

    private boolean addDotLst(String in) {
        if (in.equals("/dev/null") || in.equals("\\dev\\null") || in.equals("/dev/stderr") || in.equals("\\dev\\stderr") || in.equals("/dev/stdout") || in.equals("\\dev\\stdout") || in.equals("/dev/error") || in.equals("\\dev\\error")) {
            return false;
        }
        int lastslash = in.lastIndexOf("/");
        int lastbslash = in.lastIndexOf("\\");
        int lastdot = in.lastIndexOf(".");
        int lastdir = lastbslash;
        if (lastslash > lastdir) {
            lastdir = lastslash;
        }
        return lastdot <= lastdir;
    }

    @Override
    public void endScript(Connection conn, ScriptRunnerContext ctx) {
        super.endScript(conn, ctx);
        if (ctx.getTopLevel()) {
            this.stopSpool(ctx);
            this.setCmdOn(false);
        }
    }
}

