/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;

public class SetShowMode
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_SHOWMODE;

    public SetShowMode() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            if ((str = str.trim().replaceAll("^(?i:set\\s+showmode)\\s+", "").trim()).matches("(?i:on|off|both)")) {
                this.showModeForShowMode(ctx, cmd, str);
                ctx.putProperty("script.runner.setshowmode", str.toUpperCase());
            } else {
                ctx.write(MessageFormat.format(Messages.getString("SETSHOWMODE_UKNOWNOPTION") + Show.m_lineSeparator, cmd.getSQLOrig().split("\\s+")[2]));
            }
        } else {
            ctx.write(Messages.getString("SETSHOWMODE_MISSING_OPTION") + Show.m_lineSeparator);
            return false;
        }
        return true;
    }

    private void showModeForShowMode(ScriptRunnerContext ctx, ISQLCommand cmd, String cmode) {
        String bmode = null;
        if (ctx.getProperty("script.runner.setshowmode") != null) {
            bmode = ctx.getProperty("script.runner.setshowmode").toString();
            if (bmode.equalsIgnoreCase("on")) {
                bmode = "BOTH";
            }
            this.setProperties(cmd, ctx, bmode, "showmode", "script.runner.setshowmode");
            if ((bmode.equalsIgnoreCase("on") || bmode.equalsIgnoreCase("both")) && (cmode.equalsIgnoreCase("on") || cmode.equalsIgnoreCase("both"))) {
                this.writeShowMode(cmd, ctx, "BOTH");
            } else if (bmode.equalsIgnoreCase("off") && (cmode.equalsIgnoreCase("on") || cmode.equalsIgnoreCase("both"))) {
                ctx.write("new: showmode BOTH\n");
            } else if ((bmode.equalsIgnoreCase("on") || bmode.equalsIgnoreCase("both")) && cmode.equalsIgnoreCase("off")) {
                ctx.write("old: showmode " + bmode + "\n");
            }
        }
    }
}

