/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;

public class SetPause
extends AForAllStmtsCommand
implements IStoreCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_PAUSE;
    private static final Boolean ON = Boolean.TRUE;
    private static final Boolean OFF = Boolean.FALSE;
    private static final String startUnique = "\nNewPagemarker";
    private static final String endUnique = "Z\n";
    private int pageNo = 0;
    private Integer pauseUnique = null;

    public SetPause() {
        super(s_cmdStmtSubType);
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String theString;
        String setPtrn = "(?i:set\\b\\s*)";
        String pausePtrn = "(?i:pau(?:|s|se)\\b\\s*)";
        String regex = "['|\"][\\w|\\s]*['|\"]|\\w+";
        String pauseString = cmd.getSql().replaceFirst(setPtrn, "").trim();
        if ("".equals(pauseString = pauseString.replaceFirst(pausePtrn, "").trim())) {
            ctx.write(MessageFormat.format(Messages.getString("SETUNKNOWNOPTION"), cmd.getSQLOrig().split("\\s+")[1]));
            return true;
        }
        if (!pauseString.matches(regex)) {
            ctx.write(MessageFormat.format(Messages.getString("SETUNKNOWNOPTION") + "\n", cmd.getSQLOrig().split("\\s+")[3]));
        }
        if ((theString = (String)cmd.getProperty("prop_file_string")) == null || theString.equals("")) {
            ctx.write(Messages.getString("SETPAUSENOARG"));
        } else if (theString.equalsIgnoreCase("on")) {
            ctx.putProperty("script.runner.set_pause", ON);
        } else if (theString.equalsIgnoreCase("off")) {
            ctx.putProperty("script.runner.set_pause", OFF);
        } else {
            if (theString.length() > 1) {
                theString = theString.startsWith("'") && theString.endsWith("'") || theString.startsWith("\"") && theString.endsWith("\"") ? theString.substring(1, theString.length() - 1) : theString.split(" ", 2)[0];
            }
            ctx.putProperty("script.runner.set_pause_value", theString);
        }
        return true;
    }

    @Override
    protected void doEndCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        super.doEndCmd(conn, ctx, cmd);
        Boolean onOrOff = (Boolean)ctx.getProperty("script.runner.set_pause");
        if (onOrOff != null) {
            if (onOrOff.equals(ON)) {
                this.setCmdOn(true);
            } else if (onOrOff.equals(OFF)) {
                this.setCmdOn(false);
            }
        }
    }

    private int matchesInString(ScriptRunnerContext ctx, StringBuffer data, int uniqueNo) {
        String unique = startUnique + uniqueNo + endUnique;
        int offset = 0;
        int matches = 0;
        while ((offset = data.indexOf(unique, offset)) != -1) {
            ++offset;
            ++matches;
        }
        return matches;
    }

    private int rewrite(ScriptRunnerContext ctx, StringBuffer data, int uniqueNo, int proposedNo) {
        String unique = startUnique + uniqueNo + endUnique;
        String proposed = startUnique + proposedNo + endUnique;
        int diff = proposed.length() - unique.length();
        int offset = 0;
        int matches = 0;
        while ((offset = data.indexOf(unique, offset)) != -1) {
            StringBuffer dataNew = new StringBuffer(data);
            data.setLength(offset);
            data.append(proposed);
            if (offset + unique.length() < dataNew.length()) {
                data.append(dataNew.substring(offset + unique.length()));
            }
            ++offset;
            offset += diff;
            if (++matches < this.pageNo - 1) continue;
            break;
        }
        return matches;
    }

    public void mark(ScriptRunnerContext ctx, Object out, StringBuffer databuf) {
        Integer proposed;
        ++this.pageNo;
        if (!(out instanceof BufferedOutputStream)) {
            return;
        }
        if (ctx.getProperty("script.runner.set_pause") != null && ((Boolean)ctx.getProperty("script.runner.set_pause")).equals(Boolean.TRUE)) {
            boolean exitOuter;
            Integer unique;
            proposed = unique = this.pauseUnique;
            if (unique == null) {
                proposed = 1;
            }
            do {
                int matchesInString;
                if ((matchesInString = this.matchesInString(ctx, databuf, proposed)) == this.pageNo - 1) {
                    if (unique == null) {
                        this.pauseUnique = proposed;
                    }
                    if (proposed == unique) {
                        // empty if block
                    }
                    break;
                }
                exitOuter = false;
                do {
                    Integer n = proposed;
                    Integer n2 = proposed = Integer.valueOf(proposed + 1);
                } while ((matchesInString = this.matchesInString(ctx, databuf, proposed)) != 0);
                if (unique != null) {
                    this.rewrite(ctx, databuf, unique, proposed);
                }
                this.pauseUnique = proposed;
            } while (!(exitOuter = true));
        } else {
            return;
        }
        databuf.append(startUnique + proposed + endUnique);
    }

    public boolean writeOut(ScriptRunnerContext ctx, Object out, StringBuffer dataBuf) throws IOException {
        if (!(out instanceof BufferedOutputStream)) {
            return false;
        }
        if (ctx.getProperty("script.runner.set_pause") != null && ((Boolean)ctx.getProperty("script.runner.set_pause")).equals(Boolean.TRUE) && ctx.getProperty("script.runner.set_pause_value") != null && this.pageNo != 0) {
            String unique = startUnique + this.pauseUnique + endUnique;
            int offset = 0;
            int prevOffset = 0;
            int matches = 0;
            boolean printRest = false;
            while ((offset = dataBuf.indexOf(unique, prevOffset)) != -1) {
                this.write(out, dataBuf.substring(prevOffset, offset));
                ((BufferedOutputStream)out).flush();
                ctx.getHandleSetPauseProvider().handlePause(ctx, null);
                if (offset + unique.length() >= dataBuf.length()) break;
                prevOffset = offset += unique.length();
                if (++matches < this.pageNo) continue;
                printRest = true;
                break;
            }
            if (offset == -1 || printRest) {
                this.write(out, dataBuf.substring(prevOffset));
            }
            this.pageNo = 0;
        } else {
            this.write(out, dataBuf.toString());
        }
        return true;
    }

    public static void directWriteOut(ScriptRunnerContext ctx, OutputStreamWriter out) {
        if (ctx != null && ctx.getProperty("script.runner.set_pause") != null && ((Boolean)ctx.getProperty("script.runner.set_pause")).equals(Boolean.TRUE) && ctx.getProperty("script.runner.set_pause_value") != null) {
            try {
                out.flush();
            }
            catch (IOException e) {
                Logger.getLogger("SetPause").log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            ctx.getHandleSetPauseProvider().handlePause(ctx, null);
        }
    }

    private void write(Object out, String s) throws IOException {
        try {
            ((BufferedOutputStream)out).write(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
        }
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String onoff = "";
        String message = null;
        if (ctx.getProperty("script.runner.set_pause") != null) {
            onoff = Boolean.valueOf(ctx.getProperty("script.runner.set_pause").equals(Boolean.TRUE)) != false ? "ON" : "OFF";
        }
        if (ctx.getProperty("script.runner.set_pause_value") != null) {
            message = (String)ctx.getProperty("script.runner.set_pause_value");
        }
        String toreturn = "";
        if (onoff.length() > 0) {
            toreturn = toreturn + StoreRegistry.getCommand("pause", onoff);
        }
        if (message != null && message.length() > 0) {
            toreturn = toreturn + StoreRegistry.getCommand("pause", MessageFormat.format("\"{0}\"", message));
        }
        return toreturn;
    }
}

