/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetFeedBack
extends CommandListener {
    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String feedString = (String)cmd.getProperty("prop_file_string");
        if (feedString != null) {
            if (feedString.equalsIgnoreCase("on")) {
                ctx.setFeedback(-1);
            } else if (feedString.equalsIgnoreCase("off") || feedString.equalsIgnoreCase("0")) {
                ctx.setFeedback(-2);
            } else {
                try {
                    int feedInt = Integer.parseInt((String)cmd.getProperty("prop_file_string"));
                    if (feedInt < 0 || feedInt > 50000) {
                        this.writeToMain(MessageFormat.format(Messages.getString("SetFeedback.invalidRange") + "\n", new Integer(feedInt)), ctx);
                        return false;
                    }
                    ctx.setFeedback(feedInt);
                }
                catch (Exception e) {
                    this.writeToMain(Messages.getString("SetFeedback.invalidValue") + "\n", ctx);
                    return false;
                }
            }
        }
        return true;
    }

    public void writeToMain(String op, ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream existing = ctx.getOutputStream();
        if (existing != null) {
            try {
                existing.write(op.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }
}

