/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.query.Bind;

public class SetAutoPrint
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_AUTOPRINT;

    public SetAutoPrint() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        super.beginEvent(conn, ctx, cmd);
        if (cmd.getStmtSubType() != null && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHOW)) {
            Boolean amIOn = Boolean.FALSE;
            if (this.isCmdOn()) {
                amIOn = Boolean.TRUE;
            }
            ctx.putProperty("script.runner.context.autoprint", amIOn);
        }
    }

    @Override
    public void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        List<String> al = DBUtil.getBindNames(cmd.getSql(), true);
        if (al != null && al.size() > 0) {
            Map<String, Bind> m = ctx.getVarMap();
            for (String key : al) {
                if (!m.containsKey(key = key.toUpperCase())) continue;
                Bind obj = m.get(key);
                String value = "";
                String type = "";
                if (obj instanceof String) {
                    value = (String)((Object)obj);
                } else if (obj instanceof Bind) {
                    value = obj.getValue();
                    type = obj.getType();
                }
                this.printBindValue(ctx, key, value, type);
            }
        }
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.showModeForAutoPrint(ctx, cmd);
    }

    private void printBindValue(ScriptRunnerContext ctx, String key, String value, String type) {
        WrapListenBufferOutputStream out = ctx.getOutputStream();
        key = key.concat("\n");
        try {
            if (value == null) {
                ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(key));
                ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner("------\n"));
            } else {
                if (!type.equals("REFCURSOR")) {
                    ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(key));
                    StringBuffer limit = new StringBuffer();
                    for (int j = 0; j < value.length(); ++j) {
                        limit.append("-");
                    }
                    limit.append("\n");
                    ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(limit.toString()));
                }
                value = value.concat("\n");
                ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(value));
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private boolean showModeForAutoPrint(ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getStmtSubType() != null && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_AUTOPRINT)) {
            StringTokenizer st_tok = new StringTokenizer(cmd.getSql().trim());
            if (cmd.getSql().trim().split(Messages.getString("SetAutoPrint.0")).length == 2) {
                ctx.write(Messages.getString("SetAutoPrint.1"));
                return false;
            }
            if (cmd.getSql().trim().split("\\s+").length == 3 && !cmd.getSql().trim().split("\\s+")[2].equalsIgnoreCase("on") && !cmd.getSql().trim().split("\\s+")[2].equalsIgnoreCase("off")) {
                ctx.write(Messages.getString("SetAutoPrint.7"));
                return false;
            }
            String setp = st_tok.nextToken();
            String autop = st_tok.nextToken();
            if (cmd.getSql().trim().length() > 3 && setp.equalsIgnoreCase("set") && (autop.equalsIgnoreCase("autoprint") || autop.equalsIgnoreCase("autop") || autop.equalsIgnoreCase("autopr") || autop.equalsIgnoreCase("autopri") || autop.equalsIgnoreCase("autoprin"))) {
                String setting = st_tok.nextToken().toLowerCase().trim();
                if (setting.equalsIgnoreCase("on")) {
                    this.setProperties(cmd, ctx, "ON", "autoprint", "script.runner.context.autoprint");
                    this.writeShowMode(cmd, ctx, "ON");
                } else if (setting.equalsIgnoreCase("off")) {
                    this.setProperties(cmd, ctx, "OFF", "autoprint", "script.runner.context.autoprint");
                    this.writeShowMode(cmd, ctx, "OFF");
                } else {
                    ctx.write(Messages.getString("SetAutoPrint.15"));
                }
            }
        }
        return true;
    }
}

