/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.Substitution;
import oracle.dbtools.raptor.scriptrunner.Restricted;

@Restricted(level=Restricted.Level.HIGH)
public class HostAliasCommand
extends CommandListener {
    private static final String CMD = "host";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        int hostReturn;
        block39: {
            String[] stArray;
            hostReturn = 0;
            Substitution sub = new Substitution(ctx);
            try {
                sub.replaceSubstitution(cmd);
            }
            catch (Substitution.SubstitutionException substitutionException) {
                // empty catch block
            }
            String command = cmd.getSql();
            ArrayList<String> cmdTokens = new ArrayList<String>();
            if (command.trim().startsWith("!") || command.trim().startsWith("$")) {
                command = command.replaceFirst("\\$|\\!|host|ho|hos", "");
            }
            StringTokenizer st = new StringTokenizer(command);
            if (command.trim().toLowerCase().startsWith(CMD) || command.trim().toLowerCase().startsWith("hos") || command.trim().toLowerCase().startsWith("ho")) {
                String host = st.nextToken();
                command = command.replaceFirst(host, "");
            }
            String addPath = "";
            if (System.getProperty("os.name").toLowerCase().indexOf("win") <= -1) {
                try {
                    String pwd = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
                    addPath = " export PATH=\"" + pwd + ":$PATH\" && ";
                }
                catch (Exception e) {
                    ctx.write(e.getMessage() + "\n");
                }
            }
            command = command.trim();
            if ((command = ScriptUtils.checkforContinuationChars(command)).trim().equals("")) {
                if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
                    cmdTokens.add("cmd.exe");
                } else {
                    cmdTokens.add("bash");
                    cmdTokens.add("-c");
                    cmdTokens.add("SQLCLTERM=`stty -g 2>/dev/null` && stty sane 2>/dev/null && " + addPath + "bash -l ; SQLCLEXIT=$? && if test \"M$SQLCLTERM\" != \"M\" ; then stty \"$SQLCLTERM\" 2>/dev/null; fi; exit $SQLCLEXIT");
                }
            } else if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
                cmdTokens.add("cmd.exe");
                cmdTokens.add("/C");
                cmdTokens.add(command);
            } else {
                cmdTokens.add("bash");
                cmdTokens.add("-c");
                cmdTokens.add("SQLCLTERM=`stty -g 2>/dev/null` ; stty sane 2>/dev/null; " + addPath + command + "; SQLCLEXIT=$? ; if test \"M$SQLCLTERM\" != \"M\" ; then stty \"$SQLCLTERM\" 2>/dev/null ; fi; exit $SQLCLEXIT");
            }
            ProcessBuilder builder = new ProcessBuilder(cmdTokens);
            builder.directory(new File(FileUtils.getSQLPath(ctx)[0]));
            String changepwd = (String)ctx.getProperty("script.runner.cd_command");
            if (changepwd != null && (stArray = changepwd.split(File.pathSeparator)) != null && stArray.length > 0 && stArray[0] != null && new File(stArray[0]).isDirectory()) {
                changepwd = stArray[0];
                builder.directory(new File(stArray[0]));
            }
            BufferedInputStream bis = null;
            FilterOutputStream bos = null;
            ByteArrayOutputStream bufferStore = null;
            try {
                int x;
                Process process;
                builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
                builder.redirectErrorStream(true);
                if (ctx.getProperty("script.runner.jline") != null) {
                    int x2;
                    builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                    builder.inheritIO();
                    process = builder.start();
                    hostReturn = x2 = process.waitFor();
                    ctx.getMap().put("_RC", String.valueOf(x2));
                    break block39;
                }
                builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
                process = builder.start();
                try {
                    int len;
                    int bufSize = 4096;
                    bis = new BufferedInputStream(process.getInputStream(), bufSize);
                    bufferStore = new ByteArrayOutputStream();
                    bos = new BufferedOutputStream(bufferStore);
                    byte[] buffer = new byte[bufSize];
                    boolean written = false;
                    while ((len = bis.read(buffer, 0, bufSize)) != -1) {
                        ((BufferedOutputStream)bos).write(buffer, 0, len);
                        written = true;
                    }
                    if (written) {
                        ((BufferedOutputStream)bos).flush();
                        ctx.write(bufferStore.toString());
                        ctx.getOutputStream().flush();
                    }
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    if (bufferStore != null) {
                        try {
                            bufferStore.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
                hostReturn = x = process.waitFor();
                ctx.getMap().put("_RC", String.valueOf(x));
            }
            catch (IOException e) {
                ctx.write(e.getMessage() + "\n");
            }
            catch (InterruptedException e) {
                ctx.write(e.getMessage() + "\n");
            }
        }
        ctx.write("\n");
        if (hostReturn != 0) {
            ScriptUtils.doWhenever(ctx, cmd, conn, false);
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isCommandLine()) {
            ctx.getSQLPlusConsoleReader().pauseReader(true);
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isCommandLine()) {
            ctx.getSQLPlusConsoleReader().pauseReader(false);
        }
    }
}

