/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Attribute
extends CommandListener {
    private static final String ATTRIBUTE = "ATTRIBUTE";
    private static final String m_lineSeparator = System.getProperty("line.separator");

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sqlpcmd = cmd.getSql().toLowerCase().trim().replaceAll("\\s+", " ");
        String[] cmds = sqlpcmd.split(" ");
        String attributeKeyword = cmds[0].trim();
        HashMap<String, HashMap<String, HashMap<String, String>>> typeAttributesMap = ctx.getObjectTypeAttributes();
        if (!this.testAttributeKeyword(attributeKeyword)) {
            return false;
        }
        if (cmds.length == 1 && (typeAttributesMap == null || typeAttributesMap.isEmpty())) {
            return false;
        }
        if (cmds.length == 1 && typeAttributesMap != null && !typeAttributesMap.isEmpty()) {
            List<String> typeAttributeKeys = this.getTypeAttributeKeys(typeAttributesMap);
            for (int k = 0; k < typeAttributeKeys.size() - 1; ++k) {
                this.processAttributes(ctx, new String[]{ATTRIBUTE, typeAttributeKeys.get(k)}, typeAttributesMap, true);
            }
            this.processAttributes(ctx, new String[]{ATTRIBUTE, typeAttributeKeys.get(typeAttributeKeys.size() - 1)}, typeAttributesMap, false);
            return true;
        }
        if (cmds.length > 1) {
            return this.processAttributes(ctx, cmds, typeAttributesMap, false);
        }
        return true;
    }

    private List<String> getTypeAttributeKeys(HashMap<String, HashMap<String, HashMap<String, String>>> typeAttributesMap) {
        ArrayList<String> tempList = new ArrayList<String>();
        Set<String> typeKeySet = typeAttributesMap.keySet();
        for (String typeKeyName : typeKeySet) {
            HashMap<String, HashMap<String, String>> attributeMap = typeAttributesMap.get(typeKeyName);
            Set<String> attributeKeySet = attributeMap.keySet();
            for (String attributeName : attributeKeySet) {
                tempList.add(typeKeyName + "." + attributeName);
            }
        }
        return tempList;
    }

    private boolean processAttributes(ScriptRunnerContext ctx, String[] cmds, HashMap<String, HashMap<String, HashMap<String, String>>> typeAttributesMap, boolean appendLineSeparator) {
        HashMap<String, String> attributeValueMap;
        String typeAndAttributeNames = cmds[1].trim().toUpperCase();
        if (!this.validateTypeAttribute(typeAndAttributeNames, ctx)) {
            return false;
        }
        String[] typeAttributes = typeAndAttributeNames.split("\\.");
        if (typeAttributes == null || typeAttributes.length != 2) {
            return false;
        }
        String typeName = typeAttributes[0].trim().toUpperCase();
        if (typeName == null || typeName.length() == 0) {
            return false;
        }
        String attributeName = typeAttributes[1].trim();
        if (attributeName == null || attributeName.length() == 0) {
            return false;
        }
        HashMap<String, HashMap<String, String>> attributeMap = typeAttributesMap.get(typeName);
        if (attributeMap == null) {
            attributeMap = new HashMap();
            typeAttributesMap.put(typeName, attributeMap);
        }
        if ((attributeValueMap = attributeMap.get(attributeName)) == null) {
            attributeValueMap = new HashMap();
            attributeMap.put(attributeName, attributeValueMap);
        }
        if (cmds.length == 2) {
            if (this.checkForDefinedAttributes(ctx, attributeValueMap, typeAndAttributeNames, appendLineSeparator)) {
                return false;
            }
            if (!appendLineSeparator) {
                ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_NOT_DEFINED"), typeAndAttributeNames.toLowerCase()) + m_lineSeparator);
            }
            return false;
        }
        String optionName = cmds[2];
        if (optionName == null || optionName.length() == 0) {
            return false;
        }
        if (!(this.isAlias(optionName) || this.isClear(optionName) || this.isFormat(optionName) || this.isLike(optionName) || this.isOnOff(optionName))) {
            ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_UNKNOWN_OPTION"), optionName) + m_lineSeparator);
            return false;
        }
        if (this.isAlias(optionName)) {
            if (cmds.length == 4) {
                String aliasValue = cmds[3].trim();
                if (aliasValue.length() > 0) {
                    attributeValueMap.put("ALIAS", aliasValue);
                    this.addAlias(ctx, aliasValue, typeName + "." + attributeName);
                    attributeValueMap.put("ON_OFF", "ON");
                    return true;
                }
                return false;
            }
            ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_STRING_VALUE_MISSING"), new Object[0]) + m_lineSeparator);
            return false;
        }
        if (this.isClear(optionName)) {
            attributeValueMap = attributeMap.get(attributeName);
            if (attributeValueMap == null) {
                attributeValueMap = new HashMap();
                attributeMap.put(attributeName, attributeValueMap);
            } else {
                Set<String> keys = attributeValueMap.keySet();
                if (keys.size() > 0) {
                    for (String key : keys) {
                        attributeValueMap.put(key, "");
                    }
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_NOT_DEFINED"), typeAndAttributeNames.toLowerCase()) + m_lineSeparator);
                    return false;
                }
            }
            return true;
        }
        if (this.isFormat(optionName)) {
            if (cmds.length == 4) {
                String formatValue = cmds[3].trim();
                attributeValueMap.put("FORMAT", formatValue);
                attributeValueMap.put("ON_OFF", "ON");
                return true;
            }
            ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_STRING_VALUE_MISSING"), new Object[0]) + m_lineSeparator);
            return false;
        }
        if (this.isLike(optionName)) {
            if (cmds.length == 4) {
                String likeValue = cmds[3].trim();
                attributeValueMap.put("LIKE", likeValue);
                attributeValueMap.put("ON_OFF", "ON");
                return true;
            }
            ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_STRING_VALUE_MISSING"), new Object[0]) + m_lineSeparator);
            return false;
        }
        if (this.isOnOff(optionName)) {
            attributeValueMap.put("ON_OFF", optionName);
            return true;
        }
        return true;
    }

    private boolean checkForDefinedAttributes(ScriptRunnerContext ctx, HashMap<String, String> attributeValueMap, String typeAndAttributeNames, boolean appendLineSeparator) {
        boolean onOffFlag = true;
        boolean aliasFlag = true;
        boolean formatFlag = true;
        boolean likeFlag = true;
        if (attributeValueMap != null) {
            String formatData = attributeValueMap.get("FORMAT");
            String likeData = attributeValueMap.get("LIKE");
            String onOff = attributeValueMap.get("ON_OFF");
            String aliasData = attributeValueMap.get("ALIAS");
            if (onOff != null && onOff.length() > 0) {
                if (onOff.equalsIgnoreCase("ON")) {
                    ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_ON_VALUE"), typeAndAttributeNames.toLowerCase()) + m_lineSeparator);
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_OFF_VALUE"), typeAndAttributeNames.toLowerCase()) + m_lineSeparator);
                }
            } else {
                onOffFlag = false;
            }
            if (aliasData != null && aliasData.length() > 0) {
                ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_ALIAS_VALUE"), aliasData) + m_lineSeparator);
            } else {
                aliasFlag = false;
            }
            if (formatData != null && formatData.length() > 0) {
                ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_FORMAT_VALUE"), formatData) + m_lineSeparator);
            } else {
                formatFlag = false;
            }
            if (likeData != null && likeData.length() > 0) {
                ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_LIKE_VALUE"), likeData) + m_lineSeparator);
            } else {
                likeFlag = false;
            }
            if (appendLineSeparator) {
                ctx.write(m_lineSeparator);
            }
            return onOffFlag || aliasFlag || formatFlag || likeFlag;
        }
        return false;
    }

    private void addAlias(ScriptRunnerContext ctx, String aliasValue, String typeAttributeName) {
        ctx.getAliasTypeAttributesMap().put(aliasValue.toUpperCase(), typeAttributeName.toUpperCase());
    }

    private boolean isOnOff(String keyword) {
        return keyword.equalsIgnoreCase("ON") || keyword.equalsIgnoreCase("OFF");
    }

    private boolean isLike(String keyword) {
        return keyword.equalsIgnoreCase("LIKE");
    }

    private boolean isFormat(String keyword) {
        return keyword.equalsIgnoreCase("FOR") || keyword.equalsIgnoreCase("FORM") || keyword.equalsIgnoreCase("FORMA") || keyword.equalsIgnoreCase("FORMAT");
    }

    private boolean isClear(String keyword) {
        return keyword.equalsIgnoreCase("CLE") || keyword.equalsIgnoreCase("CLEA") || keyword.equalsIgnoreCase("CLEAR");
    }

    private boolean isAlias(String keyword) {
        return keyword.equalsIgnoreCase("ALI") || keyword.equalsIgnoreCase("ALIA") || keyword.equalsIgnoreCase("ALIAS");
    }

    private boolean testAttributeKeyword(String keyword) {
        return keyword.equalsIgnoreCase("ATTR") || keyword.equalsIgnoreCase("ATTRI") || keyword.equalsIgnoreCase("ATTRIB") || keyword.equalsIgnoreCase("ATTRIBU") || keyword.equalsIgnoreCase("ATTRIBUT") || keyword.equalsIgnoreCase(ATTRIBUTE);
    }

    private boolean validateTypeAttribute(String typeAndAttributeNames, ScriptRunnerContext ctx) {
        if (typeAndAttributeNames == null) {
            return false;
        }
        if (!typeAndAttributeNames.contains(".")) {
            ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_NOT_DEFINED"), typeAndAttributeNames.toLowerCase()) + m_lineSeparator);
            return false;
        }
        return true;
    }
}

