/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSqlcode;
import oracle.dbtools.util.Service;
import oracle.jdbc.OracleResultSet;
import oracle.sql.Datum;

public class ScriptUtils {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    protected static final Logger LOGGER = Logger.getLogger(ScriptUtils.class.getName());
    public static final int EXIT = 4;
    public static final int CONTINUE = 0;
    public static final int EXITMASK = 4;
    public static final int ACTIONMASK = 3;
    public static final int ACTIONNONE = 0;
    public static final int ACTIONCOMMIT = 1;
    public static final int ACTIONROLLBACK = 2;
    public static final String EXECUTEFAILED = "EXECUTEFAILED";

    public static String[] executeArgs(String a) throws ArgumentQuoteException {
        Matcher m;
        boolean retFind;
        if (a == null) {
            return null;
        }
        if (a.replaceAll("^\\s+$", "").equals("")) {
            return null;
        }
        ArrayList<String> theArguments = new ArrayList<String>();
        a = " " + a;
        Pattern nextBlankP = Pattern.compile("\\s");
        while (retFind = (m = nextBlankP.matcher(a)).find()) {
            int nextq;
            if ((a = a.substring(m.start()).trim()).startsWith("'")) {
                nextq = 1;
                while ((nextq = a.indexOf("'", nextq)) != -1 && a.substring(nextq).startsWith("''")) {
                    nextq += 2;
                }
                if (nextq == -1) {
                    throw new ArgumentQuoteException("'");
                }
                theArguments.add(a.substring(1, nextq).replaceAll("''", "'"));
                if (a.length() <= nextq + 1) break;
                a = " " + a.substring(nextq + 1);
                continue;
            }
            if (a.startsWith("\"")) {
                nextq = 1;
                while ((nextq = a.indexOf("\"", nextq)) != -1 && a.substring(nextq).startsWith("\"\"")) {
                    nextq += 2;
                }
                if (nextq == -1) {
                    throw new ArgumentQuoteException("\"");
                }
                theArguments.add(a.substring(1, nextq).replaceAll("\"\"", "\""));
                if (a.length() <= nextq + 1) break;
                a = " " + a.substring(nextq + 1);
                continue;
            }
            m = nextBlankP.matcher(a);
            retFind = m.find();
            if (!retFind) {
                if (a.equals("")) break;
                theArguments.add(a);
                break;
            }
            int nexts = m.start();
            theArguments.add(a.substring(0, nexts));
            a = a.substring(nexts);
        }
        if (theArguments.size() == 0) {
            return null;
        }
        return theArguments.toArray(new String[theArguments.size()]);
    }

    protected static void report(ScriptRunnerContext ctx, String s, BufferedOutputStream out) {
        if (out != null) {
            try {
                Integer lnoval;
                String modstr = s + "\n";
                if (ctx != null && ctx.getFeedback() != -2) {
                    out.write(modstr.getBytes("UTF-8"));
                }
                if (ctx != null && (lnoval = (Integer)ctx.getProperty("script.runner.lno")) > 0) {
                    int nlt = 0;
                    StringTokenizer st = new StringTokenizer(modstr, "\n", true);
                    while (st.hasMoreTokens()) {
                        if (!st.nextToken().equals("\n")) continue;
                        ++nlt;
                    }
                    int lno = lnoval + nlt;
                    ctx.putProperty("script.runner.lno", new Integer(lno));
                }
                out.flush();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public static void doWhenever(ScriptRunnerContext src, ISQLCommand cmd, Connection conn, boolean SqlError) {
        cmd.setProperty(EXECUTEFAILED, EXECUTEFAILED);
        WrapListenBufferOutputStream out = src.getOutputStream();
        int flags = 0;
        flags = SqlError ? src.getSqlError() : src.getOsError();
        int threeOptions = flags & 3;
        if (threeOptions == 2) {
            if (conn != null) {
                try {
                    conn.rollback();
                    if (!src.isSQLPlusClassic()) {
                        ScriptUtils.report(src, "Rollback", out);
                    }
                }
                catch (SQLException e) {
                    ScriptUtils.report(src, ScriptRunnerDbArb.format("ERROR_ON", "Rollback"), out);
                }
            }
        } else if (threeOptions == 1 && conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                ScriptUtils.report(src, ScriptRunnerDbArb.format("ERROR_ON", "Commit"), out);
            }
        }
        if ((flags & 4) == 4) {
            src.setExited(true);
            if (src.getProperty("script.runner.exit_int_whenever") != null) {
                if ((Integer)src.getProperty("script.runner.exit_int_whenever") != -1) {
                    Boolean wasSQLCODE = (Boolean)src.getProperty("script.runner.exit_int_whenever.wassqlcode");
                    if (wasSQLCODE != null && wasSQLCODE.equals(Boolean.TRUE)) {
                        int parsedNum = ShowSqlcode.getCodeNum(src);
                        src.putProperty("script.runner.exit_int", parsedNum);
                    } else {
                        src.putProperty("script.runner.exit_int", src.getProperty("script.runner.exit_int_whenever"));
                    }
                } else {
                    src.putProperty("script.runner.exit_int", 1);
                    ScriptUtils.report(src, ScriptRunnerDbArb.get("EXIT_JUNK2"), out);
                }
            } else {
                src.putProperty("script.runner.exit_int", 1);
            }
        }
    }

    public static String[] parseNameAndTypeUtil(String sql) {
        String owner = null;
        boolean wasAlter = false;
        boolean foundBody = false;
        String name = null;
        String type = null;
        String txt = sql.length() > 1000 ? sql.substring(0, 1000) : sql;
        List<LexerToken> src = LexerToken.parse(txt);
        if (src.size() > 1 && "alter".equalsIgnoreCase(src.get((int)0).content)) {
            wasAlter = true;
            boolean foundCompile = false;
            for (int i = 0; i < 20 && i + 1 <= src.size(); ++i) {
                String thisToken = src.get((int)i).content;
                if ("compile".equalsIgnoreCase(thisToken)) {
                    foundCompile = true;
                }
                if ("resolve".equalsIgnoreCase(thisToken)) {
                    foundCompile = true;
                }
                if (!"body".equalsIgnoreCase(thisToken)) continue;
                foundBody = true;
            }
            if (!foundCompile) {
                return null;
            }
        }
        for (int i = 0; i < 15 && i < src.size(); ++i) {
            LexerToken t = src.get(i);
            if (type == null && "DECLARE".equalsIgnoreCase(t.content) || type == null && "BEGIN".equalsIgnoreCase(t.content)) break;
            if (type == null && "PACKAGE".equalsIgnoreCase(t.content)) {
                type = t.content.toUpperCase();
                continue;
            }
            if (type == null && "PROCEDURE".equalsIgnoreCase(t.content)) {
                type = t.content.toUpperCase();
                continue;
            }
            if (type == null && "FUNCTION".equalsIgnoreCase(t.content)) {
                type = t.content.toUpperCase();
                continue;
            }
            if (type == null && "TRIGGER".equalsIgnoreCase(t.content)) {
                type = t.content.toUpperCase();
                continue;
            }
            if (type == null && "JAVA".equalsIgnoreCase(t.content)) {
                type = t.content.toUpperCase();
                continue;
            }
            if (type == null && "LIBRARY".equalsIgnoreCase(t.content)) {
                type = t.content.toUpperCase();
                continue;
            }
            if (type == null && "TYPE".equalsIgnoreCase(t.content)) {
                type = t.content.toUpperCase();
                continue;
            }
            if (type != null && "BODY".equalsIgnoreCase(t.content)) {
                type = type + " " + t.content.toUpperCase();
                foundBody = false;
                continue;
            }
            if (type != null && "SOURCE".equalsIgnoreCase(t.content)) {
                type = type + " " + t.content.toUpperCase();
                continue;
            }
            if ((type == null || !wasAlter && type.startsWith("JAVA") || "BODY".equalsIgnoreCase(t.content) || name != null) && (type == null || wasAlter || !type.startsWith("JAVA") || i <= 1 || src.get(i - 1) == null || src.get((int)(i - 1)).content == null || !src.get((int)(i - 1)).content.equalsIgnoreCase("NAMED") || name != null)) continue;
            if (type.equals("PACKAGE") && foundBody) {
                type = "PACKAGE BODY";
            }
            if (type.equals("TYPE") && foundBody) {
                type = "TYPE BODY";
            }
            if ((name = Service.handleMixedCase(t.content)).equals("[")) {
                String localtxt = txt + " ";
                boolean inbracket = true;
                int possibleStartName = t.begin + 1;
                int end = localtxt.length() - 1;
                for (int token = t.begin + 1; token < 1000 && token < localtxt.length() - 1; ++token) {
                    String tlocal = localtxt.substring(token, token + 1);
                    if (tlocal.matches("[ \t\r\n]") && !inbracket) {
                        end = token;
                        break;
                    }
                    if (tlocal.equals(".") && !inbracket) {
                        possibleStartName = token + 1;
                    }
                    if (tlocal.equals("[")) {
                        inbracket = true;
                        continue;
                    }
                    if (!tlocal.equals("]")) continue;
                    inbracket = false;
                }
                if (end - possibleStartName >= 100 || end - possibleStartName <= 0) break;
                name = localtxt.substring(possibleStartName, end).replaceAll("\\[", "").replaceAll("\\]", "");
                break;
            }
            if (src.size() <= i + 2) break;
            LexerToken possibleDOTToken = src.get(i + 1);
            if (!".".equalsIgnoreCase(possibleDOTToken.content)) break;
            owner = name;
            LexerToken objectNameToken = src.get(i + 2);
            if (!owner.startsWith("\"") || !owner.endsWith("\"")) {
                owner = owner.toUpperCase(Locale.US);
            }
            if ((name = objectNameToken.content).startsWith("\"") && name.endsWith("\"")) break;
            name = name.toUpperCase(Locale.US);
            break;
        }
        if (name != null && name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        return new String[]{owner, name, type};
    }

    public static String eatOneWord(String in) {
        return (in.trim() + " ").replaceAll("^[^\\s]*\\s+", "").trim();
    }

    public static String stripFirstN(String in, int n, boolean continuation, boolean sqlplus) {
        return ScriptUtils.stripFirstN(in, n, continuation, false, sqlplus);
    }

    public static String stripFirstN(String in, int n, boolean continuation, boolean nullOnUnmatched, boolean sqlplus) {
        boolean showUsage = false;
        String removeComments = in;
        if (in.length() > n) {
            removeComments = in.substring(0, n);
        }
        if (continuation) {
            removeComments = sqlplus ? SQLPLUS.removeDashNewline(removeComments) : ScriptUtils.checkforContinuationChars(removeComments);
        }
        int next = 0;
        int nextDash = 0;
        int nextMulti = 0;
        while (next != -1) {
            String before;
            nextMulti = removeComments.indexOf("/*", next);
            nextDash = removeComments.indexOf("--", next);
            int nextQQuote = 999999;
            int nextQuote = removeComments.indexOf("'", next);
            int nextDQuote = removeComments.indexOf("\"", next);
            if (nextMulti == -1 && nextDash == -1) break;
            int least = 99999;
            if (nextMulti != -1) {
                least = nextMulti;
            }
            if (nextDash != -1 && nextDash < least) {
                least = nextDash;
            }
            if (nextQQuote != -1 && nextQQuote < least) {
                least = nextQQuote;
            }
            if (nextQuote != -1 && nextQuote < least) {
                least = nextQuote;
            }
            if (nextDQuote != -1 && nextDQuote < least) {
                least = nextDQuote;
            }
            if (nextMulti != -1 && nextMulti == least) {
                before = removeComments;
                if ((removeComments = removeComments.replaceFirst("(?s)/\\*.*?\\*/", " ")).equals(before) || removeComments.indexOf("/*", next) == nextMulti) {
                    if (!nullOnUnmatched) break;
                    return null;
                }
                next = nextMulti;
            }
            if (nextDash != -1 && nextDash == least) {
                before = removeComments;
                if ((removeComments = removeComments.replaceFirst("(?s)--[^\n]*", " ")).equals(before) || removeComments.indexOf("--", next) == nextDash) {
                    if (!nullOnUnmatched) break;
                    return null;
                }
                next = nextDash;
            }
            if (least != nextQQuote && least != nextDQuote && least != nextQuote) continue;
            break;
        }
        return removeComments.trim();
    }

    public static String checkforContinuationChars(String currstmt) {
        boolean firstLine = true;
        if (currstmt.contains("-")) {
            String[] lines = currstmt.split("\n");
            StringBuffer newStatement = new StringBuffer("");
            String newStatementSt = null;
            if (lines.length != 0) {
                int lineNo = 0;
                for (String line : lines) {
                    ++lineNo;
                    String token = line;
                    StringBuffer newToken = new StringBuffer("");
                    if (firstLine && token.indexOf("-") != -1 && token.replaceAll("\\s+$", "").endsWith("-") && !token.replaceAll("^\\s+", "").startsWith("--")) {
                        StringCharacterIterator it = new StringCharacterIterator(token);
                        boolean found = false;
                        char ch = it.last();
                        while (ch != '\uffff') {
                            if (ch == '-' && !found) {
                                newToken.insert(0, ' ');
                                found = true;
                            } else {
                                newToken.insert(0, ch);
                            }
                            ch = it.previous();
                        }
                        newStatement.append(newToken);
                        continue;
                    }
                    if (lineNo == 1) {
                        return currstmt;
                    }
                    firstLine = false;
                    newToken = new StringBuffer(token);
                    newStatement.append(newToken).append(" \n");
                }
                newStatementSt = newStatement.toString();
            } else {
                newStatementSt = currstmt;
            }
            if (newStatementSt.length() > 2) {
                if (newStatementSt.endsWith("\r\n")) {
                    newStatementSt = newStatementSt.substring(0, newStatementSt.lastIndexOf(13));
                } else if (newStatementSt.endsWith("\n")) {
                    newStatementSt = newStatementSt.substring(0, newStatementSt.lastIndexOf(10));
                }
            }
            return newStatementSt;
        }
        return currstmt;
    }

    public static boolean newConnectionDetailsError(ConnectionDetails inDetails) {
        if (inDetails == null) {
            return true;
        }
        if (inDetails.getAt() != -1 && (inDetails.getConnectDB() == null || inDetails.getConnectDB().trim().equals(""))) {
            return true;
        }
        Boolean[] boolArr = new Boolean[]{new Boolean(true), new Boolean(inDetails.getSlash() != -1)};
        String[] argArr = new String[]{inDetails.getConnectName(), inDetails.getConnectPassword()};
        for (int count = 0; count < 2; ++count) {
            if (!boolArr[count].equals(new Boolean(true)) || argArr[count] == null || !argArr[count].trim().contains(" ") || argArr[count].length() > 1 && argArr[count].startsWith("\"") && argArr[count].endsWith("\"")) continue;
            return true;
        }
        return inDetails.getRoleBad();
    }

    public static boolean isHttpCon(Connection conn, ScriptRunnerContext ctx) {
        Boolean ctxHttpCon = (Boolean)ctx.getProperty("sqlcl.connection.httpcon");
        return ctxHttpCon != null && ctxHttpCon.equals(Boolean.TRUE);
    }

    public static void setHttpCon(Connection conn, ScriptRunnerContext ctx, boolean current) {
        if (ctx != null) {
            ctx.putProperty("sqlcl.connection.httpcon", current);
        }
    }

    public static ConnectionDetails getConnectionDetails(String localSql) {
        Object cd = null;
        String fullString = null;
        boolean found = false;
        boolean callDialog = false;
        String connectName = "";
        String connectPassword = "";
        String connectDB = "";
        String role = "";
        String edition = "";
        boolean roleBad = false;
        int i = 0;
        int slash = -1;
        int at = -1;
        for (i = 0; i < localSql.length(); ++i) {
            if (!Character.isWhitespace(localSql.charAt(i))) continue;
            found = true;
            break;
        }
        if (localSql.toLowerCase().lastIndexOf("edition") != -1) {
            try {
                if (localSql.lastIndexOf(61) != -1) {
                    edition = localSql.substring(localSql.lastIndexOf(61) + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (found) {
            fullString = localSql = localSql.substring(i).trim();
            String remainder = "";
            if (localSql != null && !localSql.equals("")) {
                String[] both = ScriptUtils.separateRole(localSql);
                localSql = both[0];
                role = both[1];
                boolean bl = roleBad = both[2] != null && both[2].equals(Boolean.TRUE.toString());
            }
            if (localSql.startsWith("[") && localSql.contains("]jdbc:") || localSql.startsWith("jdbc:")) {
                oracle.dbtools.db.ConnectionDetails cd3 = null;
                try {
                    cd3 = new oracle.dbtools.db.ConnectionDetails(localSql);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
                if (cd3 != null && cd3.getDriver() != null) {
                    return new ConnectionDetails(fullString, callDialog, null, null, localSql, role, roleBad, 1, 1, null);
                }
            }
            localSql = localSql.trim();
            int doubleQuote = 0;
            block10: for (int atChar = 0; atChar < localSql.length() && at == -1; ++atChar) {
                switch (localSql.charAt(atChar)) {
                    case '\"': {
                        ++doubleQuote;
                        continue block10;
                    }
                    case '@': {
                        if (doubleQuote % 2 != 0) continue block10;
                        at = atChar;
                        continue block10;
                    }
                    case '/': {
                        if (doubleQuote % 2 != 0) continue block10;
                        slash = atChar;
                        continue block10;
                    }
                }
            }
            if (slash != -1 && (at == -1 || at > slash)) {
                connectName = localSql.substring(0, slash);
                remainder = localSql.substring(slash + 1);
                if (connectName.equals("")) {
                    callDialog = true;
                }
                if (at != -1) {
                    connectPassword = localSql.substring(slash + 1, at);
                    connectDB = localSql.substring(at + 1).trim().replace("\"", "");
                } else if (remainder.toLowerCase().indexOf("edition") != -1) {
                    connectPassword = remainder.substring(0, remainder.toLowerCase().indexOf("edition"));
                    if (remainder.lastIndexOf(61) != -1) {
                        remainder = remainder.substring(remainder.lastIndexOf(61));
                    }
                } else {
                    connectPassword = remainder.trim();
                }
                if (remainder.toLowerCase().indexOf("edition") != -1 && remainder.toLowerCase().indexOf("=") != -1) {
                    edition = remainder.substring(remainder.toLowerCase().lastIndexOf(61));
                }
                if (connectName.trim().equals("") && connectPassword.trim().equals("")) {
                    callDialog = false;
                }
            } else {
                callDialog = true;
                if (at != -1) {
                    connectName = localSql.substring(0, at);
                    connectDB = localSql.substring(at + 1).trim().replace("\"", "");
                } else {
                    connectName = localSql.trim();
                }
            }
        } else {
            callDialog = true;
        }
        ConnectionDetails cdNew = new ConnectionDetails(fullString, callDialog, connectName, connectPassword, connectDB, role, roleBad, at, slash, null, edition);
        if (cdNew != null) {
            cdNew.setCallUsage(ScriptUtils.newConnectionDetailsError(cdNew));
        }
        return cdNew;
    }

    private static String[] nextToChar(String in, char sep) {
        String theRest;
        String retVal;
        int position = in.indexOf(sep);
        if (position == -1) {
            retVal = in;
            theRest = "";
        } else {
            theRest = position == in.length() - 1 ? "" : in.substring(position + 1);
            retVal = in.substring(0, position);
        }
        String[] stringArray = new String[]{retVal, theRest};
        return stringArray;
    }

    private static String getArgument(String arg, String[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equals(arg) || i >= parts.length - 1) continue;
            return parts[i + 1];
        }
        return "";
    }

    private static String[] separateRole(String both) {
        Boolean roleBad = Boolean.FALSE;
        String role = "";
        String connectDB = both;
        if (connectDB != null && connectDB.length() > 0) {
            String connectDBlower = connectDB.toLowerCase().replace("\"", " ");
            String[] connectDbArray = connectDBlower.split("\\s+");
            if (connectDbArray != null && connectDbArray.length > 1) {
                for (String check : new String[]{"sysoper", "sysdba", "sysbackup", "sysdg", "syskm", "sysasm"}) {
                    if (!connectDbArray[connectDbArray.length - 1].equals(check) || !connectDbArray[connectDbArray.length - 2].equals("as")) continue;
                    role = "as " + check;
                    break;
                }
            }
            if (role.trim().equals("") && connectDbArray[connectDbArray.length - 1].toLowerCase().equals("as")) {
                roleBad = Boolean.TRUE;
            }
            if (!role.equals("")) {
                String theTrim;
                String truncate = connectDB.trim();
                truncate = connectDB.substring(0, connectDB.length() - 5);
                String stub = connectDB.substring(connectDBlower.substring(0, connectDBlower.lastIndexOf(role.substring(role.indexOf(" ")))).lastIndexOf("as"));
                int qCount = 0;
                for (int count = 0; count < stub.length(); ++count) {
                    if (stub.charAt(count) != '\"') continue;
                    ++qCount;
                }
                int findAs = truncate.toLowerCase().lastIndexOf("as");
                connectDB = truncate.substring(0, findAs).trim();
                if (qCount % 2 != 0 && (theTrim = connectDB.trim()).endsWith("\"")) {
                    connectDB = theTrim.substring(0, theTrim.length() - 1);
                }
            }
        }
        return new String[]{connectDB, role, roleBad.toString()};
    }

    public static String replaceEnvVars(String string) {
        String text = string;
        String os = System.getProperty("os.name");
        String pattern = "\\$([A-Za-z0-9_\\-]+)";
        if (os.startsWith("Windows")) {
            pattern = "\\%([A-Za-z0-9_\\-]+)\\%";
        }
        Pattern expr = Pattern.compile(pattern, 32);
        Matcher matcher = expr.matcher(text);
        while (matcher.find()) {
            String envValue = System.getenv().get(matcher.group(1).toUpperCase());
            envValue = envValue == null ? "" : envValue.replace("\\", "\\\\");
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            text = subexpr.matcher(text).replaceAll(envValue);
        }
        return text;
    }

    public static char[] bytesToHex(byte[] b) {
        int length = b.length;
        char[] hex = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int val = b[i] & 0xFF;
            hex[2 * i] = Character.forDigit(val / 16, 16);
            hex[2 * i + 1] = Character.forDigit(val - val / 16 * 16, 16);
        }
        return hex;
    }

    public static String expandVariables(String filename) {
        String[] keySet;
        if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1) {
            String[] keySet2;
            if (filename.indexOf("%") == -1) {
                return filename;
            }
            for (String key : keySet2 = System.getenv().keySet().toArray(new String[System.getenv().keySet().size()])) {
                filename = filename.replaceAll("(?i)" + Pattern.quote("%" + key + "%"), Matcher.quoteReplacement(System.getenv(key)));
            }
            return filename;
        }
        if (filename.indexOf("$") == -1) {
            return filename;
        }
        for (String key : keySet = System.getenv().keySet().toArray(new String[System.getenv().keySet().size()])) {
            filename = filename.replaceAll("\\$\\{" + Pattern.quote(key) + "\\}", Matcher.quoteReplacement(System.getenv(key)));
            filename = filename.replaceAll("\\$" + Pattern.quote(key) + "$", Matcher.quoteReplacement(System.getenv(key)));
            filename = filename.replaceAll("\\$" + Pattern.quote(key) + "([^\\p{Alnum}_])", Matcher.quoteReplacement(System.getenv(key)) + "$1");
        }
        return filename;
    }

    public static String getErrorStringAtLine(ISQLCommand cmd, SQLException se) {
        String command = cmd.getSQLOrig();
        String[] lines = command.split("\n");
        int line = ScriptUtils.getErrorLineFromException(cmd, se);
        return lines[line - 1];
    }

    public static int getErrorLineFromException(ISQLCommand cmd, SQLException se) {
        int offset = 1;
        int newoffset = ScriptUtils.getOffSetFromOjdbc8(se);
        if (newoffset > 1) {
            offset = newoffset;
        }
        String[] lines = cmd.getSQLOrigWithTerminator().split("\n");
        int total = 0;
        for (int i = 0; i < lines.length; ++i) {
            int linelength = lines[i].length();
            if (total + linelength >= offset) {
                int chars = offset - total;
                return i + 1;
            }
            total += lines[i].length();
            if (i + 1 >= lines.length) continue;
            ++total;
        }
        return 1;
    }

    public static int getOffSetFromOjdbc8(Exception se) {
        int offset = 1;
        try {
            Method methodToFind;
            Class<?> ode = Class.forName("oracle.jdbc.OracleDatabaseException", false, ScriptUtils.class.getClassLoader());
            Throwable exceptionClass = se.getCause();
            if (exceptionClass != null && exceptionClass.getClass().isAssignableFrom(ode) && (methodToFind = ode.getMethod("getErrorPosition", null)) != null) {
                offset = (Integer)methodToFind.invoke((Object)se.getCause(), (Object[])null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return offset;
    }

    public static Object getErrorAsterixFromException(ISQLCommand cmd, SQLException se) {
        String sqlOrig = cmd.getSQLOrig();
        int offset = 1;
        int newoffset = ScriptUtils.getOffSetFromOjdbc8(se);
        if (newoffset > 1) {
            offset = newoffset;
        }
        String[] lines = sqlOrig.split("\n");
        int total = 0;
        for (int i = 0; i < lines.length; ++i) {
            int linelength = lines[i].length();
            if (total + linelength >= offset) {
                int chars = offset - total;
                if (chars == 0) {
                    return "*";
                }
                return String.format("%1$" + chars + "s", " ") + "*";
            }
            total += lines[i].length();
            if (i + 1 >= lines.length) continue;
            ++total;
        }
        return "*";
    }

    public static StringBuffer wordwrapNotXml(int dataType, int colsize, StringBuffer val) {
        StringBuffer buf = val;
        int q = 0;
        int space = -1;
        int line = 0;
        if (dataType != 2009) {
            while (buf != null && q < buf.length() && buf.charAt(q) == ' ') {
                buf.delete(q, q + 1);
            }
        }
        if ((dataType == 2004 || dataType == -13) && colsize < val.length()) {
            return ScriptUtils.wrap(dataType, colsize, val);
        }
        if (colsize < val.length()) {
            while (q < buf.length()) {
                if (q > 1 && buf.charAt(q) == ' ' && q - 1 < buf.length() && buf.charAt(q - 1) != ' ') {
                    space = -1;
                }
                if (buf.charAt(q) == ' ' && q + 1 < buf.length() && buf.charAt(q + 1) != ' ') {
                    space = q;
                }
                if (buf.charAt(q) == '\n' || buf.charAt(q) == '\r') {
                    space = -1;
                    line = q + 1;
                }
                if (q > line + colsize - 1) {
                    if (space != -1) {
                        buf.delete(space, space + 1);
                        buf.insert(space, m_lineSeparator.toCharArray());
                        line = space + 1;
                        space = -1;
                    } else {
                        buf.insert(q, m_lineSeparator.toCharArray());
                        q += m_lineSeparator.length();
                        while (buf != null && q < buf.length() && buf.charAt(q) == ' ') {
                            buf.delete(q, q + 1);
                        }
                        line = --q + 1;
                    }
                }
                ++q;
            }
        }
        return buf;
    }

    public static StringBuffer wordwrap(int dataType, int colsize, StringBuffer val, int longIn) {
        StringBuffer buf = val;
        int q = 0;
        int space = -1;
        int line = 0;
        if (dataType != 2009) {
            while (buf != null && q < buf.length() && buf.charAt(q) == ' ') {
                buf.delete(q, q + 1);
            }
        }
        if ((dataType == 2004 || dataType == -13) && colsize < val.length()) {
            return ScriptUtils.wrap(dataType, colsize, val);
        }
        if (dataType == 2009 && colsize < val.length()) {
            return ScriptUtils.xmlWordWrap(colsize, val, longIn);
        }
        if (colsize < val.length()) {
            while (q < buf.length()) {
                if (q > 1 && buf.charAt(q) == ' ' && q - 1 < buf.length() && buf.charAt(q - 1) != ' ') {
                    space = -1;
                }
                if (buf.charAt(q) == ' ' && q + 1 < buf.length() && buf.charAt(q + 1) != ' ') {
                    space = q;
                }
                if (buf.charAt(q) == '\n' || buf.charAt(q) == '\r') {
                    space = -1;
                    line = q + 1;
                }
                if (q > line + colsize - 1) {
                    if (space != -1) {
                        buf.delete(space, space + 1);
                        buf.insert(space, m_lineSeparator.toCharArray());
                        line = space + 1;
                        space = -1;
                    } else {
                        buf.insert(q, m_lineSeparator.toCharArray());
                        q += m_lineSeparator.length();
                        while (q < buf.length() && buf.charAt(q) == ' ') {
                            buf.delete(q, q + 1);
                        }
                        line = --q + 1;
                    }
                }
                ++q;
            }
        }
        return buf;
    }

    public static StringBuffer truncate(int dataType, int colsize, StringBuffer val) {
        StringBuffer buf = new StringBuffer("");
        if (colsize < val.length()) {
            String colval = val.toString();
            int count = val.toString().replaceAll(m_lineSeparator, "").length();
            if (count <= colsize) {
                buf.append(colval);
            } else {
                buf.append(colval.substring(0, colsize));
            }
            return buf;
        }
        buf = val;
        return buf;
    }

    public static StringBuffer wrap(int dataType, int colsize, StringBuffer val) {
        StringBuffer buf = new StringBuffer("");
        int q = 0;
        int line = 0;
        String remainStr = "";
        StringBuffer tval = new StringBuffer("");
        if (val.indexOf(m_lineSeparator) == -1) {
            tval.append(val.toString().replaceAll("\\n", m_lineSeparator));
        } else {
            tval.append(val.toString());
        }
        int lterms = tval.toString().split(m_lineSeparator).length;
        while (q < tval.length()) {
            if (q > line + colsize - 1) {
                buf.append(tval.substring(line, line + colsize));
                if (lterms >= 1 && dataType != -10) {
                    buf.append(m_lineSeparator);
                }
                line = q;
                remainStr = "";
                remainStr = remainStr + tval.charAt(q);
            } else {
                if (tval.length() > 1 && tval.charAt(q) == '\r' && tval.charAt(q + 1) == '\n') {
                    buf.append(tval.substring(line, q));
                    buf.append(tval.charAt(q));
                    buf.append(tval.charAt(++q));
                    line = ++q;
                    remainStr = "";
                } else if (tval.charAt(q) == '\n') {
                    buf.append(tval.substring(line, q));
                    buf.append(tval.charAt(q));
                    line = ++q;
                    remainStr = "";
                }
                if (q < tval.length()) {
                    remainStr = remainStr + tval.charAt(q);
                }
            }
            ++q;
        }
        if (remainStr.length() > 0) {
            buf.append(remainStr);
        }
        if (buf.length() == 0) {
            buf = val;
            return buf;
        }
        return buf;
    }

    public static StringBuffer xmlWordWrap(int colsize, StringBuffer val, int longIn) {
        StringBuffer wrappedXML = null;
        String xml = ScriptUtils.wordwrap(12, colsize, val, longIn).toString();
        try {
            if (xml == null || xml.trim().length() == 0) {
                return val;
            }
            StringBuilder sb = new StringBuilder();
            String[] rows = xml.trim().split(m_lineSeparator);
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] == null || rows[i].trim().length() == 0) continue;
                String row = rows[i].replaceAll("^\\s+", "");
                sb.append(row + m_lineSeparator);
            }
            wrappedXML = longIn < sb.length() ? new StringBuffer(sb.toString().substring(0, longIn)) : new StringBuffer(sb.toString());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return wrappedXML;
    }

    public static Datum getOracleObjectWrap(OracleResultSet rset, int i) throws SQLException {
        try {
            return rset.getOracleObject(i);
        }
        catch (Throwable e) {
            if (!(e instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw (SQLException)e;
        }
    }

    public static Datum getOracleObjectWrap(OracleResultSet rset, String name) throws SQLException {
        try {
            return rset.getOracleObject(name);
        }
        catch (Throwable e) {
            if (!(e instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw (SQLException)e;
        }
    }
}

