/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.app.Literals2Binds;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.PLSQL;
import oracle.dbtools.raptor.newscriptrunner.SQL;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptStatusDisplay;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.Substitution;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.SetEcho;
import oracle.dbtools.raptor.query.Bind;
import oracle.jdbc.OracleConnection;

public class ScriptRunner {
    private static final Logger LOGGER = Logger.getLogger(ScriptRunner.class.getName());
    private final String ENCODING = "UTF-8";
    private Connection m_conn;
    private ScriptRunnerContext m_scriptRunnerContext = null;
    private BufferedOutputStream m_out = null;
    private boolean m_printComments = false;
    private ScriptStatusDisplay m_status;
    private String m_directory = null;
    public static final String FORCE_PRINT = "force_print";
    public static final byte[] FORCE_PRINT_BYTES = ScriptRunnerContext.stringToByteArrayForScriptRunner(" force_print\n");
    SQLCommandRunner m_commandRunner = null;

    public static String[] nextToChar(String in, char sep) {
        int position = in.indexOf(sep);
        if (position == -1) {
            ScriptRunner.usage();
        }
        String theRest = position == in.length() - 1 ? "" : in.substring(position + 1);
        String[] stringArray = new String[]{in.substring(0, position), theRest};
        return stringArray;
    }

    public static void usage() {
        LOGGER.info("Usage: java ooracle.dbtools.raptor.scriptrunner.ScriptRunner username/password@host:port:sid @file1 @file2 @file3 ...");
        System.exit(1);
    }

    public ScriptRunner(Connection conn, BufferedOutputStream out, ScriptRunnerContext context) {
        this.setConn(conn);
        this.m_out = out;
        this.m_scriptRunnerContext = context;
    }

    public Connection getConn() {
        return this.m_conn;
    }

    public BufferedOutputStream getOut() {
        return this.m_out;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.m_scriptRunnerContext;
    }

    public ScriptStatusDisplay getStatusDisplay() {
        return this.m_status;
    }

    public String getStatusLine() {
        return this.m_status != null ? this.m_status.getText() : null;
    }

    public boolean isPrintComments() {
        return this.m_printComments;
    }

    protected void report(String s) {
        if (this.m_out != null) {
            try {
                this.m_out.write(s.getBytes("UTF-8"));
                this.m_out.write(10);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(ISQLCommand cmd) throws IOException {
        ScriptRunnerContext context = this.getScriptRunnerContext();
        boolean isOracleConnection = this.getConn() != null && this.getConn() instanceof OracleConnection;
        boolean isTimesTenConnection = false;
        try {
            isTimesTenConnection = this.getConn() != null && this.getConn().getMetaData().getDatabaseProductName().indexOf("TimesTen") != -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean isHttp = this.getConn() != null && this.getScriptRunnerContext() != null && ScriptUtils.isHttpCon(this.getConn(), this.getScriptRunnerContext());
        cmd.setExecutable(true);
        if (!(this.getConn() == null || isOracleConnection || isTimesTenConnection || isHttp || cmd.getStmtType() != SQLCommand.StmtType.G_C_SQLPLUS || SQLCommand.isNonOracleExecutable(cmd))) {
            cmd.setStmtClass(SQLCommand.StmtType.G_C_SQL);
            cmd.setStmtId(SQLCommand.StmtSubType.G_S_CREATE_UNKNOWN);
            cmd.setResultsType(SQLCommand.StmtResultType.G_R_NONE);
            cmd.setExecutable(true);
        }
        if (this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue() && !SQLCommand.isNoLogExecutable(cmd)) {
            if (cmd.getStmtClass().equals((Object)SQLCommand.StmtType.G_C_UNKNOWN) || !cmd.getStmtClass().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_UNKNOWN) || !cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) {
                // empty if block
            }
            cmd.setExecutable(false);
        }
        if (!(this.m_out instanceof WrapListenBufferOutputStream)) {
            this.getScriptRunnerContext().setOutputStreamWrapper(this.m_out);
            this.m_out = this.getScriptRunnerContext().getOutputStream();
        }
        SetEcho.coreBeginWatcher(this.m_conn, this.getScriptRunnerContext(), cmd);
        if (context.getExited()) {
            CommandRegistry.fireBeginListeners(this.m_conn, this.getScriptRunnerContext(), cmd);
            return;
        }
        Substitution sub = new Substitution(this.getScriptRunnerContext());
        try {
            try {
                sub.replaceSubstitution(cmd);
            }
            finally {
                CommandRegistry.fireBeginListeners(this.m_conn, this.getScriptRunnerContext(), cmd);
            }
        }
        catch (Substitution.SubstitutionException e) {
            this.report(e.getMessage());
            return;
        }
        if (this.getScriptRunnerContext().getExited()) {
            return;
        }
        if (this.getConn() != null && !isOracleConnection && !isHttp && cmd.getStmtId() == SQLCommand.StmtSubType.G_S_UNKNOWN) {
            SQLCommand genericStmtCmd = SQLStatementTypes.hintTokens.get("/*sqldev:stmt*/");
            cmd.setStmtClass(genericStmtCmd.getStmtClass());
            cmd.setStmtId(genericStmtCmd.getStmtId());
            cmd.setResultsType(genericStmtCmd.getResultsType());
            cmd.setExecutable(genericStmtCmd.getExecutable());
        }
        boolean runCommand = true;
        Integer restrictLevel = null;
        String rlevel = (String)this.getScriptRunnerContext().getProperty("script.runner.restrict_level");
        if (rlevel != null) {
            restrictLevel = Integer.valueOf(rlevel);
        }
        if (restrictLevel != null && !restrictLevel.equals(new Integer(0)) && this.skipRestricted(cmd, restrictLevel)) {
            runCommand = false;
        }
        if (runCommand) {
            if (!CommandRegistry.fireListeners(this.m_conn, this.getScriptRunnerContext(), cmd)) {
                switch (cmd.getStmtType()) {
                    case G_C_SQL: {
                        if (cmd.getExecutable()) {
                            this.runSQL(cmd);
                            if (this.getScriptRunnerContext().getProperty("sqldev.last.err.type") == null) break;
                            cmd.setFail();
                            break;
                        }
                        this.report(ScriptRunnerDbArb.getString("NOT_CONNECTED"));
                        cmd.setFail();
                        break;
                    }
                    case G_C_PLSQL: {
                        if (cmd.getExecutable()) {
                            if (cmd.getRunnable()) {
                                this.runPLSQL(cmd);
                                if (this.getScriptRunnerContext().getProperty("sqldev.last.err.type") == null) break;
                                cmd.setFail();
                                break;
                            }
                            if (this.getScriptRunnerContext().getProperty("script.runner.jline") == null) break;
                            this.getScriptRunnerContext().getSQLPlusBuffer().resetBuffer(cmd.getSQLOrig());
                            this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().resetBuffer(Arrays.asList(cmd.getSQLOrigWithTerminator().split("\n")));
                            break;
                        }
                        this.report(ScriptRunnerDbArb.getString("NOT_CONNECTED"));
                        cmd.setFail();
                        break;
                    }
                    case G_C_SQLPLUS: 
                    case G_C_OLDCOMMENT: {
                        if (cmd.getExecutable() || !cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_EXECUTE)) {
                            this.runSQLPLUS(cmd);
                            break;
                        }
                        this.report(ScriptRunnerDbArb.getString("NOT_CONNECTED"));
                        this.report(ScriptRunnerDbArb.getString("NOT_CONNECTED_FOR_EXECUTE"));
                        cmd.setFail();
                        break;
                    }
                    case G_C_COMMENT: 
                    case G_C_MULTILINECOMMENT: 
                    case G_C_EMPTYLINE: {
                        break;
                    }
                    case G_C_UNKNOWN: {
                        this.unknown(ScriptRunnerDbArb.getString("UNKNOWN_COMMAND"), cmd);
                        this.report("\n");
                        break;
                    }
                    case G_C_NOT_CONNECTED: {
                        this.report(ScriptRunnerDbArb.getString("NOT_CONNECTED"));
                        cmd.setFail();
                        break;
                    }
                    default: {
                        this.unknown("class", cmd);
                        break;
                    }
                }
            } else if (!(!cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_STARTUP) && !cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHUTDOWN) || this.getScriptRunnerContext().getCurrentConnection() == null || this.m_conn != null && this.m_conn.equals(this.getScriptRunnerContext().getCurrentConnection()))) {
                this.m_conn = this.getScriptRunnerContext().getCurrentConnection();
            }
        }
        if (cmd.getRunnable()) {
            CommandRegistry.fireEndListeners(this.m_conn, this.getScriptRunnerContext(), cmd);
        }
        if (this.m_scriptRunnerContext.getProperty("script.runner.using.systemout") == null || !((Boolean)this.m_scriptRunnerContext.getProperty("script.runner.using.systemout")).booleanValue()) {
            this.m_out.write(FORCE_PRINT_BYTES);
        }
        this.m_out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPLSQL(ISQLCommand cmd) {
        String sql = cmd.getSql();
        PLSQL plsql = new PLSQL(cmd, this.m_out);
        boolean replaceBinds = false;
        if (this.getScriptRunnerContext().getProperty("sqlcl.script.secureliterals") == null && cmd.getEndLine() - cmd.getStartLine() < 20 || this.getScriptRunnerContext().getProperty("sqlcl.script.secureliterals") != null && this.getScriptRunnerContext().getProperty("sqlcl.script.secureliterals").equals("ON")) {
            try {
                String prefix = sql.substring(0, 100);
                List<LexerToken> src = LexerToken.parse(prefix);
                Iterator<LexerToken> iterator = src.iterator();
                if (iterator.hasNext()) {
                    LexerToken lexerToken = iterator.next();
                    if ("begin".equalsIgnoreCase(lexerToken.content)) {
                        replaceBinds = true;
                    } else if ("declare".equalsIgnoreCase(lexerToken.content)) {
                        replaceBinds = true;
                    }
                }
                if (replaceBinds) {
                    replaceBinds = false;
                    ParsedSql parsedSql = new ParsedSql(sql);
                    ParseNode parseNode = parsedSql.parse();
                    if (parseNode.contains("block_stmt")) {
                        replaceBinds = true;
                    } else {
                        ParseNode child;
                        Iterator<ParseNode> i$2 = parseNode.children().iterator();
                        if (i$2.hasNext() && (child = i$2.next()).contains("block_stmt")) {
                            replaceBinds = true;
                        }
                    }
                }
            }
            catch (Exception prefix) {
                // empty catch block
            }
        }
        Map<Object, Object> auxBinds = new HashMap();
        if (replaceBinds) {
            Literals2Binds bp = null;
            bp = Literals2Binds.bindAid(sql);
            cmd.setSql(bp.getSql());
            plsql = new PLSQL(cmd, this.m_out);
            auxBinds = bp.getBinds();
            for (String string : auxBinds.keySet()) {
                Bind b = new Bind();
                b.setName(string);
                b.setType("VARCHAR2");
                b.setValue((String)auxBinds.get(string));
                this.getScriptRunnerContext().getVarMap().put(string, b);
            }
        }
        try {
            this.m_commandRunner = plsql;
            plsql.setScriptRunnerContext(this.getScriptRunnerContext());
            plsql.setConn(this.m_conn);
            plsql.run();
            this.setScriptRunnerContext(plsql.getScriptRunnerContext());
            if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
                this.getScriptRunnerContext().getSQLPlusBuffer().resetBuffer(cmd.getSQLOrigWithTerminator());
                this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().resetBuffer(Arrays.asList(cmd.getSQLOrigWithTerminator().split("\n")));
            }
        }
        finally {
            for (String string : auxBinds.keySet()) {
                this.getScriptRunnerContext().getVarMap().remove(string);
            }
            plsql = null;
        }
    }

    private void runSQL(ISQLCommand cmd) {
        SQL sql = new SQL(cmd, this.m_out);
        this.m_commandRunner = sql;
        sql.setScriptRunnerContext(this.getScriptRunnerContext());
        sql.setConn(this.m_conn);
        int originalFeedback = sql.getScriptRunnerContext().getFeedback();
        try {
            if (cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_DESCRIBE)) {
                sql.getScriptRunnerContext().setFeedback(-2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sql.run();
        this.setScriptRunnerContext(sql.getScriptRunnerContext());
        if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
            this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().resetBuffer(cmd.getSQLOrigWithTerminator());
        }
        sql.getScriptRunnerContext().setFeedback(originalFeedback);
        sql = null;
    }

    private void runSQLPLUS(ISQLCommand cmd) {
        SQLPLUS sqlplus = new SQLPLUS(cmd, this.m_out);
        this.m_commandRunner = sqlplus;
        sqlplus.setScriptRunnerContext(this.getScriptRunnerContext());
        sqlplus.setConn(this.m_conn);
        sqlplus.setDirectory(this.m_directory);
        sqlplus.run();
        this.m_conn = sqlplus.getConn();
        this.setScriptRunnerContext(sqlplus.getScriptRunnerContext());
        sqlplus = null;
        this.getScriptRunnerContext().setCurrentConnection(this.m_conn);
    }

    public void setConn(Connection conn) {
        this.m_conn = conn;
    }

    public void setOut(BufferedOutputStream out) {
        this.m_out = out;
    }

    public void setPrintComments(boolean printComments) {
        this.m_printComments = printComments;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.m_scriptRunnerContext = scriptRunnerContext;
    }

    public void setStatusDisplay(ScriptStatusDisplay status) {
        this.m_status = status;
    }

    public void setStatusLine(String statusLine) {
        if (this.m_status != null) {
            this.m_status.setText(statusLine);
        }
    }

    private void unknown(String text, ISQLCommand cmd) {
        try {
            this.setStatusLine(ScriptRunnerDbArb.getString("UNKNOWN_COMMAND"));
            String localString = ScriptRunnerContext.lineErr(new Integer(cmd.getStartLine() + 1), cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNKNOWN_COMMAND_ARG", text), this.getScriptRunnerContext());
            this.m_out.write(localString.getBytes("UTF-8"));
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void setDirectory(String dir) {
        this.m_directory = dir;
    }

    public void cancel() {
        if (this.m_commandRunner != null) {
            this.m_commandRunner.interrupt();
        }
    }

    private boolean skipRestricted(ISQLCommand cmd, Integer level) {
        boolean retVal = false;
        if (level.equals(new Integer(4))) {
            return false;
        }
        switch (cmd.getStmtSubType()) {
            case G_S_ALTER: {
                String lowerTrim = cmd.getSql().toLowerCase().trim().replace('\r', ' ').replace('\n', ' ');
                if (!lowerTrim.matches("alter\\s+system.*$")) break;
                retVal = true;
            }
        }
        if (!retVal) {
            boolean isSQLPlus = false;
            switch (cmd.getStmtType()) {
                case G_C_SQLPLUS: {
                    isSQLPlus = true;
                }
            }
            if (!isSQLPlus) {
                return false;
            }
            switch (cmd.getStmtSubType()) {
                case G_S_EDIT: {
                    if (level.equals(new Integer(0))) {
                        retVal = false;
                        break;
                    }
                    retVal = true;
                    break;
                }
                case G_S_GET: {
                    if (level.equals(new Integer(0)) || level.equals(new Integer(1)) || level.equals(new Integer(2))) {
                        retVal = false;
                        break;
                    }
                    retVal = true;
                    break;
                }
                case G_S_HOST: {
                    if (level.equals(new Integer(0))) {
                        retVal = false;
                        break;
                    }
                    retVal = true;
                    break;
                }
                case G_S_HOSTALIAS: 
                case G_S_SAVE: {
                    if (level.equals(new Integer(0)) || level.equals(new Integer(1))) {
                        retVal = false;
                        break;
                    }
                    retVal = true;
                    break;
                }
                case G_S_SPOOL: {
                    if (level.equals(new Integer(0)) || level.equals(new Integer(1))) {
                        retVal = false;
                        break;
                    }
                    retVal = true;
                    break;
                }
                case G_S_AT: 
                case G_S_START: {
                    if (level.equals(new Integer(0)) || level.equals(new Integer(1)) || level.equals(new Integer(2))) {
                        retVal = false;
                        break;
                    }
                    retVal = true;
                    break;
                }
                case G_S_ATNESTED: 
                case G_S_STORE: {
                    retVal = !level.equals(new Integer(0)) && !level.equals(new Integer(1));
                }
            }
        }
        if (retVal) {
            if (!this.getScriptRunnerContext().isSQLPlusClassic()) {
                this.report(ScriptRunnerDbArb.format("RESTRICTED_COMMAND", cmd.getSQLOrig()));
            } else {
                String s = cmd.getSQLOrig().split(" ", 2)[0];
                this.report(ScriptRunnerDbArb.format("RESTRICTED_COMMAND_CLASSIC", s));
            }
        }
        return retVal;
    }
}

