/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.sql.Connection;

public class ConnectionDetails {
    String m_fullString;
    boolean m_callDialog;
    String m_connectName;
    String m_connectPassword;
    String m_connectDB;
    String m_role;
    boolean m_roleBad;
    int m_at;
    int m_slash;
    Connection m_conn;
    boolean m_callUsage = false;
    private String m_edition;

    public ConnectionDetails(String fullString, boolean callDialog, String connectName, String connectPassword, String connectDB, String role, boolean roleBad, int at, int slash, Connection conn, String edition) {
        this.init(fullString, callDialog, connectName, connectPassword, connectDB, role, roleBad, at, slash, conn, edition);
    }

    public ConnectionDetails(String fullString, boolean callDialog, String connectName, String connectPassword, String connectDB, String role, boolean roleBad, int at, int slash, Connection conn) {
        this.init(fullString, callDialog, connectName, connectPassword, connectDB, role, roleBad, at, slash, conn, "");
    }

    private void init(String fullString, boolean callDialog, String connectName, String connectPassword, String connectDB, String role, boolean roleBad, int at, int slash, Connection conn, String edition) {
        this.m_fullString = fullString;
        this.m_callDialog = callDialog;
        this.m_connectName = connectName;
        this.m_connectPassword = connectPassword;
        this.m_connectDB = connectDB;
        this.m_role = role;
        this.m_roleBad = roleBad;
        this.m_at = at;
        this.m_slash = slash;
        this.m_conn = conn;
        this.m_edition = edition;
    }

    public void setCallDialog(boolean callDialog) {
        this.m_callDialog = callDialog;
    }

    public void setConnectName(String connectName) {
        this.m_connectName = connectName;
    }

    public void setConnectPassword(String connectPassword) {
        this.m_connectPassword = connectPassword;
        this.m_slash = 1;
        this.rebuildFullText();
    }

    public void setConnectDB(String connectDB) {
        this.m_connectDB = connectDB;
        this.m_at = 1;
        this.rebuildFullText();
    }

    public boolean isCallDialog() {
        return this.m_callDialog;
    }

    public String getFullString() {
        return this.m_fullString;
    }

    public String getConnectName() {
        return this.m_connectName;
    }

    public String getConnectPassword() {
        return this.m_connectPassword;
    }

    public String getConnectDB() {
        return this.m_connectDB;
    }

    public String getRole() {
        return this.m_role;
    }

    public boolean getRoleBad() {
        return this.m_roleBad;
    }

    public int getAt() {
        return this.m_at;
    }

    public int getSlash() {
        return this.m_slash;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void setConnection(Connection conn) {
        this.m_conn = conn;
    }

    public boolean getCallUsage() {
        return this.m_callUsage;
    }

    public void setCallUsage(boolean callUsage) {
        this.m_callUsage = callUsage;
    }

    public String getEdition() {
        return this.m_edition;
    }

    public void setEdition(String edition) {
        this.m_edition = edition;
    }

    private void rebuildFullText() {
        String rebuild = "";
        String[] pre = new String[]{"", "/", "@", " ", " "};
        Boolean[] test = new Boolean[]{true, this.getSlash() != -1, this.getAt() != -1, this.getRole() != null && !this.getRole().equals(""), !this.getEdition().equals("")};
        String[] val = new String[]{this.getConnectName(), this.getConnectPassword(), this.getConnectDB(), this.getRole(), this.getEdition()};
        for (int counter = 0; counter < pre.length; ++counter) {
            if (!test[counter].booleanValue()) continue;
            rebuild = rebuild + pre[counter] + val[counter];
        }
        this.m_fullString = rebuild;
    }

    public void cloneFrom(ConnectionDetails source) {
        this.m_fullString = source.getFullString();
        this.m_callDialog = source.isCallDialog();
        this.m_connectName = source.getConnectName();
        this.m_connectPassword = source.getConnectPassword();
        this.m_connectDB = source.getConnectDB();
        this.m_role = source.getRole();
        this.m_roleBad = source.getRoleBad();
        this.m_at = source.getAt();
        this.m_slash = source.getSlash();
        this.m_conn = source.getConnection();
        this.m_callUsage = source.getCallUsage();
    }
}

