/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metadata;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.metadata.AbstractObjectActionPrompt;
import oracle.dbtools.raptor.metadata.IObjectActionConstants;

public class AbstractObjectAction<OAP extends AbstractObjectActionPrompt>
implements IObjectActionConstants {
    public static final int SINGLE_SELECT = 1;
    public static final int MULTI_SELECT = 2;
    public static final int BOTH_SELECT = 3;
    protected Version m_minVersion = null;
    protected Version m_maxVersion = null;
    protected List<OAP> m_prompts = null;
    protected boolean m_reload = false;
    protected boolean m_reloadParent = false;
    protected boolean m_removeFromParent = false;
    protected String m_title = null;
    protected String m_classArgs = null;
    protected String m_connType = null;
    protected int m_selectionMode = 0;
    protected float m_weight = 1.0f;
    protected float m_section = 16.0f;
    protected boolean m_toolbar = false;
    protected boolean m_isRenameAction = false;
    protected String m_sql = null;
    protected String m_sqlType = null;
    protected String m_script = null;
    protected String m_scriptLang = null;
    protected String m_iconName = null;
    protected MetaResource m_iconRef = null;
    protected boolean m_sqldevOnly = false;
    protected String m_type = null;
    protected boolean m_connRequired = true;
    protected String m_commandName = null;
    protected String m_confirm = null;
    protected String m_confirmTitle = null;
    protected String m_confirmSql = null;
    protected String m_help = null;
    protected String[] m_reqFeatures = null;
    protected int m_id;
    protected String m_controllerClassName = null;
    protected List<String> m_features;

    public void setMinVersion(String s) {
        if (s != null) {
            this.m_minVersion = new Version(s);
        }
    }

    public Version getMinVersion() {
        return this.m_minVersion;
    }

    public void setMaxVersion(String s) {
        if (s != null) {
            this.m_maxVersion = new Version(s);
        }
    }

    public Version getMaxVersion() {
        return this.m_maxVersion;
    }

    public List<OAP> getPrompts() {
        if (this.m_prompts == null) {
            this.m_prompts = new ArrayList<OAP>();
        }
        return this.m_prompts;
    }

    public void setPrompts(List<OAP> prompts) {
        this.m_prompts = prompts;
    }

    public void setReload(boolean reload) {
        this.m_reload = reload;
    }

    public boolean getReload() {
        return this.m_reload;
    }

    public void setReloadParent(boolean reload) {
        this.m_reloadParent = reload;
    }

    public boolean getReloadParent() {
        return this.m_reloadParent;
    }

    public void setRemoveFromParent(boolean remove) {
        this.m_removeFromParent = remove;
    }

    public boolean isRemoveFromParent() {
        return this.m_removeFromParent;
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    public String getHelp() {
        return this.m_help;
    }

    public String getType() {
        return this.m_type;
    }

    public String getSql() {
        return this.m_sql;
    }

    public String getSqlType() {
        return this.m_sqlType;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String getConfirm() {
        return this.m_confirm;
    }

    public String getConfirmSql() {
        return this.m_confirmSql;
    }

    public String getConfirmTitle() {
        return this.m_confirmTitle;
    }

    public void setClassArgs(String classargs) {
        this.m_classArgs = classargs;
    }

    public String getClassArgs() {
        return this.m_classArgs;
    }

    public void setConnType(String connType) {
        this.m_connType = connType;
    }

    public String getConnType() {
        return this.m_connType == null ? "Oracle" : this.m_connType;
    }

    public int getSelectionMode() {
        return this.m_selectionMode;
    }

    public boolean isSelectable(int i) {
        return (i & this.m_selectionMode) == i;
    }

    public void setSelectionMode(int s) {
        this.m_selectionMode = s;
    }

    public void setSelectionMode(String s) {
        if (s != null && s.equalsIgnoreCase("MULTI")) {
            this.setSelectionMode(2);
        } else if (s != null && s.equalsIgnoreCase("BOTH")) {
            this.setSelectionMode(3);
        } else {
            this.setSelectionMode(1);
        }
    }

    public List<String> getDefaults() {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractObjectActionPrompt p : this.getPrompts()) {
            ret.add(p.getDefault());
        }
        return ret;
    }

    public boolean isConnectionRequired() {
        return this.m_connRequired;
    }

    public float getWeight() {
        return this.m_weight;
    }

    public void setWeight(float weight) {
        this.m_weight = weight;
    }

    public float getSection() {
        return this.m_section;
    }

    public void setSection(float section) {
        this.m_section = section;
    }

    public boolean isScript() {
        return ModelUtil.hasLength(this.m_script);
    }

    public boolean isSqlDevOnly() {
        return this.m_sqldevOnly;
    }

    public String getScript() {
        return this.m_script;
    }

    public String getScriptLanguage() {
        if (this.m_scriptLang == null) {
            this.m_scriptLang = "js";
        }
        return this.m_scriptLang;
    }

    public void setToolbar(boolean toolbar) {
        this.m_toolbar = toolbar;
    }

    public boolean isToolbar() {
        return this.m_toolbar;
    }

    public boolean isRenameAction() {
        return this.m_isRenameAction;
    }

    public void setIsRenameAction(boolean isRenameAction) {
        this.m_isRenameAction = isRenameAction;
    }

    public void setSql(String sql) {
        this.m_sql = sql;
    }

    public void setSqlType(String sqlType) {
        this.m_sqlType = sqlType;
    }

    public void setScript(String script) {
        this.m_script = script;
    }

    public void setScriptLang(String scriptLang) {
        this.m_scriptLang = scriptLang;
    }

    public MetaResource getIconRef() {
        return this.m_iconRef;
    }

    public void setIconRef(MetaResource mRes) {
        this.m_iconRef = mRes;
    }

    public void setSqldevOnly(boolean sqldevOnly) {
        this.m_sqldevOnly = sqldevOnly;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setConnRequired(boolean connRequired) {
        this.m_connRequired = connRequired;
    }

    public void setCommandName(String commandName) {
        this.m_commandName = commandName;
    }

    public String getCommandName() {
        return this.m_commandName;
    }

    public void setConfirm(String confirm) {
        this.m_confirm = confirm;
    }

    public void setConfirmTitle(String confirmTitle) {
        this.m_confirmTitle = confirmTitle;
    }

    public void setConfirmSql(String confirmSQL) {
        this.m_confirmSql = confirmSQL;
    }

    public void setHelp(String help) {
        this.m_help = help;
    }

    public void setReqFeatures(String[] features) {
        if (features == null) {
            this.m_features = null;
            return;
        }
        if (this.m_features == null) {
            this.m_features = new ArrayList<String>();
        }
        this.m_features.clear();
        for (String feature : features) {
            this.m_features.add(feature);
        }
    }

    public String[] getReqFeatures() {
        if (this.m_features == null) {
            return null;
        }
        return this.m_features.toArray(new String[this.m_features.size()]);
    }
}

