/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.utils.GuidGen;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;

public class LoaderFormatter
extends ResultsFormatter {
    private static final Logger LOGGER = Logger.getLogger(LoaderFormatter.class.getName());
    public static final String TYPE = "LOADER";
    public static final String EXT = "ctl";
    public static final String EXT_DAT = "ldr";
    public static final String KEY_SEPARATE_DATA_FILE = "SEPARATE_DATA_FILE";
    public static final String KEY_DELIMITER = "EXPORT_LDR_DELIMITER";
    public static final String KEY_REC_TERM = "EXPORT_LDR_REC_TERM";
    public static final String KEY_ENCLOSURES = "EXPORT_LDR_ENCLOSURES";
    public static final String KEY_ENCL_LEFT = "EXPORT_LDR_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "EXPORT_LDR_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "EXPORT_LDR_ENCL_RIGHT_DOUBLE";
    boolean do_header = false;
    boolean blobClobWarning = false;
    boolean rowWritten = false;
    String tableName = null;
    StringBuilder header;
    StringBuilder row;
    Writer _sepDataWriter;
    private Set<String> s = new HashSet<String>();
    private List<Object> colIsNullObject = new ArrayList<Object>();
    private int indentNum;
    private boolean columnOutputted = false;
    private boolean headerStarted = false;
    private boolean _isSeparateDataFile = false;
    private String ldr_delim = "|";
    private String ldr_leftEnc = "\"";
    private String ldr_rightEnc = "\"";
    private String _ldrEOLChars;
    private String _ctlEOLChars;
    private Integer numRows = 0;
    private ArrayList<String> _createdFiles = new ArrayList();
    int spin = 0;

    public LoaderFormatter() {
        super(TYPE, Messages.getString("LoaderFormatter.3"), EXT_DAT);
    }

    @Override
    public void setTableName(String tName) {
        this.tableName = tName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean allowsHeader() {
        return false;
    }

    @Override
    public void setLineTerminator(String terminator) {
        this._ldrEOLChars = terminator;
    }

    @Override
    public void start() throws IOException {
        this.do_header = true;
        this.rowWritten = false;
        this.header = new StringBuilder();
        this.blobClobWarning = false;
        if (this._delimiter != null) {
            this.ldr_delim = this._delimiter;
        }
        if (this._enclosureLeft != null) {
            this.ldr_leftEnc = this._enclosureLeft;
        }
        if (this._enclosureRight != null) {
            this.ldr_rightEnc = this._enclosureRight;
        }
        this.s = new HashSet<String>();
        this.spin = 0;
        int size = this.getColumnCount();
        for (int i = 0; i < size; ++i) {
            this.s.add(this.getColumnName(i).replaceAll("\"", "").toUpperCase());
        }
    }

    private String getNewName(String name) {
        String longName = null;
        while (this.s.contains(longName = "L_" + this.spin)) {
            ++this.spin;
        }
        this.s.add(longName);
        ++this.spin;
        return longName;
    }

    private String getVarrayInfo(String name, Object data, List<Object> thisArray) {
        String indentation = "";
        for (int i = 0; i < this.indentNum; ++i) {
            indentation = indentation + "  ";
        }
        String typeData = indentation + "(" + this.getLineTerminator();
        try {
            thisArray.add(0, new Integer(0));
            ARRAY varr = (ARRAY)data;
            Datum[] values = varr.getOracleArray();
            int dt1 = varr.getBaseType();
            if (dt1 == 2002) {
                if (values[0] != null) {
                    typeData = typeData + indentation + "  " + name + " COLUMN OBJECT" + this.getLineTerminator();
                    ++this.indentNum;
                    ArrayList<Object> arrayofStruct = new ArrayList<Object>();
                    typeData = typeData + this.getColumnObjectInfo(values[0], arrayofStruct);
                    thisArray.add(0, arrayofStruct);
                    --this.indentNum;
                } else {
                    thisArray.add(0, new Integer(1));
                }
            } else if (dt1 == 2003) {
                if (values[0] != null) {
                    ArrayDescriptor varrDescriptor = varr.getDescriptor();
                    int varrType = varrDescriptor.getArrayType();
                    String varrTypeName = "";
                    varrTypeName = varrType == 2 ? "NESTED TABLE" : "VARRAY";
                    typeData = typeData + indentation + "  " + name + " " + varrTypeName + " TERMINATED BY '" + this.ldr_delim + "/'" + this.getLineTerminator();
                    ++this.indentNum;
                    ArrayList<Object> arrayofArray = new ArrayList<Object>();
                    typeData = typeData + this.getVarrayInfo(name, values[0], arrayofArray);
                    thisArray.add(0, arrayofArray);
                    --this.indentNum;
                } else {
                    thisArray.add(0, new Integer(1));
                }
            } else {
                typeData = typeData + indentation + "  " + name + this.getDateFormat(dt1) + this.getLineTerminator();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return typeData + indentation + ")" + this.getLineTerminator();
    }

    private String getColumnObjectInfo(Object data, List<Object> thisStruct) {
        String indentation = "";
        boolean elementOutput = false;
        for (int i = 0; i < this.indentNum; ++i) {
            indentation = indentation + "  ";
        }
        String typeData = indentation + "(" + this.getLineTerminator();
        try {
            STRUCT struct = (STRUCT)data;
            Object[] sCols = struct.getAttributes();
            StructDescriptor desc = struct.getDescriptor();
            ResultSetMetaData metadata = desc.getMetaData();
            for (int md1 = 0; md1 < metadata.getColumnCount(); ++md1) {
                Object obj2 = sCols[md1];
                int dt1 = metadata.getColumnType(md1 + 1);
                String colName = metadata.getColumnName(md1 + 1);
                thisStruct.add(md1, new Integer(0));
                if (dt1 == 2002) {
                    if (obj2 != null) {
                        if (elementOutput) {
                            typeData = typeData + "," + this.getLineTerminator();
                        }
                        elementOutput = true;
                        typeData = typeData + indentation + "  " + colName + " COLUMN OBJECT" + this.getLineTerminator();
                        ++this.indentNum;
                        ArrayList<Object> internalStruct = new ArrayList<Object>();
                        typeData = typeData + this.getColumnObjectInfo(obj2, internalStruct);
                        thisStruct.add(md1, internalStruct);
                        --this.indentNum;
                        continue;
                    }
                    thisStruct.add(md1, new Integer(1));
                    continue;
                }
                if (dt1 == 2003) {
                    if (obj2 != null) {
                        if (elementOutput) {
                            typeData = typeData + "," + this.getLineTerminator();
                        }
                        elementOutput = true;
                        ARRAY varr = (ARRAY)obj2;
                        ArrayDescriptor varrDescriptor = varr.getDescriptor();
                        int varrType = varrDescriptor.getArrayType();
                        String varrTypeName = "";
                        varrTypeName = varrType == 2 ? "NESTED TABLE" : "VARRAY";
                        typeData = typeData + indentation + "  " + colName + " " + varrTypeName + " TERMINATED BY '" + this.ldr_delim + "/'" + this.getLineTerminator();
                        ArrayList<Object> internalArray = new ArrayList<Object>();
                        ++this.indentNum;
                        typeData = typeData + this.getVarrayInfo(colName, obj2, internalArray);
                        thisStruct.add(md1, internalArray);
                        --this.indentNum;
                        continue;
                    }
                    thisStruct.add(md1, new Integer(1));
                    continue;
                }
                if (elementOutput) {
                    typeData = typeData + "," + this.getLineTerminator();
                }
                elementOutput = true;
                typeData = typeData + indentation + "  " + colName + this.getDateFormat(dt1);
            }
            typeData = typeData + this.getLineTerminator();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return typeData + indentation + ")" + this.getLineTerminator();
    }

    private String getColumnInfo(Object data, int col) {
        this.indentNum = 1;
        this.colIsNullObject.add(col, new Integer(0));
        String colName = this.getColumnName(col);
        String name = colName.startsWith("\"") ? colName : "\"" + colName + "\"";
        int dt = this.getDataType(col);
        if (dt == 2002) {
            if (data == null) {
                this.colIsNullObject.add(col, new Integer(1));
                return null;
            }
            ArrayList<Object> internalStruct = new ArrayList<Object>();
            String theObject = this.getColumnObjectInfo(data, internalStruct);
            this.colIsNullObject.add(col, internalStruct);
            return name + " COLUMN OBJECT" + this.getLineTerminator() + theObject;
        }
        if (dt == 2003) {
            if (data == null) {
                this.colIsNullObject.add(col, new Integer(1));
                return null;
            }
            String varrTypeName = "";
            try {
                ARRAY varr = (ARRAY)data;
                ArrayDescriptor varrDescriptor = varr.getDescriptor();
                int varrType = varrDescriptor.getArrayType();
                varrTypeName = varrType == 2 ? "NESTED TABLE" : "VARRAY";
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            String varray = name + " " + varrTypeName + " TERMINATED BY '" + this.ldr_delim + "/'" + this.getLineTerminator();
            ++this.indentNum;
            ArrayList<Object> internalArray = new ArrayList<Object>();
            varray = varray + this.getVarrayInfo(name, data, internalArray);
            this.colIsNullObject.add(col, internalArray);
            --this.indentNum;
            return varray;
        }
        if (dt == 2004 || dt == 2005 || dt == 2007 && this.isXMLType(data)) {
            String newName = this.getNewName(name);
            return newName + " FILLER char," + this.getLineTerminator() + name + " LOBFILE( " + newName + ") TERMINATED BY EOF NULLIF " + newName + " = 'null'";
        }
        if (dt == -13) {
            int colidx = col + 1;
            String dname = "dname_" + colidx + " FILLER char(20)" + "," + this.getLineTerminator();
            String fname = "fname_" + colidx + " FILLER char(30)" + "," + this.getLineTerminator();
            String newName = name + " BFILE(" + "dname_" + colidx + ",fname_" + colidx + ")";
            return dname + fname + newName;
        }
        if (dt == 1 || dt == 12 || dt == -15 || dt == -9) {
            return name + " CHAR (" + this.getPrecision(col) + ")";
        }
        return name + this.getDateFormat(dt);
    }

    public void start2(Object data, int col) throws IOException {
        String next;
        int size = this.getColumnCount();
        if (col == 0) {
            this._EOLChars = null;
            this.header.append(this.isDeployCloud() ? "LOAD DATA CHARACTERSET \"AL32UTF8\" LENGTH CHAR" + this.getLineTerminator() : "LOAD DATA " + this.getLineTerminator());
            if (!this.isSeparateDataFile()) {
                this.header.append("INFILE *" + this.getLineTerminator());
            } else {
                this.header.append("INFILE '" + this.getFileName() + "' " + "\"" + "str '" + this.getLineTerminatorString() + "'" + "\"" + this.getLineTerminator());
            }
            this.header.append("APPEND" + this.getLineTerminator());
            this.header.append("CONTINUEIF NEXT(1:1) = '#'" + this.getLineTerminator());
            String[] names = this.tableName.split("\\.");
            if (names.length == 1) {
                if (!names[0].startsWith("\"")) {
                    this.header.append("INTO TABLE \"" + names[0] + "\"" + this.getLineTerminator());
                } else {
                    this.header.append("INTO TABLE " + names[0] + this.getLineTerminator());
                }
            } else {
                if (!names[0].startsWith("\"")) {
                    this.header.append("INTO TABLE \"" + names[0] + "\"" + ".");
                } else {
                    this.header.append("INTO TABLE " + names[0] + ".");
                }
                if (!names[1].startsWith("\"")) {
                    this.header.append("\"" + names[1] + "\"" + this.getLineTerminator());
                } else {
                    this.header.append(names[1] + this.getLineTerminator());
                }
            }
            this.header.append("FIELDS TERMINATED BY'" + this.ldr_delim + "'" + this.getLineTerminator());
            if (this.ldr_leftEnc.length() != 0) {
                this.header.append("OPTIONALLY ENCLOSED BY '" + this.handleSpecialEnclosure(this.ldr_leftEnc) + "'" + " AND " + "'" + this.handleSpecialEnclosure(this.ldr_rightEnc) + "'" + this.getLineTerminator());
            }
            this.header.append("TRAILING NULLCOLS ( " + this.getLineTerminator());
            this.headerStarted = false;
            this.colIsNullObject.clear();
        }
        if ((next = this.getColumnInfo(data, col)) != null) {
            if (this.headerStarted) {
                this.header.append("," + this.getLineTerminator());
            }
            this.header.append(next);
            this.headerStarted = true;
        }
        if (col == size - 1) {
            this.header.append(")" + this.getLineTerminator());
            this._ctlEOLChars = this._EOLChars;
            this._EOLChars = this._ldrEOLChars;
        }
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    private String getDateFormat(int dt) {
        String mask = "";
        if (dt == 91) {
            mask = NLSUtils.getDateFormat(this.getConnection(), FormatType.LOADER);
            return " DATE \"" + mask + "\" ";
        }
        if (dt == 93) {
            mask = NLSUtils.getTimeStampFormat(this.getConnection(), FormatType.LOADER);
            return " TIMESTAMP \"" + mask + "\" ";
        }
        if (dt == -101) {
            mask = NLSUtils.getTimeStampWithTimeZoneFormat(this.getConnection(), FormatType.LOADER);
            return " TIMESTAMP WITH TIME ZONE \"" + mask + "\" ";
        }
        if (dt == -102) {
            mask = NLSUtils.getTimeStampWithTimeZoneFormat(this.getConnection(), FormatType.LOADER);
            return " TIMESTAMP WITH TIME ZONE \"" + mask + "\" ";
        }
        return " ";
    }

    @Override
    public void startRow() throws IOException {
        this.row = new StringBuilder();
        this.row.append(" ");
    }

    private String getStruct(Object data, List<Object> theStructNullIndicator) {
        String colm = "";
        Object structObj = null;
        try {
            STRUCT struct = (STRUCT)data;
            Object[] sCols = struct.getAttributes();
            StructDescriptor desc = struct.getDescriptor();
            ResultSetMetaData metadata = desc.getMetaData();
            for (int md1 = 0; md1 < metadata.getColumnCount(); ++md1) {
                Object obj2;
                boolean processStruct = true;
                int dt1 = metadata.getColumnType(md1 + 1);
                if (theStructNullIndicator != null && (structObj = theStructNullIndicator.get(md1)) instanceof Integer && (Integer)structObj == 1) {
                    processStruct = false;
                }
                if (!processStruct) continue;
                if (sCols[md1] == null) {
                    if (dt1 == 2002) {
                        colm = colm + this.ldr_delim;
                        continue;
                    }
                    if (dt1 == 2003) {
                        colm = colm + this.ldr_delim + "/";
                        continue;
                    }
                    if (dt1 == 2004 || dt1 == 2005) {
                        colm = colm + this.getLeftEnc(dt1) + "null" + this.getRightEnc(dt1) + this.ldr_delim;
                        continue;
                    }
                    colm = colm + this.getLeftEnc(dt1) + this.getRightEnc(dt1) + this.ldr_delim;
                    continue;
                }
                if (dt1 == 2002) {
                    obj2 = sCols[md1];
                    colm = colm + this.getStruct(obj2, (List)structObj);
                    continue;
                }
                if (dt1 == 2003) {
                    obj2 = sCols[md1];
                    colm = colm + this.getVarray(obj2, (List)structObj);
                    continue;
                }
                colm = colm + this.getLeftEnc(dt1) + this.cleanString(this.getValue(sCols[md1], dt1).toString()) + this.getRightEnc(dt1) + this.ldr_delim;
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return colm;
    }

    private String getVarray(Object data, List<Object> theArrayNullIndicator) {
        String colm = "";
        Object arrayObj = null;
        try {
            boolean processArray = true;
            ARRAY varr = (ARRAY)data;
            int baseTyp = varr.getBaseType();
            Datum[] values = varr.getOracleArray();
            if (theArrayNullIndicator != null && (arrayObj = theArrayNullIndicator.get(0)) instanceof Integer && (Integer)arrayObj == 1) {
                processArray = false;
            }
            int elementCount = 0;
            if (processArray) {
                for (int x = 0; x < varr.length(); ++x) {
                    if (values[x] == null) {
                        if (baseTyp == 2002) {
                            colm = colm + this.ldr_delim;
                            continue;
                        }
                        if (baseTyp == 2003) {
                            colm = colm + this.ldr_delim;
                            continue;
                        }
                        if (baseTyp == 2004 || baseTyp == 2005) {
                            colm = colm + this.getLeftEnc(baseTyp) + "null" + this.getRightEnc(baseTyp) + this.ldr_delim;
                            continue;
                        }
                        colm = colm + this.getLeftEnc(baseTyp) + this.getRightEnc(baseTyp) + this.ldr_delim;
                        continue;
                    }
                    if (++elementCount >= 10) {
                        colm = colm + this.getLineTerminator() + "#";
                        elementCount = 0;
                    }
                    colm = baseTyp == 2002 ? colm + this.getStruct(values[x], (List)arrayObj) : (baseTyp == 2003 ? colm + this.getVarray(values[x], (List)arrayObj) : colm + this.getLeftEnc(baseTyp) + this.cleanString(this.getValue(values[x], baseTyp).toString()) + this.getRightEnc(baseTyp) + this.ldr_delim);
                }
                colm = colm + "/";
            } else {
                colm = colm + this.ldr_delim + "/";
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return colm;
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        int dt;
        Object obj = null;
        if (this.do_header) {
            this.start2(col, viewIndex);
        }
        if (!((dt = this.getDataType(viewIndex)) != 2002 && dt != 2003 || (obj = this.colIsNullObject.get(viewIndex)) instanceof ArrayList || (Integer)this.colIsNullObject.get(viewIndex) != 1)) {
            return;
        }
        String colm = "";
        this.columnOutputted = true;
        if (col == null) {
            colm = colm + this.getDelimNullDisplay(dt) + this.ldr_delim;
            if (dt == 2003) {
                colm = colm + "/";
            }
        } else if (dt == 2002) {
            colm = colm + this.getStruct(col, (List)obj);
        } else if (dt == 2003) {
            colm = colm + this.getVarray(col, (List)obj);
        } else if (dt == -13) {
            try {
                colm = ((BFILE)col).getDirAlias() + this.ldr_delim + ((BFILE)col).getName() + this.ldr_delim;
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            colm = colm + this.getLeftEnc(dt) + this.cleanString(this.getValue(col, dt).toString()) + this.getRightEnc(dt) + this.ldr_delim;
        }
        this.row.append(colm);
    }

    private String getLeftEnc(int datatype) {
        if (this._isEnclosed && (datatype == 1 || datatype == 12 || datatype == 93 || datatype == -15 || datatype == -9 || datatype == -16 || datatype == -1)) {
            return this.ldr_leftEnc;
        }
        return "";
    }

    private String getRightEnc(int datatype) {
        if (this._isEnclosed && (datatype == 1 || datatype == 12 || datatype == 93 || datatype == -15 || datatype == -9 || datatype == -16 || datatype == -1)) {
            return this.ldr_rightEnc;
        }
        return "";
    }

    @Override
    public String cleanString(String str) {
        String newStr = "";
        for (int i = 0; i < str.length(); ++i) {
            Character ch = Character.valueOf(str.charAt(i));
            newStr = newStr + ch;
        }
        return newStr;
    }

    private String getNullorNullDisplay() {
        Object nullValue = super.getValue(null);
        return nullValue != null ? nullValue.toString() : "null";
    }

    private String getEmptyorNullDisplay() {
        Object nullValue = super.getValue(null);
        return nullValue != null ? nullValue.toString() : "";
    }

    private String getDelimNullDisplay(int datatype) {
        switch (datatype) {
            case 2004: 
            case 2005: 
            case 2007: {
                return this.getNullorNullDisplay();
            }
        }
        return this.getEmptyorNullDisplay();
    }

    @Override
    public void endRow() throws IOException {
        this.rowWritten = true;
        this.numRows = this.numRows + 1;
        if (this._zipper != null) {
            this._zipper.writeEntryText(this.row.toString());
            this._zipper.writeEntryText(this.getLineTerminator());
        } else if (this._out != null) {
            this._out.write(this.row.toString());
            this._out.write(this.getLineTerminator());
            if (this._writeTracker < 20) {
                ++this._writeTracker;
            } else {
                if (this._out != null) {
                    this._out.flush();
                }
                this._writeTracker = 0;
            }
        }
        this.do_header = false;
        this.columnOutputted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue(Object obj, int type) {
        if (this.getFileName() == null && (obj instanceof Blob || obj instanceof Clob)) {
            return "null";
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            String opfile = "";
            boolean isNull = false;
            try {
                Reader clobRdr = clob.getCharacterStream();
                opfile = this.getNewFileName(EXT_DAT);
                this._createdFiles.add(opfile);
                try {
                    isNull = this.writeFile(opfile, clobRdr);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    isNull = true;
                }
                finally {
                    try {
                        clobRdr.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                Logger.getLogger(LoaderFormatter.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                isNull = true;
            }
            if (isNull) {
                return "null";
            }
            return new File(opfile).getName();
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            String opfile = "";
            FilterOutputStream bos = null;
            InputStream is = null;
            boolean isNull = false;
            try {
                opfile = this.getNewFileName(EXT_DAT);
                is = blob.getBinaryStream();
                if (is != null) {
                    this._createdFiles.add(opfile);
                    bos = new BufferedOutputStream(new FileOutputStream(opfile));
                    byte[] buffer = new byte[4096];
                    int length = 0;
                    while ((length = is.read(buffer)) != -1) {
                        ((BufferedOutputStream)bos).write(buffer, 0, length);
                    }
                } else {
                    isNull = true;
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (isNull) {
                return "null";
            }
            return new File(opfile).getName();
        }
        if (obj instanceof OPAQUE) {
            String opfile;
            boolean isNull;
            block71: {
                String str = "";
                isNull = false;
                opfile = "";
                try {
                    OPAQUE opaque = (OPAQUE)obj;
                    str = opaque.getSQLTypeName().trim();
                    if (!str.equals("SYS.XMLTYPE")) break block71;
                    XMLType xmltype = XMLType.createXML((OPAQUE)opaque);
                    Reader clobRdr = xmltype.getClobVal().getCharacterStream();
                    opfile = this.getNewFileName(EXT_DAT);
                    this._createdFiles.add(opfile);
                    try {
                        isNull = this.writeFile(opfile, clobRdr);
                    }
                    catch (Exception e) {
                        isNull = true;
                    }
                    finally {
                        try {
                            clobRdr.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(LoaderFormatter.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    isNull = true;
                }
            }
            if (isNull) {
                return "null";
            }
            return new File(opfile).getName();
        }
        if (this._isEnclosed && (type == 1 || type == -16 || type == -1 || type == -15 || type == -9 || type == 12)) {
            return this.enclosureRightDouble(this.getResultsFormatterWrapper().getValue(obj).toString());
        }
        if (obj instanceof DATE || obj instanceof TIMESTAMPTZ || obj instanceof TIMESTAMPLTZ || obj instanceof TIMESTAMP) {
            return this.getResultsFormatterWrapper().getValue(obj, FormatType.LOADER);
        }
        return this.getResultsFormatterWrapper().getValue(obj);
    }

    private boolean isXMLType(Object obj) {
        if (obj instanceof OPAQUE) {
            try {
                OPAQUE opaque = (OPAQUE)obj;
                if (opaque.getSQLTypeName().trim().equals("SYS.XMLTYPE")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private String getNewFileName(String ext) {
        return this.getNewFileName(ext, GuidGen.toString(GuidGen.uuidCreate()).replaceAll("\\" + this.ldr_delim, "_"));
    }

    private String getNewFileName(String ext, String opfile) {
        String fileName = this.getFileName();
        if (fileName == null) {
            return "";
        }
        int extIndex = fileName.lastIndexOf(".");
        String baseFileName = extIndex != -1 ? fileName.substring(0, extIndex) : fileName;
        int spin = 0;
        fileName = baseFileName + opfile + "." + ext;
        if (!new File(fileName).exists()) {
            return fileName;
        }
        while (new File(fileName).exists()) {
            fileName = baseFileName + opfile + "_" + ++spin + "." + ext;
        }
        return fileName;
    }

    private Writer getNewWriter(String file) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(file);
            try {
                osw = new OutputStreamWriter((OutputStream)fos, this.getEncode());
            }
            catch (UnsupportedEncodingException e1) {
                LOGGER.log(Level.WARNING, e1.getStackTrace()[0].toString(), e1);
                osw = new OutputStreamWriter(fos);
            }
            bw = new BufferedWriter(osw);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return bw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(String file, Reader reader) {
        Writer writer = this.getNewWriter(file);
        boolean isNull = true;
        if (writer != null) {
            try {
                char[] buffer = new char[4096];
                int length = 0;
                while ((length = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, length);
                    isNull = false;
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {}
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return isNull;
    }

    @Override
    public void end() throws IOException {
        if (!this.rowWritten) {
            return;
        }
        String controlFileName = this.getNewFileName(EXT, "");
        this.numRows = this.numRows > 500 ? Integer.valueOf(this.numRows / 10) : Integer.valueOf(50);
        String errors = "OPTIONS (ERRORS=" + this.numRows.toString() + ")" + this._ctlEOLChars;
        if (this._zipper == null) {
            if (!controlFileName.equals("")) {
                Writer ctlWriter = this.getNewWriter(controlFileName);
                this.addToControllingFile(controlFileName);
                ctlWriter.write(errors);
                ctlWriter.write(this.header.toString());
                ctlWriter.close();
            }
        } else if (this._zipper != null) {
            this._zipper.closeEntry();
            this._zipper.openEntry(controlFileName);
            this.write(errors);
            this.write(this.header.toString());
            this._zipper.closeEntry();
            for (String s : this._createdFiles) {
                this._zipper.writeFileEntry(s);
                File file = new File(s);
                file.delete();
            }
        }
        this._createdFiles = new ArrayList();
    }

    @Override
    public Boolean getPromptForTable() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isTableNameSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return true;
    }

    @Override
    public boolean isEnclosuresSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    @Override
    public String handleSpecialEnclosure(String value) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char thisChar = value.charAt(i);
            if (thisChar == '\'') {
                sb.append('\\');
                sb.append(thisChar);
                continue;
            }
            sb.append(thisChar);
        }
        return sb.toString();
    }

    @Override
    public String getEnclosuresConfigKey() {
        return KEY_ENCLOSURES;
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    @Override
    public boolean isEnclosureRightDoubleConfigurable() {
        return false;
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }

    public boolean allowLobs() {
        return true;
    }

    @Override
    public boolean isTextEditorReadable() {
        return false;
    }

    @Override
    public boolean isSeparateDataFileSupported() {
        return true;
    }

    @Override
    public String getSeparateDataFileConfigKey() {
        return KEY_SEPARATE_DATA_FILE;
    }

    @Override
    public void isSeparateDataFile(boolean value) {
        this._isSeparateDataFile = value;
    }

    @Override
    public boolean isSeparateDataFile() {
        return this._isSeparateDataFile;
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

