/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.util.ArrayList;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.NLSUtils;

public class DelimitedFormatter
extends ResultsFormatter {
    public static final String TYPE = "Delimited";
    public static final String EXT = "dsv";
    public static final String DEFAULT_DELIMITER = ",";
    public static final String KEY_HEADER = "EXPORT_DLM_HEADER";
    public static final String KEY_DELIMITER = "EXPORT_DLM_DELIMITER";
    public static final String KEY_REC_TERM = "EXPORT_DLM_REC_TERM";
    public static final String KEY_ENCLOSURES = "EXPORT_DLM_ENCLOSURES";
    public static final String KEY_ENCL_LEFT = "EXPORT_DLM_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "EXPORT_DLM_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "EXPORT_DLM_ENCL_RIGHT_DOUBLE";
    private static String s_delim = ",";
    private boolean _isHeader;
    private ArrayList<String> m_colnames = null;
    private ArrayList<String> m_currRow = null;

    public DelimitedFormatter() {
        super(TYPE, Messages.getString("FixedFormatter.4"), EXT);
    }

    public DelimitedFormatter(String type, String filter, String ext) {
        super(type, filter, ext);
    }

    @Override
    public void start() throws IOException {
        String enclosureRight;
        this.m_colnames = new ArrayList();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.m_colnames.add(this.getColumnName(i));
        }
        if (this.getScriptContext() != null) {
            String[] formatterOptions = (String[])this.getScriptContext().getProperty("sql.format.full");
            if (formatterOptions != null && formatterOptions.length > 3) {
                this._delimiter = formatterOptions[3];
            }
            if (formatterOptions != null && formatterOptions.length > 4) {
                this._enclosureLeft = formatterOptions[4];
            }
            if (formatterOptions != null && formatterOptions.length > 5) {
                this._enclosureRight = formatterOptions[5];
            }
        }
        if (this._delimiter == null) {
            this._delimiter = s_delim;
        }
        String enclosureLeft = this._isEnclosed ? this._enclosureLeft : "";
        String string = enclosureRight = this._isEnclosed ? this._enclosureRight : "";
        if (this.isHeader()) {
            int size = this.getColumnCount();
            for (int i = 0; i < size; ++i) {
                String name = this.getColumnName(i);
                if (i < size - 1) {
                    this.write(enclosureLeft + name + enclosureRight + this._delimiter);
                    continue;
                }
                this.write(enclosureLeft + name + enclosureRight);
            }
            this.write(this.getLineTerminator());
        }
    }

    @Override
    public void startRow() throws IOException {
        this.m_currRow = new ArrayList();
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        String val;
        String colm = "";
        String enclosureLeft = this._enclosureLeft;
        String enclosureRight = this._enclosureRight;
        String delimiter = this._delimiter == null ? s_delim : this._delimiter;
        int type = this.getDataType(viewIndex);
        boolean isEnclosureRightDouble = false;
        if (type == 1 && this._isEnclosed || type == -16 || type == -1 || type == -15 || type == -9 || type == 12 || type == 2005) {
            if (this._isEnclosureRightDoubled) {
                isEnclosureRightDouble = true;
            }
        } else {
            enclosureLeft = "";
            enclosureRight = "";
        }
        String string = val = type == 2004 ? "(BLOB)" : NLSUtils.format(this.getConnection(), col);
        if (val != null) {
            if (col != null) {
                String value = isEnclosureRightDouble ? this.enclosureRightDouble(val.toString()) : val.toString();
                colm = delimiter + enclosureLeft + value + enclosureRight;
            } else {
                enclosureLeft = "";
                enclosureRight = "";
                colm = delimiter + val.toString();
            }
            this.m_currRow.add(val);
        } else {
            colm = delimiter + enclosureLeft + enclosureRight;
        }
        if (viewIndex == 0) {
            this.write(enclosureLeft + (enclosureLeft.trim().length() > 0 ? colm.substring(delimiter.length() + 1) : colm.substring(delimiter.length())));
        } else {
            this.write(colm);
        }
    }

    @Override
    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
        ArrayList<String> lastData = null;
        if (this.m_currRow != null && !this.m_currRow.isEmpty()) {
            lastData = new ArrayList<String>();
            lastData.add("");
            for (int i = 0; i < this.m_currRow.size(); ++i) {
                lastData.add(this.m_currRow.get(i));
            }
        }
        if (this.getScriptContext() != null && this.getScriptContext().getColumnMap() != null && !this.getScriptContext().getColumnMap().isEmpty() && this.m_colnames != null && lastData != null) {
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("");
            for (int i = 0; i < this.m_colnames.size(); ++i) {
                columns.add(this.m_colnames.get(i));
            }
            if (lastData != null && this.getScriptContext() != null && columns.size() == lastData.size()) {
                this.getScriptContext().updateColumn(columns.toArray(new String[columns.size()]), lastData.toArray(new String[lastData.size()]), null);
            }
        }
    }

    @Override
    public void setTableName(String tName) {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isHeaderOptionSupported() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return true;
    }

    @Override
    public boolean isEnclosuresSupported() {
        return true;
    }

    @Override
    public void isHeader(boolean isHeader) {
        this._isHeader = isHeader;
    }

    @Override
    public boolean isHeader() {
        return this._isHeader;
    }

    @Override
    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    @Override
    public String getEnclosuresConfigKey() {
        return KEY_ENCLOSURES;
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }

    @Override
    public String getLineTerminator() {
        if (this._EOLChars == null) {
            super.getLineTerminator();
        }
        return this._EOLChars;
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

