/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.values;

import java.util.List;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;

public class DataValueMapped
implements DataValue {
    private DataValue typedDataValue;
    private DataValue bindingDataValue;

    public DataValueMapped(DataValue typedDataValue, DataValue bindingDataValue) {
        this.typedDataValue = typedDataValue;
        this.bindingDataValue = bindingDataValue;
    }

    @Override
    public final StringValue getStringValue() {
        return this.typedDataValue.getStringValue();
    }

    @Override
    public final StringValue getStringValue(int maxLen) {
        return this.typedDataValue.getStringValue(maxLen);
    }

    @Override
    public final StringValue getStringValue(StringType stringType) {
        return this.typedDataValue.getStringValue(stringType);
    }

    @Override
    public final StringValue getStringValue(StringType stringType, int maxLen) {
        return this.typedDataValue.getStringValue(stringType, maxLen);
    }

    @Override
    public final StringValue getStringValue(DataTypeConnectionProvider connectionProvider, StringType stringType) {
        return this.getStringValue(connectionProvider, stringType, -1);
    }

    @Override
    public final StringValue getStringValue(DataTypeConnectionProvider connectionProvider, StringType stringType, int maxLen) {
        return this.typedDataValue.getStringValue(connectionProvider, stringType, maxLen);
    }

    @Override
    public final Object getTypedValue() {
        return this.typedDataValue.getTypedValue();
    }

    @Override
    public final Object getTypedValue(ValueType valueType) {
        switch (valueType) {
            case JDBC: 
            case DATUM: {
                return this.bindingDataValue.getTypedValue(valueType);
            }
        }
        return this.typedDataValue.getTypedValue(valueType);
    }

    @Override
    public final Object getTypedValue(Object target) {
        return this.bindingDataValue.getTypedValue(target);
    }

    @Override
    public final Object getTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        return this.getTypedValue(connectionProvider, valueType, null);
    }

    @Override
    public final Object getTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) {
        switch (valueType) {
            case JDBC: 
            case DATUM: 
            case TARGET: {
                return this.bindingDataValue.getTypedValue(connectionProvider, valueType, target);
            }
        }
        return this.typedDataValue.getTypedValue(connectionProvider, valueType, target);
    }

    public final DataValue getTypingDataValue() {
        return this.typedDataValue;
    }

    public final DataValue getTypingDataValueRecursive() {
        if (this.typedDataValue instanceof DataValueMapped) {
            return ((DataValueMapped)this.typedDataValue).getTypingDataValueRecursive();
        }
        return this.typedDataValue;
    }

    @Override
    public final DataValue getBindingDataValue() {
        return this.bindingDataValue;
    }

    public String toString() {
        return this.typedDataValue.toString();
    }

    @Override
    public final boolean isNull() {
        return this.typedDataValue.isNull();
    }

    @Override
    public final void marshal(DataValueMarshalHandler hd, String name) {
        hd.marshal(this.typedDataValue, name);
    }

    @Override
    public final void marshal(DataValueMarshalHandler hd) {
        hd.marshal(this.typedDataValue);
    }

    @Override
    public final boolean isSupported() {
        return this.typedDataValue.isSupported();
    }

    @Override
    public final List<DataValue> getComponents() {
        return this.typedDataValue.getComponents();
    }

    @Override
    public final String getName() {
        return this.typedDataValue.getName();
    }

    @Override
    public final DataType getDataType() {
        return this.typedDataValue.getDataType();
    }

    public boolean equals(Object obj) {
        boolean isEquals;
        boolean bl = isEquals = this == obj;
        if (!isEquals) {
            if (obj instanceof NamedDataValue) {
                isEquals = obj.equals(this);
            } else if (obj instanceof DataValueMapped) {
                isEquals = this.customEquals(obj);
            }
        }
        return isEquals;
    }

    protected boolean customEquals(Object obj) {
        if (obj instanceof DataValueMapped) {
            DataValueMapped objMappedValue = (DataValueMapped)obj;
            return DataValueMapped.areEquals(this.typedDataValue, objMappedValue.typedDataValue) && DataValueMapped.areEquals(this.bindingDataValue, objMappedValue.bindingDataValue);
        }
        return false;
    }

    private static boolean areEquals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }
}

