/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.util;

public class StringValue
implements CharSequence {
    protected String value;
    protected long maxLength;

    public StringValue(CharSequence value, long maxLen) {
        this.value = value == null ? null : value.toString();
        this.maxLength = maxLen;
    }

    public StringValue(CharSequence value) {
        this(value, value == null ? -1L : (long)value.length());
    }

    public StringValue() {
        this(null, -1L);
    }

    @Override
    public String toString() {
        return this.value;
    }

    public int getLength() {
        return this.value == null ? -1 : this.value.length();
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public boolean isTruncated() {
        return (long)this.getLength() < this.getMaxLength();
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new StringValue(this.value.subSequence(start, end), this.maxLength);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringValue) {
            StringValue objStringValue = (StringValue)obj;
            return this.maxLength == objStringValue.maxLength && StringValue.areEquals(this.value, objStringValue.value);
        }
        return false;
    }

    private static boolean areEquals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }
}

