/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.util.TemporalUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;

public abstract class TemporalDatum
extends Datum {
    protected TemporalDatum(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        switch (stringType) {
            case NLS: {
                try {
                    return new StringValue((CharSequence)NLSUtils.getValue(connectionProvider.getNLSConnection(), value.getInternalValue()));
                }
                catch (NullPointerException e) {
                    return this.customStringValue(connectionProvider, value, StringType.GENERIC, maxLen);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return Timestamp.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        if (value instanceof TIMESTAMP) {
            try {
                return ((TIMESTAMP)value).timestampValue();
            }
            catch (SQLException e) {
                return value;
            }
        }
        if (value instanceof DATE) {
            return ((DATE)value).timestampValue();
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof CharSequence) {
            String stringValue = value.toString();
            try {
                if (TemporalUtil.isTimestamp(stringValue)) {
                    return TemporalUtil.toTimestamp(stringValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (Exception e1) {
                try {
                    return new Timestamp(java.sql.Date.valueOf(stringValue).getTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return value;
    }
}

