/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraConstants;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.sql.Datum;

public abstract class OraTemporalDatum
implements OraConstants,
Cloneable,
Comparable<OraTemporalDatum> {
    public static final String TIMEZONE = "TIMEZONE";
    public static final String TIME = "TIME";
    public static final String NANOS = "NANOS";
    public static final String PRECISION = "PRECISION";
    public static final String FRACTIONALPRECISION = "FRACTIONALPRECISION";
    protected OraTemporalDatumImpl datumImpl;
    protected boolean sessionTimeZoneAdjusted;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static final GregorianCalendar getGregorianInstance() {
        return OraTemporalDatum.getGregorianInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static final GregorianCalendar getGregorianInstance(TimeZone timezone) {
        return OraTemporalDatum.getGregorianInstance(timezone, Locale.getDefault());
    }

    public static final GregorianCalendar getGregorianInstance(Locale locale) {
        return OraTemporalDatum.getGregorianInstance(TimeZone.getDefault(), locale);
    }

    public static final GregorianCalendar getGregorianInstance(TimeZone timezone, Locale locale) {
        final TimeZone ftz = timezone;
        final Locale floc = locale;
        GregorianCalendar calendar = (GregorianCalendar)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GregorianCalendar(ftz, floc);
            }
        });
        return calendar;
    }

    public static final boolean overlayTimeZone(Calendar calendar, TimeZone timezone) {
        boolean changed = false;
        if (!OraTemporalDatum.areEqual(timezone, calendar.getTimeZone())) {
            OraTemporalDatum.recompute(calendar);
            Calendar cal = (Calendar)calendar.clone();
            calendar.setTimeZone(timezone);
            calendar.set(0, cal.get(0));
            calendar.set(1, cal.get(1));
            calendar.set(2, cal.get(2));
            calendar.set(5, cal.get(5));
            calendar.set(11, cal.get(11));
            calendar.set(12, cal.get(12));
            calendar.set(13, cal.get(13));
            calendar.set(14, cal.get(14));
            changed = true;
        }
        OraTemporalDatum.recompute(calendar);
        return changed;
    }

    public static final Calendar recompute(Calendar cal) {
        cal.get(11);
        return cal;
    }

    protected static final boolean areEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    protected OraTemporalDatum(OraTemporalDatumImpl dataumImpl, boolean sessionTimeZoneAdjusted) {
        this.datumImpl = dataumImpl;
        this.sessionTimeZoneAdjusted = sessionTimeZoneAdjusted;
    }

    protected OraTemporalDatum(OraTemporalDatumImpl dataumImpl) {
        this(dataumImpl, false);
    }

    public final void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.datumImpl.addPropertyChangeListener(pcl);
    }

    public final void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.datumImpl.removePropertyChangeListener(pcl);
    }

    public abstract Datum getDatum();

    public boolean nanosSupported() {
        return true;
    }

    public boolean userTimeZoneSupported() {
        return false;
    }

    public boolean timeZoneOverlayed() {
        return false;
    }

    public final void setFractionalPrecision(int precision) {
        if (this.nanosSupported()) {
            this.datumImpl.setFractionalPrecision(precision);
        }
    }

    public final int getFractionalPrecision() {
        return this.datumImpl.getFractionalPrecision();
    }

    public final void setPrecision(Precision precision) {
        this.datumImpl.setPrecision(precision);
    }

    public final Precision getPrecision() {
        return this.datumImpl.getPrecision();
    }

    public final void setLocale(Locale locale) {
        this.datumImpl.setLocale(locale);
    }

    public final void setLocale(Calendar localeCalendar) {
        this.datumImpl.setLocale(localeCalendar);
    }

    public final GregorianCalendar getCalendar() {
        return this.datumImpl.getCalendar();
    }

    public final Calendar getCalendar(Calendar target) {
        return this.datumImpl.getCalendar(target);
    }

    public final void setCalendar(Calendar calendar) {
        this.setCalendar(calendar, null);
    }

    public final void setCalendar(Calendar calendar, Integer nanos) {
        this.setTimeZone(calendar.getTimeZone());
        this.setTimeInMillis(calendar.getTimeInMillis(), nanos);
    }

    public final Timestamp toTimestamp() {
        Timestamp ts = new Timestamp(this.getTimeInMillis());
        ts.setNanos(this.getNanos());
        return ts;
    }

    public final void setToday() {
        this.datumImpl.setToday();
    }

    public final void setNow() {
        this.datumImpl.setNow();
    }

    public final void add(int field, int amount) {
        this.datumImpl.add(field, amount);
    }

    public final void set(int field, int value) {
        this.datumImpl.set(field, value);
    }

    public final int get(int field) {
        return this.datumImpl.get(field);
    }

    public void replicate(OraTemporalDatum value) {
        this.setPrecision(value.getPrecision());
        this.setFractionalPrecision(value.getFractionalPrecision());
        this.setValue(value);
        if (value.sessionTimeZoneAdjusted) {
            this.setSessionTimeZone(value.getSessionTimeZone());
        } else {
            this.setTimeZone(value.getTimeZone());
        }
        this.sessionTimeZoneAdjusted = value.sessionTimeZoneAdjusted;
    }

    public void setValue(OraTemporalDatum value) {
        OraTemporalDatum src = value;
        if (!OraTemporalDatum.areEqual(this.getTimeZone(), src.getTimeZone())) {
            src = (OraTemporalDatum)value.clone();
            src.setTimeZone(this.getTimeZone());
            if (this.userTimeZoneSupported()) {
                this.setTimeZone(value.getTimeZone());
            }
        }
        this.setTimeInMillis(src.getTimeInMillis(), src.getNanos());
    }

    public final void setTimeInMillis(long timeInMillis) {
        this.setTimeInMillisFractional(timeInMillis, null);
    }

    public final void setTimeInMillis(long timeInMillis, Integer nanos) {
        if (nanos == null) {
            this.setTimeInMillisFractional(timeInMillis, 0);
        } else {
            this.setTimeInMillisFractional(timeInMillis, -1);
            this.setNanos(nanos);
        }
    }

    protected void setTimeInMillisFractional(long timeInMillis, Integer nanosAsfactionalMillis) {
        this.datumImpl.setTimeInMillis(timeInMillis, nanosAsfactionalMillis);
    }

    public final long getTimeInMillis() {
        return this.datumImpl.getTimeInMillis();
    }

    public final void setTime(java.util.Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public final java.util.Date getTime() {
        return new java.util.Date(this.getTimeInMillis());
    }

    public final void setDate(Date date) {
        this.setTime(date);
    }

    public final Date getDate() {
        return new Date(this.getTimeInMillis());
    }

    public final void setNanos(int nanos) {
        this.datumImpl.setNanos(nanos);
    }

    public final int getNanos() {
        return this.datumImpl.getNanos();
    }

    public void setTimeZone(TimeZone timezone) {
        this.datumImpl.setTimeZone(timezone);
    }

    public TimeZone getTimeZone() {
        return this.datumImpl.getTimeZone();
    }

    public TimeZone getSessionTimeZone() {
        return this.sessionTimeZoneAdjusted ? this.getTimeZone() : null;
    }

    public abstract void setSessionTimeZone(TimeZone var1);

    public final void recompute() {
        this.datumImpl.recompute();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        OraTemporalDatum another = (OraTemporalDatum)obj;
        return OraTemporalDatum.areEqual(this.datumImpl, another.datumImpl);
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.datumImpl.hashCode();
        return hash;
    }

    @Override
    public int compareTo(OraTemporalDatum another) {
        int ret = 0;
        if (this != another) {
            ret = this.datumImpl.compareTo(another.datumImpl);
        }
        return ret;
    }

    public Object clone() {
        try {
            OraTemporalDatum other = (OraTemporalDatum)super.clone();
            other.datumImpl = (OraTemporalDatumImpl)this.datumImpl.clone();
            other.sessionTimeZoneAdjusted = this.sessionTimeZoneAdjusted;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static enum Precision {
        NANOSECOND(0),
        MILLISECOND(1),
        SECOND(1000),
        MINUTE(60000),
        HOUR(3600000),
        DATE(86400000);

        private final int milliSecondFactor;
        private final int nanoSecondFactor;

        private Precision(int milliSecondFactor) {
            this.milliSecondFactor = milliSecondFactor;
            this.nanoSecondFactor = milliSecondFactor * 1000000;
        }

        public int getMilliSecondFactor() {
            return this.milliSecondFactor;
        }

        public int getNanoSecondFactor() {
            return this.nanoSecondFactor;
        }
    }

    protected static abstract class OraTemporalDatumImpl
    implements OraConstants,
    Cloneable,
    Comparable<OraTemporalDatumImpl> {
        private PropertyChangeSupport changesSupport;
        private GregorianCalendar calendar;
        private int nanos;
        private Precision precision;
        private int fractionalPrecision;
        private long lastReportedMillis;

        protected void addPropertyChangeListener(PropertyChangeListener pcl) {
            this.changesSupport.addPropertyChangeListener(pcl);
        }

        protected void removePropertyChangeListener(PropertyChangeListener pcl) {
            this.changesSupport.removePropertyChangeListener(pcl);
        }

        private void fireTimeInMillisChange(long oldMillis, long newMillis) {
            this.lastReportedMillis = newMillis;
            this.changesSupport.firePropertyChange(OraTemporalDatum.TIME, oldMillis, newMillis);
        }

        private void fireNanosChange(int oldNanos, int newNanos) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.NANOS, oldNanos, newNanos);
        }

        private void fireTimeZoneChange(TimeZone oldTz, TimeZone newTz) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.TIMEZONE, oldTz, newTz);
        }

        private void firePrecisionChange(Precision oldPrecision, Precision newPrecision) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.PRECISION, (Object)oldPrecision, (Object)newPrecision);
        }

        private void fireFractionalPrecisionChange(int oldFractionPrecision, int newFractionalPrecision) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.FRACTIONALPRECISION, oldFractionPrecision, newFractionalPrecision);
        }

        private static final void copyWeekCountData(Calendar src, Calendar tgt) {
            tgt.setFirstDayOfWeek(src.getFirstDayOfWeek());
            tgt.setMinimalDaysInFirstWeek(src.getMinimalDaysInFirstWeek());
        }

        private static final void copyTimeComponents(Calendar src, Calendar tgt) {
            tgt.setTimeInMillis(src.getTimeInMillis());
            OraTemporalDatumImpl.copyWeekCountData(src, tgt);
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone datumTimeZone) {
            return OraTemporalDatumImpl.getDatumStorageCalendar(datumTimeZone, true);
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone datumTimeZone, boolean clear) {
            return OraTemporalDatumImpl.getDatumStorageCalendar(datumTimeZone, Locale.US, clear);
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone datumTimeZone, Locale locale) {
            return OraTemporalDatumImpl.getDatumStorageCalendar(datumTimeZone, locale, true);
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone datumTimeZone, Locale locale, boolean clear) {
            GregorianCalendar cal = OraTemporalDatum.getGregorianInstance(datumTimeZone, locale);
            if (clear) {
                cal.clear();
                OraTemporalDatum.recompute(cal);
            }
            return cal;
        }

        private static final GregorianCalendar getDatumStorageCalendar(TimeZone datumTimeZone, Calendar calendar) {
            GregorianCalendar cal = OraTemporalDatumImpl.getDatumStorageCalendar(datumTimeZone);
            OraTemporalDatumImpl.copyTimeComponents(calendar, cal);
            OraTemporalDatum.recompute(cal);
            return cal;
        }

        private OraTemporalDatumImpl(GregorianCalendar calendar, Integer nanos, TimeZone datumTimeZone) {
            this.calendar = calendar;
            this.nanos = 0;
            this.lastReportedMillis = 0L;
            this.precision = Precision.NANOSECOND;
            this.fractionalPrecision = 9;
            this.changesSupport = new PropertyChangeSupport(this);
            this.setTimeInMillis(calendar.getTimeInMillis());
            if (nanos != null) {
                this.setNanos(nanos);
            }
            this.recompute();
        }

        protected OraTemporalDatumImpl(TimeZone datumTimeZone, Calendar calendar, Integer nanos) {
            this(OraTemporalDatumImpl.getDatumStorageCalendar(datumTimeZone, calendar), nanos, datumTimeZone);
        }

        protected OraTemporalDatumImpl(TimeZone datumTimeZone) {
            this(OraTemporalDatumImpl.getDatumStorageCalendar(datumTimeZone), null, datumTimeZone);
        }

        protected OraTemporalDatumImpl(TimeZone datumTimeZone, Timestamp timestamp) {
            this(datumTimeZone);
            this.setTime(timestamp);
            this.recompute();
        }

        protected OraTemporalDatumImpl(TimeZone datumTimeZone, Datum date) {
            this(datumTimeZone);
            byte[] bytes = this.getDatumBytes(date);
            this.unpackDatumBytes(bytes);
            this.recompute();
        }

        protected final void setToday() {
            GregorianCalendar now = OraTemporalDatumImpl.getDatumStorageCalendar(this.getTimeZone(), false);
            this.set(0, now.get(0));
            this.set(1, now.get(1));
            this.set(2, now.get(2));
            this.set(5, now.get(5));
            this.recompute();
        }

        protected final void setNow() {
            long millis = OraTemporalDatumImpl.getDatumStorageCalendar(this.getTimeZone(), false).getTimeInMillis();
            this.setTimeInMillis(millis, 0);
        }

        protected final void setLocale(Locale locale) {
            GregorianCalendar localeTemplate = OraTemporalDatum.getGregorianInstance(locale);
            this.setLocale(localeTemplate);
        }

        protected final void setLocale(Calendar localeTemplate) {
            OraTemporalDatumImpl.copyWeekCountData(localeTemplate, this.calendar);
        }

        protected final void setFractionalPrecision(int precision) {
            if (precision < 0 || precision > 9) {
                throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.65"));
            }
            if (precision != this.fractionalPrecision) {
                int oldPrecision = this.fractionalPrecision;
                this.fractionalPrecision = precision;
                if (precision < oldPrecision) {
                    this.setNanos(this.getNanos());
                }
                this.fireFractionalPrecisionChange(oldPrecision, precision);
                if (precision > oldPrecision) {
                    this.setNanos(this.getNanos());
                }
            }
        }

        protected final int getFractionalPrecision() {
            return this.fractionalPrecision;
        }

        protected final void setPrecision(Precision precision) {
            if (precision != this.precision) {
                Precision oldPrecision = this.precision;
                this.precision = precision;
                if (precision.getMilliSecondFactor() > oldPrecision.getMilliSecondFactor()) {
                    this.setTimeInMillis(this.getTimeInMillis());
                }
                this.firePrecisionChange(oldPrecision, precision);
                if (precision.getMilliSecondFactor() < oldPrecision.getMilliSecondFactor()) {
                    this.setTimeInMillis(this.getTimeInMillis());
                }
            }
        }

        protected final Precision getPrecision() {
            return this.precision;
        }

        protected abstract int getDatumLength(int var1);

        protected abstract boolean isDatumLengthValid(int var1);

        protected byte[] getDatumBytes(Datum datum) {
            byte[] bytes = datum.shareBytes();
            if (this.isDatumLengthValid(bytes.length)) {
                return bytes;
            }
            throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.60"));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            OraTemporalDatumImpl another = (OraTemporalDatumImpl)obj;
            return this.nanos == another.nanos && this.fractionalPrecision == another.fractionalPrecision && this.precision == another.precision && this.calendar.equals(another.calendar);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + this.calendar.hashCode();
            hash = hash * 31 + Integer.valueOf(this.nanos).hashCode();
            hash = hash * 31 + this.precision.hashCode();
            hash = hash * 31 + Integer.valueOf(this.fractionalPrecision).hashCode();
            return hash;
        }

        @Override
        public int compareTo(OraTemporalDatumImpl another) {
            int ret = 0;
            if (this != another && (ret = this.calendar.compareTo(another.calendar)) == 0 && this.nanos != another.nanos) {
                if (this.nanos < another.nanos) {
                    ret = -1;
                } else if (this.nanos > another.nanos) {
                    ret = 1;
                }
            }
            return ret;
        }

        public Object clone() {
            try {
                OraTemporalDatumImpl other = (OraTemporalDatumImpl)super.clone();
                OraTemporalDatum.recompute(this.calendar);
                other.calendar = (GregorianCalendar)this.calendar.clone();
                other.nanos = this.nanos;
                other.precision = this.precision;
                other.fractionalPrecision = this.fractionalPrecision;
                other.lastReportedMillis = 0L;
                other.changesSupport = new PropertyChangeSupport(other);
                return other;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        protected void add(int field, int amount) {
            this.calendar.add(field, amount);
        }

        protected void set(int field, int value) {
            this.calendar.set(field, value);
        }

        protected int get(int field) {
            return this.calendar.get(field);
        }

        protected final GregorianCalendar getCalendar() {
            GregorianCalendar cal = (GregorianCalendar)this.calendar.clone();
            return cal;
        }

        protected final Calendar getCalendar(Calendar target) {
            target.setTimeInMillis(this.getTimeInMillis());
            target.setTimeZone(this.getTimeZone());
            return target;
        }

        protected final TimeZone getTimeZone() {
            return this.calendar.getTimeZone();
        }

        protected final boolean setTimeZone(TimeZone timezone) {
            boolean changed = false;
            TimeZone oldTz = this.calendar.getTimeZone();
            if (!OraTemporalDatum.areEqual(timezone, oldTz)) {
                this.recompute();
                this.calendar.setTimeZone(timezone);
                changed = true;
                this.recompute();
                this.fireTimeZoneChange(oldTz, timezone);
            }
            return changed;
        }

        protected final void clear() {
            this.nanos = 0;
            this.calendar.clear();
        }

        protected void recompute() {
            OraTemporalDatum.recompute(this.calendar);
            this.setTimeInMillis(this.getTimeInMillis(), -1);
            this.setNanos(this.getNanos());
        }

        protected final void overlayTimeInMillis(long fractionalSecondsInMillis) {
            long oldMillis = this.calendar.getTimeInMillis();
            long newMillis = oldMillis / 1000L * 1000L + fractionalSecondsInMillis;
            this.setTimeInMillis(newMillis, -1);
        }

        protected final void overlayNanos(long fractionalSecondsInMillis) {
            int oldNanos = this.nanos;
            int newNanos = (int)(fractionalSecondsInMillis * 1000000L + (long)(oldNanos % 1000000));
            this.setNanos(newNanos);
        }

        protected final boolean overlayTimeZone(TimeZone timezone) {
            TimeZone oldTz = this.calendar.getTimeZone();
            boolean changed = OraTemporalDatum.overlayTimeZone(this.calendar, timezone);
            if (changed) {
                this.recompute();
                this.fireTimeZoneChange(oldTz, timezone);
            }
            return changed;
        }

        protected final long getTimeInMillis() {
            return this.calendar.getTimeInMillis();
        }

        protected final void setTimeInMillis(long timeInMillis) {
            this.setTimeInMillis(timeInMillis, null);
        }

        protected final void setTimeInMillis(long timeInMillis, Integer nanosAsfactionalMillis) {
            long newMillis;
            long oldMillis;
            int factor;
            long truncatedTimeInMillis = timeInMillis;
            if (this.fractionalPrecision <= 3) {
                factor = (int)Math.pow(10.0, 3 - this.fractionalPrecision);
                double shiftedMillis = (double)timeInMillis * 1.0 / (double)factor;
                long roundedMillis = Math.round(shiftedMillis);
                truncatedTimeInMillis = roundedMillis * (long)factor;
            }
            if (this.precision != Precision.NANOSECOND) {
                factor = this.precision.getMilliSecondFactor();
                truncatedTimeInMillis = truncatedTimeInMillis / (long)factor * (long)factor;
            }
            if ((oldMillis = this.calendar.getTimeInMillis()) != (newMillis = truncatedTimeInMillis)) {
                this.calendar.setTimeInMillis(newMillis);
                this.fireTimeInMillisChange(oldMillis, newMillis);
            } else if (timeInMillis != newMillis) {
                this.fireTimeInMillisChange(timeInMillis, newMillis);
            }
            if (this.lastReportedMillis != newMillis) {
                this.fireTimeInMillisChange(this.lastReportedMillis, newMillis);
            }
            if (nanosAsfactionalMillis != null || oldMillis != newMillis) {
                long fractionalSecondsInMillis = truncatedTimeInMillis % 1000L;
                if (fractionalSecondsInMillis < 0L) {
                    fractionalSecondsInMillis = 1000L + fractionalSecondsInMillis;
                }
                if (nanosAsfactionalMillis == null) {
                    this.overlayNanos(fractionalSecondsInMillis);
                } else if (nanosAsfactionalMillis >= 0) {
                    int newNanos = (int)(fractionalSecondsInMillis * 1000000L + (long)nanosAsfactionalMillis.intValue());
                    this.setNanos(newNanos);
                }
            }
        }

        protected final void setTime(Timestamp timestamp) {
            this.setTimeInMillis(timestamp.getTime(), -1);
            this.setNanos(timestamp.getNanos());
        }

        protected final int getNanos() {
            return this.nanos;
        }

        protected final void setNanos(int nanos) {
            int newNanos;
            int oldNanos;
            if (nanos > 999999999 || nanos < 0) {
                throw new IllegalArgumentException("nanos > 999999999 or < 0");
            }
            int truncatedNanos = nanos;
            int factor = (int)Math.pow(10.0, 9 - this.fractionalPrecision);
            double shiftedNanos = (double)nanos * 1.0 / (double)factor;
            long roundedNanos = Math.round(shiftedNanos);
            truncatedNanos = (int)(roundedNanos * (long)factor);
            if (this.precision != Precision.NANOSECOND) {
                factor = this.precision.getNanoSecondFactor();
                truncatedNanos = truncatedNanos / factor * factor;
            }
            if ((oldNanos = this.nanos) != (newNanos = truncatedNanos % 1000000000)) {
                this.nanos = newNanos;
                this.fireNanosChange(oldNanos, newNanos);
            } else if (nanos != newNanos) {
                this.fireNanosChange(nanos, newNanos);
            }
            if (oldNanos != newNanos) {
                long nanosInMillis = truncatedNanos / 1000000;
                this.overlayTimeInMillis(nanosInMillis);
            }
        }

        protected void packDatumBytes(byte[] bytes) {
            OraTemporalDatumImpl.packDateTime(bytes, this.calendar);
        }

        protected void unpackDatumBytes(byte[] bytes) {
            OraTemporalDatumImpl.unpackDateTime(bytes, this.calendar);
        }

        private static final void unpackDateTime(byte[] bytes, Calendar calendar) {
            int year = OraConversions.convertYear(bytes);
            if (year < 0) {
                calendar.set(0, 0);
            }
            if (year > 0) {
                calendar.set(0, 1);
            }
            calendar.set(1, Math.abs(year));
            calendar.set(2, bytes[2] - 1);
            calendar.set(5, bytes[3]);
            calendar.set(11, bytes[4] - 1);
            calendar.set(12, bytes[5] - 1);
            calendar.set(13, bytes[6] - 1);
            calendar.set(14, 0);
        }

        private static final void packDateTime(byte[] bytes, Calendar calendar) {
            int year = calendar.get(1);
            bytes[0] = (byte)(year / 100 + 100);
            bytes[1] = (byte)(year % 100 + 100);
            bytes[2] = (byte)(calendar.get(2) + 1);
            bytes[3] = (byte)calendar.get(5);
            bytes[4] = (byte)(calendar.get(11) + 1);
            bytes[5] = (byte)(calendar.get(12) + 1);
            bytes[6] = (byte)(calendar.get(13) + 1);
        }
    }
}

