/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeMarshallingException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import org.xml.sax.SAXException;

public class DataValueImpl
implements DataValue {
    private final DataValueAccessor accessor = new DataValueAccessor();
    private final Object internalValue;
    private boolean valueIsNull;
    protected final DataTypeImpl datatype;

    protected DataValueImpl(DataTypeImpl datatype) {
        this(datatype, null);
    }

    protected DataValueImpl(DataTypeImpl datatype, Object value) {
        this.datatype = datatype;
        try {
            this.internalValue = datatype.getInternalValue(value);
            datatype.getTypedValue((DataValueInternal)this.accessor, ValueType.DEFAULT);
            this.valueIsNull = DataTypesUtil.isNull(this.internalValue);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeIllegalArgumentException dtiae) {
            throw dtiae;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, (Throwable)e);
        }
    }

    protected DataValueImpl(DataTypeImpl datatype, Collection<DataValue> internalValue) {
        this.datatype = datatype;
        try {
            this.internalValue = internalValue;
            datatype.getTypedValue((DataValueInternal)this.accessor, ValueType.DEFAULT);
            this.valueIsNull = DataTypesUtil.isNull(this.internalValue);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, (Throwable)e);
        }
    }

    @Override
    public final String getName() {
        return null;
    }

    @Override
    public final DataType getDataType() {
        return this.datatype;
    }

    @Override
    public DataValue getBindingDataValue() {
        return this;
    }

    @Override
    public final StringValue getStringValue() {
        return this.getStringValue(-1);
    }

    @Override
    public final StringValue getStringValue(StringType stringType) {
        return this.getStringValue(stringType, -1);
    }

    @Override
    public final StringValue getStringValue(int maxLen) {
        return this.getStringValue(StringType.DEFAULT, maxLen);
    }

    @Override
    public final StringValue getStringValue(StringType stringType, int maxLen) {
        try {
            return this.customStringValue(stringType, maxLen);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, (Throwable)e);
        }
    }

    protected StringValue customStringValue(StringType stringType, int maxLen) {
        return this.datatype.getStringValue(this.accessor, stringType, maxLen);
    }

    @Override
    public final StringValue getStringValue(DataTypeConnectionProvider connectionProvider, StringType stringType) {
        return this.getStringValue(connectionProvider, stringType, -1);
    }

    @Override
    public final StringValue getStringValue(DataTypeConnectionProvider connectionProvider, StringType stringType, int maxLen) {
        try {
            return this.customStringValue(connectionProvider, stringType, maxLen);
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (DataTypeException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, (Throwable)e);
        }
    }

    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, StringType stringType, int maxLen) {
        return this.datatype.getStringValue(connectionProvider, this.accessor, stringType, maxLen);
    }

    @Override
    public final Object getTypedValue() {
        return this.datatype.getTypedValue((DataValueInternal)this.accessor, ValueType.DEFAULT);
    }

    @Override
    public final Object getTypedValue(ValueType valueType) {
        return this.datatype.getTypedValue((DataValueInternal)this.accessor, valueType);
    }

    @Override
    public final Object getTypedValue(Object target) {
        return this.datatype.getTypedValue((DataValueInternal)this.accessor, target);
    }

    @Override
    public final Object getTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        return this.getTypedValue(connectionProvider, valueType, null);
    }

    @Override
    public final Object getTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) {
        return this.datatype.getTypedValue(connectionProvider, this.accessor, valueType, target);
    }

    public String toString() {
        try {
            return this.valueIsNull ? null : this.getStringValue(-1).toString();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return this.internalValue == null ? null : this.internalValue.toString();
        }
    }

    @Override
    public final boolean isNull() {
        return this.valueIsNull;
    }

    public final boolean equals(Object obj) {
        boolean isEquals;
        boolean bl = isEquals = this == obj;
        if (!isEquals) {
            if (obj instanceof NamedDataValue) {
                isEquals = obj.equals(this);
            } else if (obj instanceof DataValueImpl) {
                DataValueImpl otherDataValue = (DataValueImpl)obj;
                isEquals = this.getClass() == otherDataValue.getClass() && (this.isNull() && otherDataValue.isNull() || !this.isNull() && !otherDataValue.isNull() && this.customEquals(obj));
            }
        }
        return isEquals;
    }

    protected boolean customEquals(Object obj) {
        if (obj instanceof DataValueImpl) {
            DataValueImpl objDataValue = (DataValueImpl)obj;
            return DataValueImpl.areEquals(this.datatype, objDataValue.datatype) && this.datatype.equals(this.internalValue, objDataValue.internalValue);
        }
        return false;
    }

    private static boolean areEquals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    @Override
    public final void marshal(DataValueMarshalHandler hd, String name) {
        try {
            hd.startDataValue(this.getDataType(), name, this.isNull());
            if (!this.isNull()) {
                this.customMarshal(hd, name);
            }
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (Exception e) {
            throw new DataTypeMarshallingException(this, (Throwable)e);
        }
        finally {
            try {
                hd.endDataValue(this.getDataType(), name, this.isNull());
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    @Override
    public final void marshal(DataValueMarshalHandler hd) {
        hd.marshal(this, this.getName());
    }

    protected void customMarshal(DataValueMarshalHandler hd, String name) throws SAXException {
        this.datatype.marshal(this.accessor, hd, name);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public final List<DataValue> getComponents() {
        return this.customComponents();
    }

    protected List<DataValue> customComponents() {
        return this.datatype.getComponents(this.accessor);
    }

    private class DataValueAccessor
    implements DataValueInternal {
        private DataValueAccessor() {
        }

        @Override
        public Object getInternalValue() {
            return DataValueImpl.this.internalValue;
        }

        @Override
        public boolean isNull() {
            return DataValueImpl.this.valueIsNull;
        }
    }
}

