/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Service;

public class Util {
    public static void main(String[] args) throws Exception {
        String input = Service.readFile(Util.class, "test.sql.java");
        System.out.println(input);
        System.out.println(Util.javaToSQL(input));
    }

    static String javaToSQL(String input) {
        StringBuilder ret = new StringBuilder();
        List<LexerToken> src = LexerToken.parse(input);
        for (LexerToken t : src) {
            if (t.type == Token.DQUOTED_STRING) {
                ret.append(t.content.substring(1, t.content.length() - 1).replace("\\n", "\n"));
                continue;
            }
            if (t.type == Token.WS) {
                ret.append(t.content);
                continue;
            }
            if (t.type == Token.OPERATION && !"+".equals(t.content)) continue;
        }
        return ret.toString();
    }
}

