/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;

public class VersionTracker {
    private static final VersionTracker INSTANCE = new VersionTracker();
    private final Map<ConnectionIdentifier.Key, Version> cache = new HashMap<ConnectionIdentifier.Key, Version>();

    protected final VersionTracker getInstance() {
        return INSTANCE;
    }

    public static final Version getDbVersion(ConnectionIdentifier id) {
        return INSTANCE.getVersionImpl(id);
    }

    public static boolean checkVersion(ConnectionIdentifier id, Version maxver, Version minver) {
        return INSTANCE.checkVersionImpl(id, maxver, minver);
    }

    public static boolean checkVersion(Version dbVersion, Version maxver, Version minver) {
        return INSTANCE.checkVersionImpl(dbVersion, maxver, minver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Version getVersionImpl(ConnectionIdentifier id) {
        Connection conn = id.getConnection();
        if (conn == null) {
            return DBUtil.ORACLE10g_VERSION;
        }
        Version dbVersion = this.cache.get(id.getIdentifierKey());
        if (dbVersion == null) {
            dbVersion = DBUtil.getInstance(id).fetchDbVersion();
            Map<ConnectionIdentifier.Key, Version> map = this.cache;
            synchronized (map) {
                this.cache.put(id.getIdentifierKey(), dbVersion);
            }
        }
        return dbVersion;
    }

    private boolean checkVersionImpl(ConnectionIdentifier id, Version maxver, Version minver) {
        Version dbVersion;
        try {
            dbVersion = this.getVersionImpl(id);
        }
        catch (UnsupportedOperationException usoe) {
            dbVersion = null;
        }
        return this.checkVersionImpl(dbVersion, maxver, minver);
    }

    private boolean checkVersionImpl(Version dbVersion, Version maxver, Version minver) {
        boolean ret = false;
        if (dbVersion == null || (minver == null || minver.compareTo(dbVersion) <= 0) && (maxver == null || maxver.compareTo(dbVersion) >= 0)) {
            ret = true;
        }
        return ret;
    }
}

