/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;

public abstract class ConnectionSupport {
    static final String DEBUG_SUPPORT_PROPERTY = "dbtools.connection_support_debug";
    public static final boolean DEBUG = Boolean.getBoolean("dbtools.connection_support_debug");

    public static void setConnectionSupportImplementation(ConnectionSupport support) {
        if (support != null) {
            support.install();
        }
    }

    protected abstract LockManager lockManager();

    protected abstract ConnectionResolver connectionResolver();

    protected abstract DatabaseFeatureRegistry featureRegistry();

    private void install() throws IllegalStateException {
        ConnectionResolver.setConnectionResolver(this.connectionResolver());
        LockManager.setLockManager(this.lockManager());
        DatabaseFeatureRegistry.setFeatureRegistry(this.featureRegistry());
        this.installImpl();
    }

    protected void installImpl() throws IllegalStateException {
    }
}

