/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.readservice;

import java.util.Locale;
import java.util.logging.Logger;
import oracle.dbtools.data.common.TranslatableMessage;
import oracle.dbtools.data.loadservice.LoadResources;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.data.readservice.ReadResources;

public abstract class ReadService {
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private Iterable<Locale> _responseLocales;

    public abstract String getType();

    public abstract String getFormat();

    public abstract String[] getColumnNames() throws DataFormatException;

    public abstract void open();

    public abstract void start();

    public abstract boolean hasMoreRows();

    public abstract Object[] readline() throws DataFormatException;

    public abstract void close();

    protected Iterable<Locale> getResponseLocales() {
        return this._responseLocales;
    }

    protected void setResponseLocales(Iterable<Locale> responseLocales) {
        this._responseLocales = responseLocales;
    }

    protected void setLogger(Logger logger) {
        this.LOGGER = logger;
    }

    protected final String translate(String messageId, Object[] args) {
        if (this._responseLocales == null) {
            return ReadResources.format(messageId, args);
        }
        return new TranslatableMessage(LoadResources.class, messageId, ReadResources.format(messageId, args), args).toString(this._responseLocales);
    }

    protected final String translate(String messageId) {
        if (this._responseLocales == null) {
            return ReadResources.getString(messageId);
        }
        return new TranslatableMessage(ReadResources.class, messageId, ReadResources.getString(messageId), new Object[0]).toString(this._responseLocales);
    }
}

